/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import cytoscape.Cytoscape;
import cytoscape.ding.DingNetworkView;
import cytoscape.util.export.Exporter;
import cytoscape.view.CyNetworkView;
import cytoscape.view.InternalFrameComponent;
import java.awt.Graphics2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PDFExporter
implements Exporter {
    private boolean exportTextAsFont = true;

    public void export(CyNetworkView view, FileOutputStream stream) throws IOException {
        DingNetworkView theView = (DingNetworkView)view;
        theView.setPrintingTextAsShape(!this.exportTextAsFont);
        InternalFrameComponent ifc = Cytoscape.getDesktop().getNetworkViewManager().getInternalFrameComponent(view);
        Rectangle pageSize = PageSize.LETTER;
        Document document = new Document(pageSize);
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)stream);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            Graphics2D g = null;
            g = this.exportTextAsFont ? cb.createGraphics(pageSize.getWidth(), pageSize.getHeight(), (FontMapper)new DefaultFontMapper()) : cb.createGraphicsShapes(pageSize.getWidth(), pageSize.getHeight());
            double imageScale = Math.min((double)pageSize.getWidth() / (double)ifc.getWidth(), (double)pageSize.getHeight() / (double)ifc.getHeight());
            g.scale(imageScale, imageScale);
            ifc.print(g);
            g.dispose();
        }
        catch (DocumentException exp) {
            throw new IOException(exp.getMessage());
        }
        document.close();
    }

    public void setExportTextAsFont(boolean pExportTextAsFont) {
        this.exportTextAsFont = pExportTextAsFont;
    }
}

