/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTask;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipUtil {
    public static final int DEF_COMPRESSION_LEVEL = 1;
    private String zipArchiveName;
    private String[] inputFiles;
    private String inputFileDir;
    private int fileCount;
    private String sessionDirName;
    private HashMap pluginFileMap = null;
    private static final String FS = "/";

    public ZipUtil(String zipFile, String[] fileNameList, String sessionDir) {
        this(zipFile, fileNameList, sessionDir, "");
    }

    public ZipUtil(String zipFile, String[] fileNameList, String sessionDir, String fileDir) {
        this.zipArchiveName = zipFile;
        this.fileCount = fileNameList.length;
        this.inputFiles = new String[this.fileCount];
        this.sessionDirName = sessionDir;
        this.inputFileDir = fileDir;
        System.arraycopy(fileNameList, 0, this.inputFiles, 0, this.fileCount);
    }

    private void clean() {
        for (int i = 0; i < this.fileCount; ++i) {
            File tempFile = new File(this.inputFileDir + this.inputFiles[i]);
            tempFile.delete();
        }
    }

    public void compressFast(int compressionLevel, boolean cleanFlag) throws IOException {
        CRC32 crc32 = new CRC32();
        byte[] rgb = new byte[5000];
        ZipOutputStream zipOS = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.zipArchiveName)));
        zipOS.setMethod(8);
        if (compressionLevel >= 0 && compressionLevel <= 9) {
            zipOS.setLevel(compressionLevel);
        } else {
            zipOS.setLevel(1);
        }
        String targetName = "";
        for (int i = 0; i < this.fileCount; ++i) {
            File file = new File(this.inputFileDir + this.inputFiles[i]);
            targetName = this.sessionDirName + FS + this.inputFiles[i];
            this.addEntryToZip(file, targetName, zipOS, crc32, rgb);
        }
        if (this.pluginFileMap != null && this.pluginFileMap.size() > 0) {
            Set pluginSet = this.pluginFileMap.keySet();
            for (String pluginName : pluginSet) {
                List theFileList = (List)this.pluginFileMap.get(pluginName);
                if (theFileList == null || theFileList.size() == 0) continue;
                for (File theFile : theFileList) {
                    if (theFile == null || !theFile.exists()) continue;
                    targetName = this.sessionDirName + FS + "plugins" + FS + pluginName + FS + theFile.getName();
                    this.addEntryToZip(theFile, targetName, zipOS, crc32, rgb);
                }
            }
        }
        zipOS.close();
        if (cleanFlag) {
            this.clean();
        }
    }

    public void setPluginFileMap(HashMap pMap) {
        this.pluginFileMap = pMap;
    }

    private void addEntryToZip(File srcFile, String targetName, ZipOutputStream zipOS, CRC32 crc32, byte[] rgb) throws IOException {
        int numRead;
        FileInputStream fileIS = new FileInputStream(srcFile);
        while ((numRead = fileIS.read(rgb)) > -1) {
            crc32.update(rgb, 0, numRead);
        }
        fileIS.close();
        ZipEntry zipEntry = new ZipEntry(targetName);
        zipEntry.setSize(srcFile.length());
        zipEntry.setTime(srcFile.lastModified());
        zipEntry.setCrc(crc32.getValue());
        zipOS.putNextEntry(zipEntry);
        fileIS = new FileInputStream(srcFile);
        while ((numRead = fileIS.read(rgb)) > -1) {
            zipOS.write(rgb, 0, numRead);
        }
        fileIS.close();
        zipOS.closeEntry();
    }

    public static InputStream readFile(String zipName, String fileNameRegEx) throws IOException {
        ZipFile sessionZipFile = new ZipFile(zipName);
        Enumeration<? extends ZipEntry> zipEntries = sessionZipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zent = zipEntries.nextElement();
            if (!zent.getName().matches(fileNameRegEx)) continue;
            return sessionZipFile.getInputStream(zent);
        }
        sessionZipFile.close();
        return null;
    }

    public static List<ZipEntry> getAllFiles(String zipName, String fileNameRegEx) throws IOException {
        ArrayList<ZipEntry> Matching = new ArrayList<ZipEntry>();
        ZipFile Zip = new ZipFile(zipName);
        Enumeration<? extends ZipEntry> Entries = Zip.entries();
        while (Entries.hasMoreElements()) {
            ZipEntry CurrentEntry = Entries.nextElement();
            if (!CurrentEntry.getName().matches(fileNameRegEx)) continue;
            Matching.add(CurrentEntry);
        }
        Zip.close();
        return Matching;
    }

    public static List<String> unzip(String zipName, String unzipDir, TaskMonitor taskMonitor) throws IOException {
        ArrayList<String> UnzippedFiles = new ArrayList<String>();
        unzipDir = unzipDir != null ? unzipDir + File.separator : "";
        int maxCount = 0;
        boolean progressCount = false;
        double percent = 0.0;
        ZipFile Zip = new ZipFile(zipName);
        Enumeration<? extends ZipEntry> Entries = Zip.entries();
        int BUFFER = 2048;
        while (Entries.hasMoreElements()) {
            int count;
            ZipEntry CurrentEntry = Entries.nextElement();
            File ZipFile2 = new File(unzipDir + CurrentEntry.getName());
            if (!CurrentEntry.isDirectory()) {
                File ParentDirs;
                if (ZipFile2.getParent() != null && !(ParentDirs = new File(ZipFile2.getParent())).exists()) {
                    ParentDirs.mkdirs();
                }
            } else {
                if (ZipFile2.exists()) continue;
                ZipFile2.mkdirs();
                continue;
            }
            InputStream zis = Zip.getInputStream(CurrentEntry);
            maxCount = zis.available();
            FileOutputStream fos = new FileOutputStream(ZipFile2);
            BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
            byte[] data = new byte[BUFFER];
            while ((count = zis.read(data, 0, BUFFER)) != -1) {
                JTask jTask;
                dest.write(data, 0, count);
                if (taskMonitor == null) continue;
                percent = (double)progressCount / (double)maxCount * 100.0;
                if (maxCount == -1) {
                    percent = -1.0;
                }
                if ((jTask = (JTask)taskMonitor).haltRequested()) {
                    taskMonitor.setStatus("Canceling the unzip ...");
                    taskMonitor.setPercentCompleted(100);
                    break;
                }
                taskMonitor.setPercentCompleted((int)percent);
            }
            dest.flush();
            dest.close();
            zis.close();
            UnzippedFiles.add(ZipFile2.getAbsolutePath());
        }
        Zip.close();
        return UnzippedFiles;
    }
}

