/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginStatus;
import cytoscape.plugin.PluginTracker;
import cytoscape.plugin.PluginXml;
import cytoscape.plugin.ThemeInfo;
import cytoscape.plugin.TrackerException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class PluginTrackerTest
extends TestCase {
    private SAXBuilder builder;
    private PluginTracker tracker;
    private String fileName = "test_tracker.xml";
    private File tmpDir;

    protected void setUp() throws Exception {
        this.builder = new SAXBuilder(false);
        this.tmpDir = new File(System.getProperty("java.io.tmpdir"));
        this.tracker = new PluginTracker(this.tmpDir, this.fileName);
    }

    protected void tearDown() throws Exception {
        this.tracker.delete();
    }

    public void testPluginTracker() throws Exception {
        Document Doc = this.getDoc();
        PluginTrackerTest.assertNotNull((Object)Doc);
        PluginTrackerTest.assertEquals((String)Doc.getRootElement().getName(), (String)"CytoscapePlugin");
        PluginTrackerTest.assertEquals((int)Doc.getRootElement().getChildren().size(), (int)3);
        PluginTrackerTest.assertNotNull((Object)Doc.getRootElement().getChild(PluginStatus.CURRENT.getTagName()));
        PluginTrackerTest.assertNotNull((Object)Doc.getRootElement().getChild(PluginStatus.INSTALL.getTagName()));
        PluginTrackerTest.assertNotNull((Object)Doc.getRootElement().getChild(PluginStatus.DELETE.getTagName()));
        PluginTrackerTest.assertEquals((int)Doc.getRootElement().getChild(PluginStatus.CURRENT.getTagName()).getChildren().size(), (int)0);
        PluginTrackerTest.assertEquals((int)Doc.getRootElement().getChild(PluginStatus.INSTALL.getTagName()).getChildren().size(), (int)0);
        PluginTrackerTest.assertEquals((int)Doc.getRootElement().getChild(PluginStatus.DELETE.getTagName()).getChildren().size(), (int)0);
    }

    public void testGetListByStatus() throws Exception {
        this.tracker.addDownloadable(this.getInfoObj(), PluginStatus.CURRENT);
        PluginTrackerTest.assertNotNull(this.tracker.getPluginListByStatus(PluginStatus.CURRENT));
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.CURRENT).size(), (int)1);
        Document Doc = this.getDoc();
        Element Current = Doc.getRootElement().getChild(PluginStatus.CURRENT.getTagName());
        PluginTrackerTest.assertEquals((int)Current.getChildren().size(), (int)1);
        PluginTrackerTest.assertEquals((int)Doc.getRootElement().getChild(PluginStatus.INSTALL.getTagName()).getChildren().size(), (int)0);
        PluginTrackerTest.assertEquals((int)Doc.getRootElement().getChild(PluginStatus.DELETE.getTagName()).getChildren().size(), (int)0);
    }

    public void testAddPlugin() throws Exception {
        this.tracker.addDownloadable(this.getInfoObj(), PluginStatus.CURRENT);
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.CURRENT).size(), (int)1);
        PluginInfo obj = this.getInfoObj();
        obj.setName("myInstallTest");
        obj.setDownloadableURL("http://booya.com/foo.xml");
        this.tracker.addDownloadable(obj, PluginStatus.INSTALL);
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.INSTALL).size(), (int)1);
        obj.setName("mySecondInstallTest");
        this.tracker.addDownloadable(obj, PluginStatus.INSTALL);
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.INSTALL).size(), (int)1);
        PluginInfo newObj = new PluginInfo("this is my unique key for my new plugin");
        newObj.setName("mySecondInstallTest");
        newObj.setProjectUrl("http://foobar.com/booya.xml");
        newObj.setFiletype(PluginInfo.FileType.JAR);
        newObj.addCytoscapeVersion("2.5.1");
        this.tracker.addDownloadable(newObj, PluginStatus.INSTALL);
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.INSTALL).size(), (int)2);
        Document Doc = this.getDoc();
        Element Install = Doc.getRootElement().getChild(PluginStatus.INSTALL.getTagName());
        PluginTrackerTest.assertEquals((int)Install.getChildren().size(), (int)2);
        PluginTrackerTest.assertEquals((int)Doc.getRootElement().getChild(PluginStatus.CURRENT.getTagName()).getChildren().size(), (int)1);
        PluginTrackerTest.assertEquals((int)Doc.getRootElement().getChild(PluginStatus.DELETE.getTagName()).getChildren().size(), (int)0);
    }

    public void testAddTheme() throws Exception {
        ThemeInfo themeObj = new ThemeInfo("themeTest123");
        themeObj.setName("Test Theme");
        themeObj.setDownloadableURL("http://booya.com/foo.xml");
        themeObj.addCytoscapeVersion("2.5.1");
        PluginInfo obj = this.getInfoObj();
        obj.setName("myInstallTest");
        obj.setDownloadableURL("http://booya.com/foo.xml");
        themeObj.addPlugin(obj);
        this.tracker.addDownloadable(themeObj, PluginStatus.INSTALL);
        PluginTrackerTest.assertEquals((int)this.tracker.getThemeListByStatus(PluginStatus.INSTALL).size(), (int)1);
        PluginTrackerTest.assertEquals((int)this.tracker.getDownloadableListByStatus(PluginStatus.INSTALL).size(), (int)1);
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.INSTALL).size(), (int)0);
        Document Doc = this.getDoc();
        Element Install = Doc.getRootElement().getChild(PluginStatus.INSTALL.getTagName());
        PluginTrackerTest.assertEquals((int)Install.getChildren().size(), (int)1);
        PluginTrackerTest.assertNotNull((Object)Install.getChild(PluginXml.THEME.getTag()).getChild(PluginXml.PLUGIN_LIST.getTag()));
    }

    public void testRemoveTheme() throws Exception {
        ThemeInfo themeObj = new ThemeInfo("themeTest123");
        themeObj.setName("Test Theme");
        themeObj.setDownloadableURL("http://booya.com/foo.xml");
        themeObj.addCytoscapeVersion("2.5.1");
        PluginInfo obj = this.getInfoObj();
        obj.setName("myInstallTest");
        obj.setDownloadableURL("http://booya.com/foo.xml");
        themeObj.addPlugin(obj);
        this.tracker.addDownloadable(themeObj, PluginStatus.INSTALL);
        PluginTrackerTest.assertEquals((int)this.tracker.getThemeListByStatus(PluginStatus.INSTALL).size(), (int)1);
        PluginTrackerTest.assertEquals((int)this.tracker.getDownloadableListByStatus(PluginStatus.INSTALL).size(), (int)1);
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.INSTALL).size(), (int)0);
        this.tracker.removeDownloadable(themeObj, PluginStatus.INSTALL);
        PluginTrackerTest.assertEquals((int)this.tracker.getThemeListByStatus(PluginStatus.INSTALL).size(), (int)0);
        PluginTrackerTest.assertEquals((int)this.tracker.getDownloadableListByStatus(PluginStatus.INSTALL).size(), (int)0);
        PluginTrackerTest.assertEquals((int)this.tracker.getDownloadableListByStatus(PluginStatus.CURRENT).size(), (int)0);
        PluginTrackerTest.assertEquals((int)this.tracker.getDownloadableListByStatus(PluginStatus.DELETE).size(), (int)0);
    }

    public void testAddThemeAndPlugin() throws Exception {
        ThemeInfo themeObj = new ThemeInfo("1A");
        themeObj.setName("Test Theme");
        themeObj.setDownloadableURL("http://booya.com/foo.xml");
        themeObj.addCytoscapeVersion("2.6");
        PluginInfo themePlugin = this.getInfoObj();
        themePlugin.addCytoscapeVersion("2.6");
        themeObj.addPlugin(themePlugin);
        this.tracker.addDownloadable(themeObj, PluginStatus.CURRENT);
        PluginTrackerTest.assertEquals((int)this.tracker.getDownloadableListByStatus(PluginStatus.CURRENT).size(), (int)1);
        PluginInfo pluginObj = new PluginInfo("1A");
        pluginObj.setName("Plugin Test");
        pluginObj.addCytoscapeVersion("2.6");
        pluginObj.setDownloadableURL("http://booya.com/foo.xml");
        pluginObj.setFiletype(PluginInfo.FileType.JAR);
        this.tracker.addDownloadable(pluginObj, PluginStatus.CURRENT);
        PluginTrackerTest.assertEquals((int)this.tracker.getDownloadableListByStatus(PluginStatus.CURRENT).size(), (int)2);
    }

    public void testAddSamePlugin() throws Exception {
        PluginInfo InfoObject = this.getInfoObj();
        this.tracker.addDownloadable(InfoObject, PluginStatus.CURRENT);
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.CURRENT).size(), (int)1);
        String NewName = "DuplicatePluginTest";
        InfoObject.setName(NewName);
        this.tracker.addDownloadable(InfoObject, PluginStatus.CURRENT);
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.CURRENT).size(), (int)1);
        DownloadableInfo info = this.tracker.getPluginListByStatus(PluginStatus.CURRENT).get(0);
        PluginTrackerTest.assertTrue((boolean)info.getName().equals(InfoObject.getName()));
        Document Doc = this.getDoc();
        PluginTrackerTest.assertEquals((String)Doc.getRootElement().getChild(PluginStatus.CURRENT.getTagName()).getChild("plugin").getChildTextTrim("name"), (String)NewName);
    }

    public void testRemovePlugin() throws Exception {
        this.tracker.addDownloadable(this.getInfoObj(), PluginStatus.CURRENT);
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.CURRENT).size(), (int)1);
        PluginInfo obj = new PluginInfo("999");
        obj.setName("myInstallTest");
        obj.setDownloadableURL("http://foobar.org/y.xml");
        obj.setCategory("Test");
        obj.setFiletype(PluginInfo.FileType.JAR);
        obj.addCytoscapeVersion("2.5.1");
        this.tracker.addDownloadable(obj, PluginStatus.INSTALL);
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.INSTALL).size(), (int)1);
        this.tracker.removeDownloadable(this.getInfoObj(), PluginStatus.INSTALL);
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.INSTALL).size(), (int)1);
        this.tracker.removeDownloadable(obj, PluginStatus.INSTALL);
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.INSTALL).size(), (int)0);
        Document Doc = this.getDoc();
        PluginTrackerTest.assertEquals((int)Doc.getRootElement().getChild(PluginStatus.CURRENT.getTagName()).getChildren().size(), (int)1);
        PluginTrackerTest.assertEquals((int)Doc.getRootElement().getChild(PluginStatus.INSTALL.getTagName()).getChildren().size(), (int)0);
        PluginTrackerTest.assertEquals((int)Doc.getRootElement().getChild(PluginStatus.DELETE.getTagName()).getChildren().size(), (int)0);
    }

    public void testAddRemovePluginWithSameID() throws Exception {
        PluginInfo objA = this.getInfoObj();
        PluginInfo objB = new PluginInfo(objA.getID());
        objB.setName("Different Test");
        objB.setDownloadableURL("http://test.com/blue.xml");
        objB.setFiletype(PluginInfo.FileType.JAR);
        objB.setPluginClassName("some.other.class.DifferentTest");
        objB.addCytoscapeVersion(objA.getCytoscapeVersion());
        this.tracker.addDownloadable(objA, PluginStatus.CURRENT);
        this.tracker.addDownloadable(objB, PluginStatus.CURRENT);
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.CURRENT).size(), (int)2);
        List<PluginInfo> CurrentList = this.tracker.getPluginListByStatus(PluginStatus.CURRENT);
        PluginTrackerTest.assertFalse((boolean)CurrentList.get(0).equals(CurrentList.get(1)));
        this.tracker.removeDownloadable(objA, PluginStatus.CURRENT);
        PluginTrackerTest.assertEquals((int)this.tracker.getPluginListByStatus(PluginStatus.CURRENT).size(), (int)1);
        PluginInfo Current = this.tracker.getPluginListByStatus(PluginStatus.CURRENT).get(0);
        PluginTrackerTest.assertEquals((String)Current.getName(), (String)objB.getName());
    }

    public void testPartiallyCorruptedXml() {
        try {
            File file = new File("testData/plugins/track_plugins_c1.xml");
            PluginTracker tk = new PluginTracker(file);
            PluginTrackerTest.assertNotNull((Object)tk);
            PluginTrackerTest.assertEquals((int)tk.getDownloadableListByStatus(PluginStatus.CURRENT).size(), (int)13);
            PluginTrackerTest.assertTrue((boolean)tk.hasCorruptedElements());
            PluginTrackerTest.assertEquals((int)tk.getTotalCorruptedElements(), (int)1);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            PluginTrackerTest.fail((String)("Failed to handle corrupted xml: " + npe.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
            PluginTrackerTest.fail((String)("Failed to read file: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompletelyCorruptedXml() {
        PluginTracker tk = null;
        File tempFile = null;
        try {
            File file = new File("testData/plugins/track_plugins_c2.xml");
            tempFile = this.copyFileToTempDir(file);
            tk = new PluginTracker(tempFile);
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            PluginTrackerTest.fail((String)("Failed to handle corrupted xml: " + npe.getMessage()));
        }
        catch (TrackerException te) {
            PluginTrackerTest.assertNotNull((Object)te);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            PluginTrackerTest.fail((String)("Failed to read file: " + ioe.getMessage()));
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    private File copyFileToTempDir(File fileToCopy) {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempFile = new File(tempDir, fileToCopy.getName());
        try {
            BufferedReader reader = new BufferedReader(new FileReader(fileToCopy));
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.newLine();
                writer.flush();
            }
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempFile;
    }

    private Document getDoc() throws Exception {
        File TestFile = new File(this.tmpDir, this.fileName);
        PluginTrackerTest.assertTrue((boolean)TestFile.exists());
        PluginTrackerTest.assertTrue((boolean)TestFile.canRead());
        Document Doc = this.builder.build(TestFile);
        PluginTrackerTest.assertNotNull((Object)Doc);
        return Doc;
    }

    private PluginInfo getInfoObj() {
        PluginInfo infoObj = new PluginInfo("123");
        infoObj.setName("myTest");
        infoObj.setCategory("Test");
        infoObj.addCytoscapeVersion("2.5.1");
        infoObj.setPluginClassName("some.class.MyTest");
        infoObj.setDownloadableURL("http://test.com/x.xml");
        infoObj.setFiletype(PluginInfo.FileType.JAR);
        return infoObj;
    }

    private PluginInfo fillInPI(PluginInfo obj) {
        obj.setCategory("Test");
        obj.addCytoscapeVersion("2.5.1");
        obj.setPluginClassName("some.class.MyTest");
        obj.setDownloadableURL("http://test.com/x.xml");
        obj.setFiletype(PluginInfo.FileType.JAR);
        obj.setDownloadableURL("http://booya.com/foo.xml");
        return obj;
    }
}

