/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.plugin.Category;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.DownloadableType;
import cytoscape.plugin.Installable;
import cytoscape.plugin.InstallablePlugin;
import cytoscape.plugin.PluginManager;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInfo
extends DownloadableInfo {
    private FileType fileType;
    private String pluginClassName;
    private List<AuthorInfo> authors;
    private String projectUrl;
    private List<String> pluginFiles;
    protected String enclosingJar;
    protected String installLocation;

    public PluginInfo() {
        this.init();
    }

    public PluginInfo(String UniqueID) {
        super(UniqueID);
        this.init();
    }

    public PluginInfo(String UniqueID, String Name2) {
        super(UniqueID);
        this.init();
        this.setName(Name2);
    }

    public PluginInfo(String UniqueID, DownloadableInfo ParentObj) {
        super(UniqueID, ParentObj);
        this.init();
    }

    private void init() {
        this.pluginFiles = new ArrayList<String>();
        this.authors = new ArrayList<AuthorInfo>();
        this.setName("Unknown");
        this.setDescription("No description");
        this.setObjectVersion(0.1);
        this.setCategory(Category.NONE);
        this.setPluginClassName("");
    }

    public void setPluginClassName(String className) {
        this.pluginClassName = className;
    }

    public void setPluginVersion(double Version2) throws NumberFormatException {
        this.setObjectVersion(Version2);
    }

    protected void setUrl(String url) {
        this.setObjectUrl(url);
    }

    public void setProjectUrl(String url) {
        this.projectUrl = url;
    }

    protected void setDownloadUrl(String url) {
        this.setDownloadableURL(url);
    }

    protected void setFiletype(FileType type) {
        if (this.fileType == null) {
            this.fileType = type;
        }
    }

    protected void setFileList(List<String> list) {
        this.pluginFiles = list;
    }

    protected void addFileName(String fileName) {
        if (!this.pluginFiles.contains(fileName)) {
            this.pluginFiles.add(fileName);
        }
    }

    public void addAuthor(String authorName, String institution) {
        this.authors.add(new AuthorInfo(authorName, institution));
    }

    public void clearAuthorList() {
        this.authors.clear();
    }

    @Override
    public void setLicense(URL url) {
        super.setLicense(url);
    }

    @Override
    public void setLicense(String licenseText, boolean alwaysRequired) {
        super.setLicense(licenseText, alwaysRequired);
    }

    protected void setInstallLocation(String Loc) {
        if (this.installLocation == null) {
            this.installLocation = Loc;
        }
    }

    public File getPluginDirectory() {
        File PluginDir = new File(PluginManager.getPluginManager().getPluginManageDirectory(), this.getName() + "-" + this.getObjectVersion());
        return PluginDir;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    @Override
    public String getLicenseText() {
        return super.getLicenseText();
    }

    @Override
    public boolean isLicenseRequired() {
        return super.isLicenseRequired();
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public String getPluginClassName() {
        return this.pluginClassName;
    }

    public List<AuthorInfo> getAuthors() {
        return this.authors;
    }

    public String getPluginVersion() {
        return super.getObjectVersion();
    }

    public String getUrl() {
        return super.getObjectUrl();
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public String getDownloadUrl() {
        return super.getDownloadableURL();
    }

    @Override
    public Installable getInstallable() {
        return new InstallablePlugin(this);
    }

    @Override
    public DownloadableType getType() {
        return DownloadableType.PLUGIN;
    }

    public List<String> getFileList() {
        return this.pluginFiles;
    }

    public boolean isNewerPluginVersion(PluginInfo New) {
        return super.isNewerObjectVersion(New);
    }

    @Override
    public String htmlOutput() {
        String Html = this.basicHtmlOutput();
        Html = Html + "<b>Released By:</b><br><ul>";
        for (AuthorInfo ai : this.getAuthors()) {
            Html = Html + "<li>" + ai.getAuthor() + ", " + ai.getInstitution() + "<br>";
        }
        Html = Html + "</ul>";
        Html = Html + "</font></body></html>";
        return Html;
    }

    public class AuthorInfo {
        private String authorName;
        private String institutionName;

        public AuthorInfo(String Name2, String Institution) {
            this.authorName = Name2;
            this.institutionName = Institution;
        }

        public String getAuthor() {
            return this.authorName;
        }

        public String getInstitution() {
            return this.institutionName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        JAR("jar"),
        ZIP("zip");

        private String typeText;

        private FileType(String type) {
            this.typeText = type;
        }

        public String toString() {
            return this.typeText;
        }
    }
}

