/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.CytoscapeVersion;
import cytoscape.plugin.Category;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.DownloadableType;
import cytoscape.plugin.Installable;
import cytoscape.plugin.PluginInfo;
import junit.framework.TestCase;

public class DownloadableInfoTest
extends TestCase {
    DownloadableInfo di;

    protected void setUp() throws Exception {
        super.setUp();
        this.di = new InfoObj();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDownloadableInfo() {
        DownloadableInfoTest.assertNotNull((Object)this.di);
    }

    public void testDownloadableInfoString() {
        this.di = new InfoObj("123");
        DownloadableInfoTest.assertNotNull((Object)this.di);
        DownloadableInfoTest.assertEquals((String)this.di.getID(), (String)"123");
    }

    public void testDownloadableInfoStringDownloadableInfo() {
        this.di = new InfoObj("123", new InfoObj("parent_123"));
        DownloadableInfoTest.assertNotNull((Object)this.di);
        DownloadableInfoTest.assertEquals((String)this.di.getID(), (String)"123");
        DownloadableInfoTest.assertNotNull((Object)this.di.getParent());
        DownloadableInfoTest.assertEquals((String)this.di.getParent().getID(), (String)"parent_123");
    }

    public void testCategoryString() {
        this.di.setCategory("Foobar");
        DownloadableInfoTest.assertNotNull((Object)this.di.getCategory());
        DownloadableInfoTest.assertEquals((String)this.di.getCategory(), (String)"Foobar");
    }

    public void testCategoryCategory() {
        this.di.setCategory(Category.CORE);
        DownloadableInfoTest.assertNotNull((Object)this.di.getCategory());
        DownloadableInfoTest.assertEquals((String)this.di.getCategory(), (String)Category.CORE.toString());
    }

    public void testParent() {
        this.di.setParent(new InfoObj("parent"));
        DownloadableInfoTest.assertNotNull((Object)this.di.getParent());
    }

    public void testName() {
        this.di.setName("Booya!");
        DownloadableInfoTest.assertEquals((String)this.di.getName(), (String)"Booya!");
    }

    public void testDescription() {
        this.di.setDescription("Just testing");
        DownloadableInfoTest.assertEquals((String)this.di.getDescription(), (String)"Just testing");
    }

    public void testDownloadableURL() {
        String url = "http://google.com";
        this.di.setDownloadableURL(url);
        DownloadableInfoTest.assertEquals((String)this.di.getDownloadableURL(), (String)url);
    }

    public void testObjectUrl() {
        String url = "http://foobar.jar";
        this.di.setObjectUrl(url);
        DownloadableInfoTest.assertEquals((String)this.di.getObjectUrl(), (String)url);
    }

    public void testCytoscapeVersion() {
        CytoscapeVersion.version = "2.5";
        this.di.addCytoscapeVersion("2.5");
        this.di.addCytoscapeVersion("2.3");
        DownloadableInfoTest.assertTrue((boolean)this.di.containsVersion("2.5"));
        DownloadableInfoTest.assertTrue((boolean)this.di.containsVersion("2.3"));
        DownloadableInfoTest.assertEquals((String)this.di.getCytoscapeVersion(), (String)"2.5");
        CytoscapeVersion.version = "2.5.6";
        this.di.addCytoscapeVersion("2.5.6");
        DownloadableInfoTest.assertTrue((boolean)this.di.containsVersion("2.5.6"));
        DownloadableInfoTest.assertEquals((String)this.di.getCytoscapeVersion(), (String)"2.5.6");
    }

    public void testObjectVersion() {
        this.di.setObjectVersion(1.3);
        DownloadableInfoTest.assertEquals((String)this.di.getObjectVersion(), (String)"1.3");
    }

    public void testReleaseDate() {
        String date = "Oct. 14, 2007";
        this.di.setReleaseDate(date);
        DownloadableInfoTest.assertEquals((String)this.di.getReleaseDate(), (String)date);
    }

    public void testGetType() {
        DownloadableInfoTest.assertNotNull((Object)((Object)this.di.getType()));
    }

    public void testGetID() {
        DownloadableInfoTest.assertNull((Object)this.di.getID());
        this.di = new InfoObj("1234");
        DownloadableInfoTest.assertEquals((String)this.di.getID(), (String)"1234");
    }

    public void testIsNewerObjectVersion() {
        this.di = new InfoObj("123");
        this.di.setObjectVersion(1.0);
        InfoObj diNew = new InfoObj("123");
        diNew.setObjectVersion(1.3);
        DownloadableInfoTest.assertTrue((boolean)this.di.isNewerObjectVersion(diNew));
    }

    public void testPluginCompatible() {
        CytoscapeVersion.version = "3.6";
        this.di.addCytoscapeVersion("2.1");
        this.di.addCytoscapeVersion("3.6");
        DownloadableInfoTest.assertTrue((boolean)this.di.isPluginCompatibleWithCurrent());
        CytoscapeVersion.version = "2.6.1";
        DownloadableInfoTest.assertEquals((String)CytoscapeVersion.version, (String)"2.6.1");
        this.di.addCytoscapeVersion("2.6.2");
        DownloadableInfoTest.assertFalse((boolean)this.di.isPluginCompatibleWithCurrent());
        this.di.addCytoscapeVersion("2.6.1");
        DownloadableInfoTest.assertTrue((boolean)this.di.isPluginCompatibleWithCurrent());
    }

    public void testEquals() {
        this.di = new InfoObj("1234");
        InfoObj di2 = new InfoObj("1234");
        DownloadableInfoTest.assertTrue((boolean)this.di.equals(di2));
        InfoObj di3 = new InfoObj("4321");
        DownloadableInfoTest.assertFalse((boolean)this.di.equals(di3));
    }

    public void testEqualsDifferentObjs() {
        this.di = new InfoObj("1234");
        PluginInfo pi = new PluginInfo("1234");
        DownloadableInfoTest.assertFalse((boolean)this.di.equals(pi));
    }

    public void testEqualsNoId() {
        this.di = new InfoObj();
        InfoObj di2 = new InfoObj();
        DownloadableInfoTest.assertTrue((boolean)this.di.equals(di2));
        InfoObj di3 = new InfoObj();
        di3.setObjectVersion(2.3);
        DownloadableInfoTest.assertFalse((boolean)this.di.equals(di3));
    }

    private class InfoObj
    extends DownloadableInfo {
        public InfoObj() {
            this.init();
        }

        public InfoObj(String arg) {
            super(arg);
            this.init();
        }

        private void init() {
            this.setObjectVersion(1.1);
            this.setDownloadableURL("http://foo.com/infoobj");
        }

        public InfoObj(String arg, DownloadableInfo parent) {
            super(arg, parent);
        }

        public DownloadableType getType() {
            return DownloadableType.PLUGIN;
        }

        public String htmlOutput() {
            return null;
        }

        public Installable getInstallable() {
            return null;
        }
    }
}

