/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout.algorithms;

import cytoscape.CyEdge;
import cytoscape.layout.AbstractLayout;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;

public class GridNodeLayout
extends AbstractLayout {
    public String getName() {
        return "grid";
    }

    public String toString() {
        return "Grid Layout";
    }

    public boolean supportsSelectedOnly() {
        return true;
    }

    public byte[] supportsNodeAttributes() {
        return null;
    }

    public byte[] supportsEdgeAttributes() {
        return null;
    }

    public JPanel createSettings() {
        return null;
    }

    public void construct() {
        int columns;
        double distanceBetweenNodes = 80.0;
        double currX = 0.0;
        double currY = 0.0;
        double initialX = 0.0;
        double initialY = 0.0;
        NodeView nView = null;
        if (this.selectedOnly) {
            int nodeCount = this.networkView.nodeCount() - this.staticNodes.size();
            columns = (int)Math.sqrt(nodeCount);
            Iterator nodeViews = this.networkView.getNodeViewsIterator();
            while (nodeViews.hasNext()) {
                nView = (NodeView)nodeViews.next();
                if (this.isLocked(nView)) continue;
                initialX += nView.getXPosition() / (double)nodeCount;
                initialY += nView.getYPosition() / (double)nodeCount;
            }
            currX = initialX -= distanceBetweenNodes * (double)(columns - 1) / 2.0;
            currY = initialY -= distanceBetweenNodes * (double)(columns - 1) / 2.0;
        } else {
            columns = (int)Math.sqrt(this.networkView.nodeCount());
        }
        Iterator nodeViews = this.networkView.getNodeViewsIterator();
        int count = 0;
        while (nodeViews.hasNext()) {
            nView = (NodeView)nodeViews.next();
            List edgeList = this.network.getAdjacentEdgesList(nView.getNode(), true, true, true);
            for (CyEdge edge : edgeList) {
                EdgeView ev = this.networkView.getEdgeView(edge);
                ev.clearBends();
            }
            if (this.isLocked(nView)) continue;
            nView.setOffset(currX, currY);
            if (++count == columns) {
                count = 0;
                currX = initialX;
                currY += distanceBetweenNodes;
                continue;
            }
            currX += distanceBetweenNodes;
        }
    }
}

