/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.layout.TunableListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tunable
implements FocusListener,
ChangeListener,
ActionListener,
ItemListener,
ListSelectionListener {
    private String name;
    private String desc;
    private int type = 3;
    private int flag = 0;
    private Object value;
    private Object lowerBound;
    private Object upperBound;
    private JComponent inputField = null;
    private JSlider slider = null;
    private boolean valueChanged = true;
    private String savedValue = null;
    private boolean usingSlider = false;
    private boolean collapsed = false;
    private List<String> attributeList = null;
    private List<TunableListener> listenerList = null;
    public static final int INTEGER = 0;
    public static final int DOUBLE = 1;
    public static final int BOOLEAN = 2;
    public static final int STRING = 3;
    public static final int NODEATTRIBUTE = 4;
    public static final int EDGEATTRIBUTE = 5;
    public static final int LIST = 6;
    public static final int GROUP = 7;
    public static final int BUTTON = 8;
    public static final int NOINPUT = 1;
    public static final int NUMERICATTRIBUTE = 2;
    public static final int MULTISELECT = 4;
    public static final int USESLIDER = 8;
    public static final int IMMUTABLE = 16;
    public static final int COLLAPSABLE = 32;

    public Tunable(String name, String desc, int type, Object value) {
        this(name, desc, type, value, null, null, 0);
    }

    public Tunable(String name, String desc, int type, Object value, int flag) {
        this(name, desc, type, value, null, null, flag);
    }

    public Tunable(String name, String desc, int type, Object value, Object lowerBound, Object upperBound, int flag) {
        this.name = name;
        this.desc = desc;
        this.type = type;
        this.value = value;
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
        this.flag = flag;
    }

    public Tunable(String name, String desc, int type, Object value, Object lowerBound, Object upperBound, int flag, boolean immutable) {
        this(name, desc, type, value, lowerBound, upperBound, flag);
        if (immutable) {
            this.setFlag(16);
        }
    }

    public void setFlag(int flag) {
        this.flag |= flag;
    }

    public void clearFlag(int flag) {
        this.flag &= ~flag;
    }

    public boolean checkFlag(int flag) {
        return (this.flag & flag) != 0;
    }

    public void setImmutable(boolean immutable) {
        if (immutable) {
            this.setFlag(16);
        } else {
            this.clearFlag(16);
        }
        if (this.inputField != null) {
            this.inputField.setEnabled(!this.checkFlag(16));
            if (this.checkFlag(8) && this.slider != null) {
                this.slider.setEnabled(!this.checkFlag(16));
            }
        }
    }

    public void setValue(Object value) {
        switch (this.type) {
            case 0: {
                this.value = value.getClass() == String.class ? new Integer((String)value) : value;
                if (this.slider != null && this.checkFlag(8)) {
                    this.slider.setValue(this.sliderScale(this.value));
                    break;
                }
                if (this.inputField == null) break;
                ((JTextField)this.inputField).setText(this.value.toString());
                break;
            }
            case 1: {
                this.value = value.getClass() == String.class ? new Double((String)value) : value;
                if (this.slider != null && this.checkFlag(8)) {
                    this.slider.setValue(this.sliderScale(this.value));
                    break;
                }
                if (this.inputField == null) break;
                ((JTextField)this.inputField).setText(this.value.toString());
                break;
            }
            case 2: {
                this.value = value.getClass() == String.class ? new Boolean((String)value) : value;
                if (this.inputField == null) break;
                ((JCheckBox)this.inputField).setSelected((Boolean)this.value);
                break;
            }
            case 6: {
                if (this.checkFlag(4)) {
                    int[] intArray;
                    this.value = value;
                    if (this.inputField == null || value == null || (intArray = this.decodeIntegerArray((String)value)) == null) break;
                    ((JList)this.inputField).setSelectedIndices(intArray);
                    break;
                }
                this.value = value.getClass() == String.class ? new Integer((String)value) : value;
                if (this.inputField == null) break;
                ((JComboBox)this.inputField).setSelectedIndex((Integer)this.value);
                break;
            }
            case 4: 
            case 5: {
                if (this.checkFlag(4)) {
                    this.value = value;
                    if (this.inputField == null) break;
                    ((JList)this.inputField).setSelectedIndices(this.getSelectedValues(this.attributeList, this.decodeArray((String)value)));
                    break;
                }
                this.value = value;
                if (this.inputField == null) break;
                ((JComboBox)this.inputField).setSelectedItem(this.value);
                break;
            }
            case 7: {
                this.value = value.getClass() == String.class ? new Integer((String)value) : value;
                return;
            }
            case 3: {
                this.value = value;
                if (this.inputField == null) break;
                ((JTextField)this.inputField).setText((String)value);
                break;
            }
            case 8: {
                this.value = value;
                if (this.inputField == null) break;
                ((JButton)this.inputField).setText((String)value);
            }
        }
        if (this.inputField != null) {
            this.inputField.validate();
        }
        this.valueChanged = true;
    }

    public Object getValue() {
        this.valueChanged = false;
        return this.value;
    }

    public boolean valueChanged() {
        return this.valueChanged;
    }

    public void setLowerBound(Object lowerBound) {
        this.lowerBound = lowerBound;
        if (this.inputField == null) {
            return;
        }
        if (this.type == 6) {
            Object[] listData = (Object[])lowerBound;
            if (this.checkFlag(4)) {
                JList list = (JList)this.inputField;
                list.setListData(listData);
                JScrollPane listScroller = (JScrollPane)list.getParent().getParent();
                listScroller.setPreferredSize(this.getPreferredSize((Object[])lowerBound));
            } else {
                JComboBox cbox = (JComboBox)this.inputField;
                cbox.removeAllItems();
                for (int i = 0; i < listData.length; ++i) {
                    cbox.addItem(listData[i]);
                }
            }
        } else if (this.type != 4 && this.type != 5) {
            if (this.checkFlag(8)) {
                this.slider.setMinimum(this.sliderScale(lowerBound));
                this.slider.setLabelTable(this.createLabels(this.slider));
            } else if (this.type == 7) {
                if (!this.checkFlag(32)) {
                    return;
                }
                this.updateValueListeners();
            }
        }
    }

    public Object getLowerBound() {
        return this.lowerBound;
    }

    public void setUpperBound(Object upperBound) {
        this.upperBound = upperBound;
        if (this.inputField == null) {
            return;
        }
        if (this.checkFlag(8)) {
            this.slider.setMaximum(this.sliderScale(upperBound));
            this.slider.setLabelTable(this.createLabels(this.slider));
        }
    }

    public Object getUpperBound() {
        return this.upperBound;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getDescription() {
        return this.desc;
    }

    public void addTunableValueListener(TunableListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<TunableListener>();
        }
        if (listener == null || this.listenerList.contains(listener)) {
            return;
        }
        this.listenerList.add(listener);
    }

    public void removeTunableValueListener(TunableListener listener) {
        if (listener == null || this.listenerList == null) {
            return;
        }
        this.listenerList.remove(listener);
    }

    public void updateValueListeners() {
        if (this.listenerList == null) {
            return;
        }
        this.updateValue();
        for (TunableListener listener : this.listenerList) {
            listener.tunableChanged(this);
        }
    }

    public JPanel getPanel() {
        JTextField field;
        if (this.checkFlag(1)) {
            return null;
        }
        if (this.type == 7) {
            JPanel tunablesPanel = new JPanel();
            BoxLayout box = new BoxLayout(tunablesPanel, 1);
            tunablesPanel.setLayout(box);
            Border refBorder = BorderFactory.createEtchedBorder(1);
            TitledBorder titleBorder = BorderFactory.createTitledBorder(refBorder, this.desc);
            titleBorder.setTitlePosition(1);
            titleBorder.setTitlePosition(2);
            tunablesPanel.setBorder(titleBorder);
            if (this.checkFlag(32)) {
                String label = "<html><b><i>&nbsp;&nbsp;Hide " + this.desc + "</i></b></html>";
                this.collapsed = (Boolean)this.lowerBound;
                if (this.collapsed) {
                    label = "<html><b><i>&nbsp;&nbsp;Show " + this.desc + "</i></b></html>";
                }
                JPanel collapsePanel = new JPanel(new BorderLayout(0, 2));
                JButton collapseButton = null;
                collapseButton = this.collapsed ? new JButton(UIManager.getIcon("Tree.collapsedIcon")) : new JButton(UIManager.getIcon("Tree.expandedIcon"));
                collapseButton.setActionCommand("collapse");
                collapseButton.addActionListener(this);
                collapsePanel.add((Component)collapseButton, "Before");
                collapsePanel.add((Component)new JLabel(label), "Center");
                tunablesPanel.add(collapsePanel);
            }
            return tunablesPanel;
        }
        JPanel tunablePanel = new JPanel(new BorderLayout(0, 3));
        JLabel tunableLabel = new JLabel(this.desc);
        String labelLocation = "Before";
        String fieldLocation = "After";
        if (this.type == 1 || this.type == 0) {
            if (this.checkFlag(8) && this.lowerBound != null && this.upperBound != null) {
                this.slider = new JSlider(0, this.sliderScale(this.lowerBound), this.sliderScale(this.upperBound), this.sliderScale(this.value));
                this.slider.setLabelTable(this.createLabels(this.slider));
                this.slider.setPaintLabels(true);
                this.slider.addChangeListener(this);
                tunablePanel.add((Component)tunableLabel, "North");
                tunablePanel.add((Component)this.slider, "Center");
                JTextField textField = new JTextField(this.value.toString(), 4);
                textField.addFocusListener(this);
                this.inputField = textField;
                tunablePanel.add((Component)textField, "East");
                textField.setBackground(Color.white);
                if (this.checkFlag(16)) {
                    this.inputField.setEnabled(false);
                    this.slider.setEnabled(false);
                }
                return tunablePanel;
            }
            this.clearFlag(8);
            field = new JTextField(this.value.toString(), 8);
            field.setHorizontalAlignment(4);
            field.addFocusListener(this);
            this.inputField = field;
        } else if (this.type == 2) {
            JCheckBox box = new JCheckBox();
            box.setSelected((Boolean)this.value);
            box.addItemListener(this);
            this.inputField = box;
        } else if (this.type == 4) {
            CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
            this.inputField = this.getAttributePanel(nodeAttributes);
        } else if (this.type == 5) {
            CyAttributes edgeAttributes = Cytoscape.getEdgeAttributes();
            this.inputField = this.getAttributePanel(edgeAttributes);
        } else if (this.type == 6) {
            this.inputField = this.getListPanel((Object[])this.lowerBound);
        } else if (this.type == 3) {
            field = new JTextField(this.value.toString(), 20);
            field.addFocusListener(this);
            field.setHorizontalAlignment(4);
            this.inputField = field;
        } else if (this.type == 8) {
            JButton button = new JButton((String)this.value);
            button.addActionListener((ActionListener)this.lowerBound);
            button.setActionCommand(this.name);
            this.inputField = button;
        }
        if (this.checkFlag(16)) {
            this.inputField.setEnabled(false);
        }
        this.inputField.setBackground(Color.white);
        tunablePanel.add((Component)tunableLabel, labelLocation);
        tunablePanel.add((Component)new JLabel("     "), "Center");
        if ((this.type == 6 || this.type == 4 || this.type == 5) && this.checkFlag(4)) {
            JScrollPane listScroller = new JScrollPane(this.inputField);
            listScroller.setPreferredSize(this.getPreferredSize((Object[])this.lowerBound));
            tunablePanel.add((Component)listScroller, fieldLocation);
        } else {
            tunablePanel.add((Component)this.inputField, fieldLocation);
        }
        return tunablePanel;
    }

    private JComponent getAttributePanel(CyAttributes attributes) {
        String[] attList = attributes.getAttributeNames();
        ArrayList<String> list = new ArrayList<String>();
        if (this.lowerBound != null) {
            list.addAll((List)this.lowerBound);
        }
        for (int i = 0; i < attList.length; ++i) {
            if (!attributes.getUserVisible(attList[i])) continue;
            byte type = attributes.getType(attList[i]);
            if ((this.flag & 2) != 0 && type != 2 && type != 3) continue;
            list.add(attList[i]);
        }
        this.attributeList = list;
        if (this.checkFlag(4)) {
            JList<Object> jList = new JList<Object>(list.toArray());
            int[] indices = this.getSelectedValues(this.attributeList, this.decodeArray((String)this.value));
            if (indices != null && indices.length > 0) {
                jList.setSelectedIndices(indices);
            }
            jList.addListSelectionListener(this);
            return jList;
        }
        JComboBox<Object> box = new JComboBox<Object>(this.attributeList.toArray());
        box.setSelectedItem((String)this.value);
        box.addActionListener(this);
        return box;
    }

    private JComponent getListPanel(Object[] list) {
        if (this.checkFlag(4)) {
            int[] intArray;
            JList<Object> jList = new JList<Object>(list);
            if (this.value != null && ((String)this.value).length() > 0 && (intArray = this.decodeIntegerArray((String)this.value)) != null) {
                jList.setSelectedIndices(intArray);
            }
            jList.addListSelectionListener(this);
            return jList;
        }
        JComboBox<Object> box = new JComboBox<Object>(list);
        box.setSelectedIndex((Integer)this.value);
        box.addActionListener(this);
        return box;
    }

    private Dimension getPreferredSize(Object[] list) {
        Dimension dim = new Dimension(300, 200);
        if (list == null) {
            return dim;
        }
        dim.height = Math.min(list.length * 12, 300);
        int maxString = 0;
        for (int i = 0; i < list.length; ++i) {
            maxString = Math.max(list[i].toString().length(), maxString);
        }
        dim.width = Math.min(maxString * 12, 400);
        return dim;
    }

    private int[] getSelectedValues(List<String> attrs, String[] values) {
        if (values == null) {
            return null;
        }
        int[] selVals = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            selVals[i] = attrs.indexOf(values[i]);
        }
        return selVals;
    }

    private int[] decodeIntegerArray(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        String[] valArray = value.split(",");
        int[] intArray = new int[valArray.length];
        for (int i = 0; i < valArray.length; ++i) {
            intArray[i] = Integer.valueOf(valArray[i]);
        }
        return intArray;
    }

    private String[] decodeArray(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value.split(",");
    }

    public void updateValue() {
        Object newValue;
        if (this.inputField == null || this.type == 7 || this.type == 8) {
            return;
        }
        if (this.type == 1) {
            newValue = this.usingSlider ? new Double(((JSlider)this.inputField).getValue()) : new Double(((JTextField)this.inputField).getText());
        } else if (this.type == 0) {
            newValue = this.usingSlider ? new Integer(((JSlider)this.inputField).getValue()) : new Integer(((JTextField)this.inputField).getText());
        } else if (this.type == 2) {
            newValue = new Boolean(((JCheckBox)this.inputField).isSelected());
        } else if (this.type == 6) {
            if (this.checkFlag(4)) {
                int[] selVals = ((JList)this.inputField).getSelectedIndices();
                String newString = "";
                for (int i = 0; i < selVals.length; ++i) {
                    newString = newString + Integer.toString(selVals[i]);
                    if (i >= selVals.length - 1) continue;
                    newString = newString + ",";
                }
                newValue = newString;
            } else {
                newValue = new Integer(((JComboBox)this.inputField).getSelectedIndex());
            }
        } else if (this.type == 4 || this.type == 5) {
            if (this.checkFlag(4)) {
                Object[] selVals = ((JList)this.inputField).getSelectedValues();
                String newString = "";
                for (int i = 0; i < selVals.length; ++i) {
                    newString = newString + selVals[i];
                    if (i >= selVals.length) continue;
                    newString = newString + ",";
                }
                newValue = newString;
            } else {
                newValue = (String)((JComboBox)this.inputField).getSelectedItem();
            }
        } else {
            newValue = ((JTextField)this.inputField).getText();
        }
        if (this.value == null || !this.value.equals(newValue)) {
            this.valueChanged = true;
        }
        this.value = newValue;
    }

    @Override
    public void focusLost(FocusEvent ev) {
        Number value = null;
        if (this.type == 1) {
            Double newValue = null;
            try {
                newValue = new Double(((JTextField)this.inputField).getText());
            }
            catch (NumberFormatException e) {
                this.displayBoundsError("a floating point");
                return;
            }
            if (this.upperBound != null && newValue > (Double)this.upperBound || this.lowerBound != null && newValue < (Double)this.lowerBound) {
                this.displayBoundsError("a floating point");
                return;
            }
            value = newValue;
        } else if (this.type == 0) {
            Integer newValue = null;
            try {
                newValue = new Integer(((JTextField)this.inputField).getText());
            }
            catch (NumberFormatException e) {
                this.displayBoundsError("an integer");
                return;
            }
            if (this.upperBound != null && newValue > (Integer)this.upperBound || this.lowerBound != null && newValue < (Integer)this.lowerBound) {
                this.displayBoundsError("an integer");
                return;
            }
            value = newValue;
        }
        if (this.checkFlag(8)) {
            this.slider.setValue(this.sliderScale(value));
        } else {
            this.updateValueListeners();
        }
    }

    @Override
    public void focusGained(FocusEvent ev) {
        this.savedValue = ((JTextField)this.inputField).getText();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if ((this.type == 1 || this.type == 0) && this.checkFlag(8)) {
            JSlider slider = (JSlider)e.getSource();
            int value = slider.getValue();
            ((JTextField)this.inputField).setText(this.sliderScale(value).toString());
        } else {
            this.updateValueListeners();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.type == 7 && this.checkFlag(32)) {
            this.collapsed = !this.collapsed;
            this.lowerBound = this.collapsed;
        }
        this.updateValueListeners();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateValueListeners();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateValueListeners();
    }

    private void displayBoundsError(String typeString) {
        if (this.lowerBound != null && this.upperBound != null) {
            JOptionPane.showMessageDialog(null, "Value must be " + typeString + " between " + this.lowerBound + " and " + this.upperBound, "Bounds Error", 0);
        } else if (this.lowerBound != null) {
            JOptionPane.showMessageDialog(null, "Value must be " + typeString + " greater than " + this.lowerBound, "Bounds Error", 0);
        } else if (this.upperBound != null) {
            JOptionPane.showMessageDialog(null, "Value must be " + typeString + " less than " + this.upperBound, "Bounds Error", 0);
        } else {
            JOptionPane.showMessageDialog(null, "Value must be " + typeString + " number", "Type Error", 0);
        }
        ((JTextField)this.inputField).setText(this.savedValue);
    }

    private int getIntValue(Object v) {
        if (this.type == 1) {
            Double d = (Double)v;
            return d.intValue();
        }
        if (this.type == 0) {
            Integer d = (Integer)v;
            return d;
        }
        return 0;
    }

    private int sliderScale(Object value) {
        if (this.type == 0) {
            return (Integer)value;
        }
        double minimum = (Double)this.lowerBound;
        double maximum = (Double)this.upperBound;
        double input = (Double)value;
        double extent = maximum - minimum;
        return (int)((input - minimum) / extent * 100.0);
    }

    private Object sliderScale(int value) {
        if (this.type == 0) {
            return value;
        }
        double minimum = (Double)this.lowerBound;
        double maximum = (Double)this.upperBound;
        double extent = maximum - minimum;
        double dvalue = (double)value / 100.0;
        double scaledValue = dvalue * extent + minimum;
        int places = 2;
        if (extent < 1.0) {
            places = (int)Math.round(-Math.log10(extent)) + 1;
        }
        return new Double(this.round(scaledValue, places));
    }

    private Hashtable createLabels(JSlider slider) {
        if (this.type == 0) {
            int increment = (this.getIntValue(this.upperBound) - this.getIntValue(this.lowerBound)) / 5;
            if (increment > 1) {
                return slider.createStandardLabels(increment);
            }
            return slider.createStandardLabels(1);
        }
        Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
        for (int label = 0; label < 6; ++label) {
            Double v = (Double)this.sliderScale(label * 20);
            table.put(label * 20, new JLabel(v.toString()));
        }
        return table;
    }

    private double round(double val, int places) {
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(val *= (double)factor);
        return (double)tmp / (double)factor;
    }
}

