/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import cytoscape.Cytoscape;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.logger.CyLogger;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.view.CyNetworkView;
import java.awt.Container;

public class LayoutTask
implements Task {
    CyLayoutAlgorithm layout;
    CyNetworkView view;
    TaskMonitor monitor;
    CyLogger logger = CyLogger.getLogger(LayoutTask.class);

    public LayoutTask(CyLayoutAlgorithm layout, CyNetworkView view) {
        this.layout = layout;
        this.view = view;
    }

    public void setTaskMonitor(TaskMonitor monitor) {
        this.monitor = monitor;
    }

    public void run() {
        try {
            this.layout.doLayout(this.view, this.monitor);
        }
        catch (Exception e) {
            String message = "Execution of " + this.layout.getName() + " did not complete!  Error: " + e.getMessage();
            if (this.monitor != null) {
                this.monitor.setException((Throwable)e, message);
                this.logger.warn(message, e);
            }
            this.logger.error(message, e);
        }
    }

    public void halt() {
        this.layout.halt();
    }

    public String getTitle() {
        return "Performing " + this.layout.toString();
    }

    public static JTaskConfig getDefaultTaskConfig() {
        JTaskConfig result = new JTaskConfig();
        result.displayCancelButton(true);
        result.displayCloseButton(false);
        result.displayStatus(true);
        result.displayTimeElapsed(false);
        result.setAutoDispose(true);
        result.setModal(true);
        result.setOwner((Container)Cytoscape.getDesktop());
        return result;
    }
}

