/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import cytoscape.CytoscapeInit;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.algorithms.GridNodeLayout;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyLayouts {
    private static HashMap<String, CyLayoutAlgorithm> layoutMap;
    private static HashMap<CyLayoutAlgorithm, String> menuNameMap;

    private CyLayouts() {
        layoutMap = new HashMap();
        menuNameMap = new HashMap();
        CyLayouts.addLayout(new GridNodeLayout(), "Cytoscape Layouts");
    }

    public static void addLayout(CyLayoutAlgorithm layout, String menu) {
        layoutMap.put(layout.getName(), layout);
        menuNameMap.put(layout, menu);
    }

    public static void removeLayout(CyLayoutAlgorithm layout) {
        layoutMap.remove(layout.getName());
        menuNameMap.remove(layout);
    }

    public static CyLayoutAlgorithm getLayout(String name) {
        if (layoutMap.containsKey(name)) {
            return layoutMap.get(name);
        }
        return null;
    }

    public static Collection<CyLayoutAlgorithm> getAllLayouts() {
        return layoutMap.values();
    }

    public static CyLayoutAlgorithm getDefaultLayout() {
        String defaultLayout = CytoscapeInit.getProperties().getProperty("layout.default");
        if (defaultLayout == null || !layoutMap.containsKey(defaultLayout)) {
            defaultLayout = "grid";
        }
        CyLayoutAlgorithm l = layoutMap.get(defaultLayout);
        return l;
    }

    public static String getMenuName(CyLayoutAlgorithm layout) {
        return menuNameMap.get(layout);
    }

    static {
        new CyLayouts();
    }
}

