/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.preferences;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.util.ProxyHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetSocketAddress;
import java.net.Proxy;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProxyServerDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = -2693844068486336199L;
    private JButton btnCancel;
    private JButton btnUpdate;
    private JCheckBox chbUseProxy;
    private JComboBox cmbType;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lbHost;
    private JLabel lbPort;
    private JLabel lbType;
    private JLabel lbUseProxy;
    private JTextField tfHost;
    private JTextField tfPort;

    public ProxyServerDialog(JFrame pParent) {
        super((Frame)pParent, true);
        this.setTitle("Proxy server setting");
        this.setLocationRelativeTo(pParent);
        this.initComponents();
        this.initValues();
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.lbUseProxy = new JLabel();
        this.chbUseProxy = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.btnUpdate = new JButton();
        this.btnCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.lbType = new JLabel();
        this.lbHost = new JLabel();
        this.lbPort = new JLabel();
        this.cmbType = new JComboBox();
        this.tfHost = new JTextField();
        this.tfPort = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.lbUseProxy.setText("Use Proxy");
        this.jPanel3.add(this.lbUseProxy);
        this.chbUseProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chbUseProxy.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel3.add(this.chbUseProxy);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.btnUpdate.setText("Update");
        this.jPanel1.add(this.btnUpdate);
        this.btnCancel.setText("Cancel");
        this.jPanel1.add(this.btnCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Proxy Settings"));
        this.lbType.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.lbType, gridBagConstraints);
        this.lbHost.setText("Host name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.lbHost, gridBagConstraints);
        this.lbPort.setText("Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.lbPort, gridBagConstraints);
        this.cmbType.setModel(new DefaultComboBoxModel<String>(new String[]{"HTTP", "SOCKS"}));
        this.cmbType.setMinimumSize(new Dimension(61, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 10, 10, 5);
        this.jPanel2.add((Component)this.cmbType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.jPanel2.add((Component)this.tfHost, gridBagConstraints);
        this.tfPort.setMinimumSize(new Dimension(43, 19));
        this.tfPort.setPreferredSize(new Dimension(43, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 10, 10);
        this.jPanel2.add((Component)this.tfPort, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.btnUpdate.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.chbUseProxy.addItemListener(this);
        this.pack();
        this.setSize(new Dimension(400, 200));
    }

    private void initValues() {
        Proxy p = ProxyHandler.getProxyServer();
        this.chbUseProxy.setSelected(true);
        this.cmbType.setEnabled(true);
        this.tfHost.setEnabled(true);
        this.tfPort.setEnabled(true);
        if (p == null) {
            this.tfHost.setText("");
            this.tfPort.setText("");
            this.chbUseProxy.setSelected(false);
            this.cmbType.setEnabled(false);
            this.tfHost.setEnabled(false);
            this.tfPort.setEnabled(false);
            return;
        }
        if (p.type() == Proxy.Type.HTTP) {
            this.cmbType.setSelectedItem("HTTP");
        } else if (p.type() == Proxy.Type.SOCKS) {
            this.cmbType.setSelectedItem("SOCKS");
        }
        InetSocketAddress address = (InetSocketAddress)p.address();
        this.tfHost.setText(address.getHostName());
        this.tfPort.setText(new Integer(address.getPort()).toString());
    }

    public void itemStateChanged(ItemEvent e) {
        Object _actionObject = e.getSource();
        if (_actionObject instanceof JCheckBox) {
            if (this.chbUseProxy.isSelected()) {
                this.cmbType.setEnabled(true);
                this.tfHost.setEnabled(true);
                this.tfPort.setEnabled(true);
            } else {
                this.cmbType.setEnabled(false);
                this.tfHost.setEnabled(false);
                this.tfPort.setEnabled(false);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object _actionObject = e.getSource();
        if (_actionObject instanceof JButton) {
            JButton _btn = (JButton)_actionObject;
            if (_btn == this.btnCancel) {
                this.dispose();
            } else if (_btn == this.btnUpdate) {
                if (!this.updateProxyServer()) {
                    return;
                }
                this.dispose();
            }
        }
    }

    private boolean updateProxyServer() {
        Proxy.Type proxyType = Proxy.Type.valueOf(this.cmbType.getSelectedItem().toString());
        if (!this.chbUseProxy.isSelected()) {
            this.tfHost.setText("");
            this.tfPort.setText("");
        } else {
            int thePort;
            if (this.tfHost.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this, "Host name is empty!", "Warning", 1);
                return false;
            }
            try {
                Integer tmpInteger = new Integer(this.tfPort.getText().trim());
                thePort = tmpInteger;
            }
            catch (Exception exp) {
                JOptionPane.showMessageDialog(this, "Port error!", "Warning", 1);
                return false;
            }
            InetSocketAddress theAddress = new InetSocketAddress(this.tfHost.getText().trim(), thePort);
            try {
                new Proxy(proxyType, theAddress);
            }
            catch (Exception expProxy) {
                JOptionPane.showMessageDialog(this, "Proxy server error!", "Warning", 1);
                return false;
            }
        }
        CytoscapeInit.getProperties().setProperty("proxy.server", this.tfHost.getText().trim());
        CytoscapeInit.getProperties().setProperty("proxy.server.port", this.tfPort.getText());
        CytoscapeInit.getProperties().setProperty("proxy.server.type", this.cmbType.getSelectedItem().toString());
        Cytoscape.firePropertyChange("PREFERENCES_UPDATED", null, null);
        return true;
    }
}

