/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.bookmarks.DataSource;
import cytoscape.logger.CyLogger;
import cytoscape.util.BookmarksUtil;
import cytoscape.util.ProxyHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.bind.JAXBException;

public class URLimportAdvancedDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
ItemListener {
    JDialog parent;
    private String bookmarkCategory;
    private Bookmarks theBookmarks;
    private JPanel bookmarkPanel;
    private JButton btnAddBookmark;
    private JButton btnDeleteBookmark;
    private JButton btnEditBookmark;
    private JButton btnOK;
    private JPanel btnPanelBookmark;
    private JButton btnSetProxy;
    private JComboBox cmbProxyType;
    private JLabel jLabel3;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JLabel lbBookmarkTitle;
    private JLabel lbHostName;
    private JLabel lbPort;
    private JLabel lbProxyServer;
    private JLabel lbProxyTitle;
    private JLabel lbType;
    private JPanel proxyPanel;
    private JTextField tfHost;
    private JTextField tfPort;
    private JList bookmarkList;

    public URLimportAdvancedDialog(JDialog pParent, boolean modal, String pBookmarkCategory, Bookmarks pBookmarks) {
        super((Dialog)pParent, modal);
        this.setTitle("Advanced Setting for " + pBookmarkCategory + " import");
        this.parent = pParent;
        this.theBookmarks = pBookmarks;
        this.bookmarkCategory = pBookmarkCategory;
        this.initComponents();
        this.loadBookmarks();
    }

    private void initComponents() {
        this.proxyPanel = new JPanel();
        this.lbProxyTitle = new JLabel();
        this.lbProxyServer = new JLabel();
        this.lbType = new JLabel();
        this.lbHostName = new JLabel();
        this.lbPort = new JLabel();
        this.cmbProxyType = new JComboBox();
        this.tfHost = new JTextField();
        this.tfPort = new JTextField();
        this.btnSetProxy = new JButton();
        this.bookmarkPanel = new JPanel();
        this.lbBookmarkTitle = new JLabel();
        this.bookmarkList = new JList();
        this.jScrollPane1 = new JScrollPane(this.bookmarkList);
        this.btnPanelBookmark = new JPanel();
        this.btnAddBookmark = new JButton();
        this.btnEditBookmark = new JButton();
        this.btnDeleteBookmark = new JButton();
        this.jLabel3 = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnOK = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.proxyPanel.setLayout(new GridBagLayout());
        this.proxyPanel.setBorder(BorderFactory.createTitledBorder("Proxy Server"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.proxyPanel.add((Component)this.lbProxyTitle, gridBagConstraints);
        this.lbProxyServer.setText("None");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 8, 0);
        this.proxyPanel.add((Component)this.lbProxyServer, gridBagConstraints);
        this.lbType.setText("Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.proxyPanel.add((Component)this.lbType, gridBagConstraints);
        this.lbHostName.setText("Host name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.proxyPanel.add((Component)this.lbHostName, gridBagConstraints);
        this.lbPort.setText("Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        this.proxyPanel.add((Component)this.lbPort, gridBagConstraints);
        this.cmbProxyType.setModel(new DefaultComboBoxModel<String>(new String[]{"DIRECT", "HTTP", "SOCKS"}));
        this.cmbProxyType.setMinimumSize(new Dimension(61, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(3, 5, 3, 3);
        this.proxyPanel.add((Component)this.cmbProxyType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.proxyPanel.add((Component)this.tfHost, gridBagConstraints);
        this.tfPort.setMinimumSize(new Dimension(50, 19));
        this.tfPort.setPreferredSize(new Dimension(50, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.proxyPanel.add((Component)this.tfPort, gridBagConstraints);
        this.btnSetProxy.setText("Set");
        this.btnSetProxy.setMinimumSize(new Dimension(63, 23));
        this.btnSetProxy.setPreferredSize(new Dimension(63, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.proxyPanel.add((Component)this.btnSetProxy, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 3, 0, 3);
        this.getContentPane().add((Component)this.proxyPanel, gridBagConstraints);
        this.bookmarkPanel.setLayout(new GridBagLayout());
        this.bookmarkPanel.setBorder(BorderFactory.createTitledBorder("Bookmarks"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        this.bookmarkPanel.add((Component)this.lbBookmarkTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.bookmarkPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.btnPanelBookmark.setLayout(new GridBagLayout());
        this.btnAddBookmark.setText("Add");
        this.btnAddBookmark.setMinimumSize(new Dimension(63, 23));
        this.btnAddBookmark.setPreferredSize(new Dimension(63, 23));
        this.btnPanelBookmark.add((Component)this.btnAddBookmark, new GridBagConstraints());
        this.btnEditBookmark.setText("Edit");
        this.btnEditBookmark.setMinimumSize(new Dimension(63, 23));
        this.btnEditBookmark.setPreferredSize(new Dimension(63, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.btnPanelBookmark.add((Component)this.btnEditBookmark, gridBagConstraints);
        this.btnDeleteBookmark.setText("Delete");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.btnPanelBookmark.add((Component)this.btnDeleteBookmark, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.bookmarkPanel.add((Component)this.btnPanelBookmark, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 3, 0, 3);
        this.getContentPane().add((Component)this.bookmarkPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 88, 0, 0);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.btnOK.setText("OK");
        this.jPanel2.add(this.btnOK);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 15, 0);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.btnSetProxy.setEnabled(false);
        this.lbProxyServer.setText(this.getProxyServerString());
        this.btnEditBookmark.setEnabled(false);
        this.btnDeleteBookmark.setEnabled(false);
        this.btnOK.addActionListener(this);
        this.btnSetProxy.addActionListener(this);
        this.btnAddBookmark.addActionListener(this);
        this.btnEditBookmark.addActionListener(this);
        this.btnDeleteBookmark.addActionListener(this);
        this.bookmarkList.addListSelectionListener(this);
        this.bookmarkList.setCellRenderer(new MyListCellRenderer());
        this.bookmarkList.setSelectionMode(0);
        this.cmbProxyType.addItemListener(this);
    }

    public void itemStateChanged(ItemEvent e) {
        String selectedItem = this.cmbProxyType.getSelectedItem().toString();
        if (selectedItem.equalsIgnoreCase("DIRECT")) {
            this.btnSetProxy.setEnabled(false);
        } else {
            this.btnSetProxy.setEnabled(true);
        }
    }

    public URLimportAdvancedDialog() {
        this.setTitle("Advanced Setting for network import");
        this.theBookmarks = this.getTestBookmarks();
        this.initComponents();
        this.loadBookmarks();
    }

    private Bookmarks getTestBookmarks() {
        Bookmarks tmpBookmarks = null;
        File tmpBookmarkFile = new File("bookmarks.xml");
        try {
            tmpBookmarks = BookmarksUtil.getBookmarks(tmpBookmarkFile.toURL());
        }
        catch (IOException e) {
            CyLogger.getLogger(URLimportAdvancedDialog.class).warn("IOException -- bookmarkSource", e);
        }
        catch (JAXBException e) {
            CyLogger.getLogger(URLimportAdvancedDialog.class).warn("JAXBException -- bookmarkSource", e);
        }
        catch (Exception e) {
            CyLogger.getLogger(URLimportAdvancedDialog.class).warn("Can not read the bookmark file, the bookmark file may not exist!", e);
        }
        return tmpBookmarks;
    }

    private void loadBookmarks() {
        List<DataSource> theDataSourceList = BookmarksUtil.getDataSourceList(this.bookmarkCategory, this.theBookmarks.getCategory());
        MyListModel theModel = new MyListModel(theDataSourceList);
        this.bookmarkList.setModel(theModel);
    }

    public void actionPerformed(ActionEvent e) {
        Object _actionObject = e.getSource();
        if (_actionObject instanceof JButton) {
            JButton _btn = (JButton)_actionObject;
            if (_btn == this.btnOK) {
                this.dispose();
            } else if (_btn == this.btnAddBookmark) {
                BookmarkDialog theNewDialog = new BookmarkDialog(this, true, this.theBookmarks, this.bookmarkCategory, "new", null);
                theNewDialog.setSize(300, 250);
                theNewDialog.setLocationRelativeTo(this);
                theNewDialog.setVisible(true);
                this.loadBookmarks();
            } else if (_btn == this.btnEditBookmark) {
                DataSource theDataSource = (DataSource)this.bookmarkList.getSelectedValue();
                BookmarkDialog theEditDialog = new BookmarkDialog(this, true, this.theBookmarks, this.bookmarkCategory, "edit", theDataSource);
                theEditDialog.setSize(300, 250);
                theEditDialog.setLocationRelativeTo(this);
                theEditDialog.setVisible(true);
                this.loadBookmarks();
            } else if (_btn == this.btnDeleteBookmark) {
                DataSource theDataSource = (DataSource)this.bookmarkList.getSelectedValue();
                MyListModel theModel = (MyListModel)this.bookmarkList.getModel();
                theModel.removeElement(this.bookmarkList.getSelectedIndex());
                BookmarksUtil.deleteBookmark(this.theBookmarks, this.bookmarkCategory, theDataSource);
                if (theModel.getSize() == 0) {
                    this.btnEditBookmark.setEnabled(false);
                    this.btnDeleteBookmark.setEnabled(false);
                }
            } else if (_btn == this.btnSetProxy) {
                Proxy.Type proxyType = Proxy.Type.valueOf(this.cmbProxyType.getSelectedItem().toString());
                if (proxyType == Proxy.Type.DIRECT) {
                    this.lbProxyServer.setText("None");
                    return;
                }
                Integer tmpInteger = new Integer(-1);
                try {
                    tmpInteger = new Integer(this.tfPort.getText().trim());
                    int thePort = tmpInteger;
                }
                catch (Exception exp) {
                    JOptionPane.showMessageDialog(this, "Port error!", "Warning", 1);
                    return;
                }
                CytoscapeInit.getProperties().setProperty("proxy.server", this.tfHost.getText().trim());
                CytoscapeInit.getProperties().setProperty("proxy.server.port", tmpInteger.toString());
                CytoscapeInit.getProperties().setProperty("proxy.server.type", proxyType.toString());
                Cytoscape.firePropertyChange("PREFERENCES_UPDATED", null, null);
                this.lbProxyServer.setText(this.getProxyServerString());
            }
        }
    }

    private String getProxyServerString() {
        Proxy p = ProxyHandler.getProxyServer();
        if (p == null) {
            return "None";
        }
        return p.toString();
    }

    public void valueChanged(ListSelectionEvent pListSelectionEvent) {
        if (this.bookmarkList.getSelectedIndex() == -1) {
            this.btnEditBookmark.setEnabled(false);
            this.btnDeleteBookmark.setEnabled(false);
        } else {
            this.btnEditBookmark.setEnabled(true);
            this.btnDeleteBookmark.setEnabled(true);
        }
    }

    public static void main(String[] args) {
        URLimportAdvancedDialog theDialog = new URLimportAdvancedDialog();
        theDialog.setPreferredSize(new Dimension(350, 400));
        theDialog.pack();
        theDialog.setVisible(true);
    }

    public class BookmarkDialog
    extends JDialog
    implements ActionListener {
        private String name;
        private String URLstr;
        private JDialog parent;
        private Bookmarks theBookmarks;
        private String categoryName;
        private URL bookmarkURL;
        private String mode;
        private DataSource dataSource;
        private JButton btnCancel;
        private JButton btnOK;
        private JPanel jPanel1;
        private JLabel lbName;
        private JLabel lbURL;
        private JTextField tfName;
        private JTextField tfURL;

        public BookmarkDialog(JDialog parent, boolean modal, Bookmarks pBookmarks, String categoryName, String pMode, DataSource pDataSource) {
            super((Dialog)parent, modal);
            this.mode = "new";
            this.dataSource = null;
            this.parent = parent;
            this.theBookmarks = pBookmarks;
            this.categoryName = categoryName;
            this.mode = pMode;
            this.dataSource = pDataSource;
            this.initComponents();
            if (pMode.equalsIgnoreCase("new")) {
                this.setTitle("Add new bookmark");
            }
            if (pMode.equalsIgnoreCase("edit")) {
                this.setTitle("Edit bookmark");
                this.tfName.setText(this.dataSource.getName());
                this.tfName.setEditable(false);
                this.tfURL.setText(this.dataSource.getHref());
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object _actionObject = e.getSource();
            if (_actionObject instanceof JButton) {
                DataSource theDataSource;
                JButton _btn = (JButton)_actionObject;
                if (_btn == this.btnOK && this.mode.equalsIgnoreCase("new")) {
                    this.name = this.tfName.getText();
                    this.URLstr = this.tfURL.getText();
                    if (this.name.trim().equals("") || this.URLstr.trim().equals("")) {
                        String msg = "Please provide a name/URL!";
                        JOptionPane.showMessageDialog(this.parent, msg, "Warning", 1);
                        return;
                    }
                    theDataSource = new DataSource();
                    theDataSource.setName(this.name);
                    theDataSource.setHref(this.URLstr);
                    if (BookmarksUtil.isInBookmarks(this.bookmarkURL, this.categoryName, theDataSource)) {
                        String msg = "Bookmark already existed!";
                        JOptionPane.showMessageDialog(this.parent, msg, "Warning", 1);
                        return;
                    }
                    BookmarksUtil.saveBookmark(this.theBookmarks, this.categoryName, theDataSource);
                    this.dispose();
                }
                if (_btn == this.btnOK && this.mode.equalsIgnoreCase("edit")) {
                    this.name = this.tfName.getText();
                    this.URLstr = this.tfURL.getText();
                    if (this.URLstr.trim().equals("")) {
                        String msg = "URL is empty!";
                        JOptionPane.showMessageDialog(this.parent, msg, "Warning", 1);
                        return;
                    }
                    theDataSource = new DataSource();
                    theDataSource.setName(this.name);
                    theDataSource.setHref(this.URLstr);
                    BookmarksUtil.deleteBookmark(this.theBookmarks, URLimportAdvancedDialog.this.bookmarkCategory, theDataSource);
                    BookmarksUtil.saveBookmark(this.theBookmarks, this.categoryName, theDataSource);
                    this.dispose();
                } else if (_btn == this.btnCancel) {
                    this.dispose();
                }
            }
        }

        private void initComponents() {
            this.lbName = new JLabel();
            this.tfName = new JTextField();
            this.lbURL = new JLabel();
            this.tfURL = new JTextField();
            this.jPanel1 = new JPanel();
            this.btnOK = new JButton();
            this.btnCancel = new JButton();
            this.getContentPane().setLayout(new GridBagLayout());
            this.setDefaultCloseOperation(2);
            this.lbName.setText("Name");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.getContentPane().add((Component)this.lbName, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 10, 10, 10);
            this.getContentPane().add((Component)this.tfName, gridBagConstraints);
            this.lbURL.setText("URL");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.getContentPane().add((Component)this.lbURL, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 10, 10, 10);
            this.getContentPane().add((Component)this.tfURL, gridBagConstraints);
            this.btnOK.setText("OK");
            this.btnOK.setPreferredSize(new Dimension(65, 23));
            this.jPanel1.add(this.btnOK);
            this.btnCancel.setText("Cancel");
            this.jPanel1.add(this.btnCancel);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(20, 20, 20, 20);
            this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
            this.btnOK.addActionListener(this);
            this.btnCancel.addActionListener(this);
            this.pack();
        }
    }

    class MyListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DataSource theDataSource = (DataSource)value;
            this.setText(theDataSource.getName());
            this.setToolTipText(theDataSource.getHref());
            this.setBackground(isSelected ? Color.red : Color.white);
            this.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyListModel
    extends AbstractListModel {
        List<DataSource> theDataSourceList = new ArrayList<DataSource>(0);

        public MyListModel(List<DataSource> pDataSourceList) {
            this.theDataSourceList = pDataSourceList;
        }

        @Override
        public int getSize() {
            if (this.theDataSourceList == null) {
                return 0;
            }
            return this.theDataSourceList.size();
        }

        @Override
        public Object getElementAt(int i) {
            if (this.theDataSourceList == null) {
                return null;
            }
            return this.theDataSourceList.get(i);
        }

        public void addElement(DataSource pDataSource) {
            this.theDataSourceList.add(pDataSource);
        }

        public void removeElement(int pIndex) {
            this.theDataSourceList.remove(pIndex);
            this.fireContentsChanged(this, pIndex, pIndex);
        }
    }
}

