/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.CyNetwork;
import cytoscape.data.readers.MetadataParser;
import java.net.URISyntaxException;
import java.util.Map;
import javax.swing.table.DefaultTableModel;

public class NetworkMetaDataTableModel
extends DefaultTableModel {
    private CyNetwork network;
    private Object[][] dataArray;
    private Map data;
    private String description;
    private static String[] columnHeader = new String[]{"Data Label", "Value"};
    private static String[] defaultEntries = new String[]{"Title", "Identifier", "Source", "Type", "Format", "Date"};
    private MetadataParser mdp;

    public NetworkMetaDataTableModel(CyNetwork network) {
        this.network = network;
        this.description = null;
        this.mdp = new MetadataParser(this.network);
    }

    protected void setTable() throws URISyntaxException {
        Object[] column_names = new Object[]{"Data Label", "Value"};
        this.data = this.mdp.getMetadataMap();
        this.description = (String)this.data.get("Description");
        this.dataArray = new Object[defaultEntries.length][2];
        for (int i = 0; i < defaultEntries.length; ++i) {
            String key = defaultEntries[i];
            this.dataArray[i][0] = key;
            this.dataArray[i][1] = this.data.get(key);
        }
        this.setDataVector(this.dataArray, columnHeader);
    }

    public String getDescription() {
        return this.description;
    }

    public int getColumnCount() {
        return columnHeader.length;
    }

    public int getRowCount() {
        return defaultEntries.length;
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 0) {
            return false;
        }
        return row != 0;
    }

    public Object getValueAt(int arg0, int arg1) {
        return this.dataArray[arg0][arg1];
    }

    public void setValueAt(Object obj, int row, int col) {
        this.dataArray[row][col] = obj;
        this.setDataVector(this.dataArray, columnHeader);
        this.fireTableCellUpdated(row, col);
    }
}

