/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.writers;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import cytoscape.data.attr.MultiHashMapDefinition;
import cytoscape.data.writers.GraphicsType;
import cytoscape.data.writers.ObjectType;
import cytoscape.groups.CyGroup;
import cytoscape.groups.CyGroupManager;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.LineStyle;
import ding.view.DGraphView;
import ding.view.DingCanvas;
import giny.view.Bend;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XGMMLWriter {
    private static final String XML_STRING = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
    private static final String[] NAMESPACES = new String[]{"xmlns:dc=\"http://purl.org/dc/elements/1.1/\"", "xmlns:xlink=\"http://www.w3.org/1999/xlink\"", "xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"", "xmlns:cy=\"http://www.cytoscape.org\"", "xmlns=\"http://www.cs.rpi.edu/XGMML\""};
    private static final String FORMAT_VERSION = "documentVersion";
    private static final float VERSION = 1.1f;
    private static final String METADATA_NAME = "networkMetadata";
    private static final String METADATA_ATTR_NAME = "Network Metadata";
    protected static final String NORMAL = "normal";
    protected static final String METANODE = "group";
    protected static final String REFERENCE = "reference";
    protected static final int NODE = 1;
    protected static final int EDGE = 2;
    protected static final int NETWORK = 3;
    public static final String BACKGROUND = "backgroundColor";
    public static final String GRAPH_VIEW_ZOOM = "GRAPH_VIEW_ZOOM";
    public static final String GRAPH_VIEW_CENTER_X = "GRAPH_VIEW_CENTER_X";
    public static final String GRAPH_VIEW_CENTER_Y = "GRAPH_VIEW_CENTER_Y";
    private CyAttributes nodeAttributes;
    private CyAttributes edgeAttributes;
    private CyAttributes networkAttributes;
    private String[] nodeAttNames = null;
    private String[] edgeAttNames = null;
    private String[] networkAttNames = null;
    private CyNetwork network;
    private CyNetworkView networkView;
    private HashMap<CyNode, CyNode> nodeMap;
    private HashMap<CyEdge, CyEdge> edgeMap;
    private boolean noCytoscapeGraphics = false;
    private int depth = 0;
    private String indentString = "";
    private Writer writer = null;

    public XGMMLWriter(CyNetwork network, CyNetworkView view) throws IOException, URISyntaxException {
        this.network = network;
        this.networkView = view;
        this.nodeAttributes = Cytoscape.getNodeAttributes();
        this.edgeAttributes = Cytoscape.getEdgeAttributes();
        this.networkAttributes = Cytoscape.getNetworkAttributes();
        this.nodeMap = new HashMap();
        this.edgeMap = new HashMap();
        this.nodeAttNames = this.nodeAttributes.getAttributeNames();
        this.edgeAttNames = this.edgeAttributes.getAttributeNames();
        this.networkAttNames = this.networkAttributes.getAttributeNames();
        for (int i = 0; i < 20; ++i) {
            this.indentString = this.indentString + "                        ";
        }
    }

    public XGMMLWriter(CyNetwork network, CyNetworkView view, boolean noCytoscapeGraphics) throws IOException, URISyntaxException {
        this(network, view);
        this.noCytoscapeGraphics = noCytoscapeGraphics;
    }

    public void write(Writer writer) throws IOException {
        this.writer = writer;
        this.writePreamble();
        ++this.depth;
        this.writeMetadata();
        this.writeNetworkAttributes();
        this.writeNodes();
        this.writeGroups();
        this.writeEdges();
        --this.depth;
        this.writeElement("</graph>\n");
        writer.flush();
    }

    private void writePreamble() throws IOException {
        this.writeElement("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        this.writeElement("<graph label=\"" + this.network.getTitle() + "\" ");
        for (int ns = 0; ns < NAMESPACES.length; ++ns) {
            this.writer.write(NAMESPACES[ns] + " ");
        }
        this.writer.write(" directed=\"1\">\n");
    }

    private void writeMetadata() throws IOException {
        this.writeElement("<att name=\"documentVersion\" value=\"1.1\"/>\n");
        this.writeElement("<att name=\"networkMetadata\">\n");
        ++this.depth;
        this.writeRDF();
        --this.depth;
        this.writeElement("</att>\n");
    }

    private void writeRDF() throws IOException {
        this.writeElement("<rdf:RDF>\n");
        ++this.depth;
        this.writeElement("<rdf:Description rdf:about=\"http://www.cytoscape.org/\">\n");
        ++this.depth;
        this.writeElement("<dc:type>Protein-Protein Interaction</dc:type>\n");
        this.writeElement("<dc:description>N/A</dc:description>\n");
        this.writeElement("<dc:identifier>N/A</dc:identifier>\n");
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.writeElement("<dc:date>" + df.format(now) + "</dc:date>\n");
        this.writeElement("<dc:title>" + this.network.getTitle() + "</dc:title>\n");
        this.writeElement("<dc:source>http://www.cytoscape.org/</dc:source>\n");
        this.writeElement("<dc:format>Cytoscape-XGMML</dc:format>\n");
        --this.depth;
        this.writeElement("</rdf:Description>\n");
        --this.depth;
        this.writeElement("</rdf:RDF>\n");
    }

    private void writeNetworkAttributes() throws IOException {
        if (this.networkView != null) {
            DingCanvas backgroundCanvas = ((DGraphView)Cytoscape.getCurrentNetworkView()).getCanvas(DGraphView.Canvas.BACKGROUND_CANVAS);
            this.writeAttributeXML(BACKGROUND, ObjectType.STRING, this.paint2string(backgroundCanvas.getBackground()), true);
            Double dAttr = new Double(this.networkView.getZoom());
            this.writeAttributeXML(GRAPH_VIEW_ZOOM, ObjectType.REAL, dAttr, true);
            Point2D center = ((DGraphView)this.networkView).getCenter();
            this.writeAttributeXML(GRAPH_VIEW_CENTER_X, ObjectType.REAL, new Double(center.getX()), true);
            this.writeAttributeXML(GRAPH_VIEW_CENTER_Y, ObjectType.REAL, new Double(center.getY()), true);
        }
        for (int att = 0; att < this.networkAttNames.length; ++att) {
            if (!this.networkAttributes.hasAttribute(this.network.getIdentifier(), this.networkAttNames[att])) continue;
            this.writeAttribute(this.network.getIdentifier(), this.networkAttributes, this.networkAttNames[att]);
        }
    }

    private void writeNodes() throws IOException {
        for (CyNode curNode : this.network.nodesList()) {
            if (curNode.isaGroup()) continue;
            this.writeNode(curNode, null);
        }
    }

    private void writeNode(CyNode node, List<CyNode> groupList) throws IOException {
        this.nodeMap.put(node, node);
        this.writeElement("<node label=" + this.quote(node.getIdentifier()));
        this.writer.write(" id=" + this.quote(Integer.toString(node.getRootGraphIndex())) + ">\n");
        ++this.depth;
        for (int att = 0; att < this.nodeAttNames.length; ++att) {
            if (!this.nodeAttributes.hasAttribute(node.getIdentifier(), this.nodeAttNames[att])) continue;
            this.writeAttribute(node.getIdentifier(), this.nodeAttributes, this.nodeAttNames[att]);
        }
        if (groupList != null && groupList.size() > 0) {
            this.writeElement("<att>\n");
            ++this.depth;
            this.writeElement("<graph>\n");
            ++this.depth;
            for (CyNode childNode : groupList) {
                if (childNode.isaGroup()) {
                    CyGroup childGroup = CyGroupManager.getCyGroup(childNode);
                    this.writeNode(childGroup.getGroupNode(), childGroup.getNodes());
                    continue;
                }
                if (this.nodeMap.containsKey(childNode)) {
                    this.writeElement("<node xlink:href=\"#" + childNode.getRootGraphIndex() + "\"/>\n");
                    continue;
                }
                this.writeNode(childNode, null);
            }
            --this.depth;
            this.writeElement("</graph>\n");
            --this.depth;
            this.writeElement("</att>\n");
        }
        this.writeNodeGraphics(node, this.networkView.getNodeView(node));
        --this.depth;
        this.writeElement("</node>\n");
    }

    private void writeNodeGraphics(CyNode node, NodeView nodeView) throws IOException {
        if (nodeView == null) {
            return;
        }
        if (nodeView.getWidth() == -1.0) {
            this.networkView.showGraphObject(nodeView);
        }
        this.writeElement("<graphics");
        GraphicsType shape = this.number2shape(nodeView.getShape());
        if (shape == GraphicsType.PARALLELOGRAM) {
            this.writeAttributePair("type", (Object)GraphicsType.RHOMBUS);
        } else {
            this.writeAttributePair("type", (Object)shape);
        }
        this.writeAttributePair("h", Double.toString(nodeView.getHeight()));
        this.writeAttributePair("w", Double.toString(nodeView.getWidth()));
        this.writeAttributePair("x", Double.toString(nodeView.getXPosition()));
        this.writeAttributePair("y", Double.toString(nodeView.getYPosition()));
        this.writeAttributePair("fill", this.paint2string(nodeView.getUnselectedPaint()));
        BasicStroke borderType = (BasicStroke)nodeView.getBorder();
        this.writeAttributePair("width", Integer.toString((int)borderType.getLineWidth()));
        this.writeAttributePair("outline", this.paint2string(nodeView.getBorderPaint()));
        if (!this.noCytoscapeGraphics) {
            this.writeAttributePair("cy:nodeTransparency", Double.toString(nodeView.getTransparency()));
            this.writeAttributePair("cy:nodeLabelFont", this.encodeFont(nodeView.getLabel().getFont()));
            float[] dash = borderType.getDashArray();
            if (dash == null) {
                this.writeAttributePair("cy:borderLineType", "solid");
            } else {
                String dashArray = null;
                StringBuilder dashBuf = new StringBuilder();
                for (int i = 0; i < dash.length; ++i) {
                    dashBuf.append(Double.toString(dash[i]));
                    if (i >= dash.length - 1) continue;
                    dashBuf.append(",");
                }
                dashArray = dashBuf.toString();
                this.writeAttributePair("cy:borderLineType", dashArray);
            }
        }
        this.writer.write("/>\n");
    }

    private void writeGroups() throws IOException {
        ArrayList groupList = (ArrayList)CyGroupManager.getGroupList();
        if (groupList == null || groupList.isEmpty()) {
            return;
        }
        HashMap<CyGroup, CyGroup> embeddedGroupList = new HashMap<CyGroup, CyGroup>();
        ArrayList<CyGroup> groupsToWrite = new ArrayList<CyGroup>();
        for (CyGroup group : groupList) {
            List<CyNode> childList = group.getNodes();
            if (childList == null || childList.size() == 0) continue;
            boolean allNodesVisible = true;
            for (CyNode childNode : childList) {
                if (CyGroupManager.isaGroup(childNode)) {
                    CyGroup embGroup = CyGroupManager.getCyGroup(childNode);
                    embeddedGroupList.put(embGroup, embGroup);
                    continue;
                }
                if (this.network.containsNode(childNode)) continue;
                allNodesVisible = false;
            }
            if (!allNodesVisible && !this.network.containsNode(group.getGroupNode())) continue;
            groupsToWrite.add(group);
        }
        for (CyGroup group : groupsToWrite) {
            if (embeddedGroupList.containsKey(group)) continue;
            this.writeNode(group.getGroupNode(), group.getNodes());
        }
    }

    private void writeEdges() throws IOException {
        for (CyEdge curEdge : this.network.edgesList()) {
            this.edgeMap.put(curEdge, curEdge);
            this.writeEdge(curEdge);
        }
        for (CyGroup group : CyGroupManager.getGroupList()) {
            for (CyEdge edge : group.getInnerEdges()) {
                if (this.edgeMap.containsKey(edge)) continue;
                this.edgeMap.put(edge, edge);
                this.writeEdge(edge);
            }
            for (CyEdge edge : group.getOuterEdges()) {
                if (this.edgeMap.containsKey(edge)) continue;
                this.edgeMap.put(edge, edge);
                this.writeEdge(edge);
            }
        }
    }

    private void writeEdge(CyEdge curEdge) throws IOException {
        String target = this.quote(Integer.toString(curEdge.getTarget().getRootGraphIndex()));
        String source = this.quote(Integer.toString(curEdge.getSource().getRootGraphIndex()));
        if (!this.nodeMap.containsKey(curEdge.getTarget()) || !this.nodeMap.containsKey(curEdge.getSource())) {
            return;
        }
        this.writeElement("<edge label=" + this.quote(curEdge.getIdentifier()) + " source=" + source + " target=" + target + ">\n");
        ++this.depth;
        for (int att = 0; att < this.edgeAttNames.length; ++att) {
            if (!this.edgeAttributes.hasAttribute(curEdge.getIdentifier(), this.edgeAttNames[att])) continue;
            this.writeAttribute(curEdge.getIdentifier(), this.edgeAttributes, this.edgeAttNames[att]);
        }
        this.writeEdgeGraphics(curEdge, this.networkView.getEdgeView(curEdge));
        --this.depth;
        this.writeElement("</edge>\n");
    }

    private void writeEdgeGraphics(CyEdge edge, EdgeView edgeView) throws IOException {
        Bend bendData;
        List handles;
        if (edgeView == null) {
            return;
        }
        this.writeElement("<graphics");
        this.writeAttributePair("width", Integer.toString((int)edgeView.getStrokeWidth()));
        this.writeAttributePair("fill", this.paint2string(edgeView.getUnselectedPaint()));
        if (!this.noCytoscapeGraphics) {
            this.writeAttributePair("cy:sourceArrow", Integer.toString(edgeView.getSourceEdgeEnd()));
            this.writeAttributePair("cy:targetArrow", Integer.toString(edgeView.getTargetEdgeEnd()));
            this.writeAttributePair("cy:sourceArrowColor", this.paint2string(edgeView.getSourceEdgeEndPaint()));
            this.writeAttributePair("cy:targetArrowColor", this.paint2string(edgeView.getTargetEdgeEndPaint()));
            this.writeAttributePair("cy:edgeLabelFont", this.encodeFont(edgeView.getLabel().getFont()));
            this.writeAttributePair("cy:edgeLineType", LineStyle.extractLineStyle(edgeView.getStroke()).toString());
            if (edgeView.getLineType() == 1) {
                this.writeAttributePair("cy:curved", "CURVED_LINES");
            } else if (edgeView.getLineType() == 2) {
                this.writeAttributePair("cy:curved", "STRAIGHT_LINES");
            }
        }
        if ((handles = (bendData = edgeView.getBend()).getHandles()).size() == 0) {
            this.writer.write("/>\n");
            return;
        }
        this.writer.write(">\n");
        ++this.depth;
        this.writeElement("<att name=\"edgeBend\">\n");
        ++this.depth;
        for (Point2D handle : handles) {
            String x = Double.toString(handle.getX());
            String y = Double.toString(handle.getY());
            this.writeElement("<att name=\"handle\" x=\"" + x + "\" y=\"" + y + "\" />\n");
        }
        --this.depth;
        this.writeElement("</att>\n");
        --this.depth;
        this.writeElement("</graphics>\n");
    }

    private void writeAttribute(String id, CyAttributes attributes, String attributeName) throws IOException {
        boolean hidden;
        byte attType = attributes.getType(attributeName);
        Object value = null;
        Object type = null;
        boolean editable = attributes.getUserEditable(attributeName);
        boolean bl = hidden = !attributes.getUserVisible(attributeName);
        if (attType == 2) {
            Double dAttr = attributes.getDoubleAttribute(id, attributeName);
            this.writeAttributeXML(attributeName, ObjectType.REAL, dAttr, true, hidden, editable);
        } else if (attType == 3) {
            Integer iAttr = attributes.getIntegerAttribute(id, attributeName);
            this.writeAttributeXML(attributeName, ObjectType.INTEGER, iAttr, true, hidden, editable);
        } else if (attType == 4) {
            String sAttr = attributes.getStringAttribute(id, attributeName);
            if (sAttr != null) {
                sAttr = sAttr.replace("\n", "\\n");
                sAttr = sAttr.replace("\t", "\\t");
            }
            this.writeAttributeXML(attributeName, ObjectType.STRING, sAttr, true, hidden, editable);
        } else if (attType == 1) {
            Boolean bAttr = attributes.getBooleanAttribute(id, attributeName);
            this.writeAttributeXML(attributeName, ObjectType.BOOLEAN, bAttr, true, hidden, editable);
        } else if (attType == -2) {
            List listAttr = attributes.getListAttribute(id, attributeName);
            this.writeAttributeXML(attributeName, ObjectType.LIST, null, false, hidden, editable);
            ++this.depth;
            for (Object obj : listAttr) {
                String sAttr = obj.toString();
                if (sAttr != null) {
                    sAttr = sAttr.replace("\n", "\\n");
                    sAttr = sAttr.replace("\t", "\\t");
                }
                this.writeAttributeXML(attributeName, this.checkType(obj), sAttr, true);
            }
            --this.depth;
            this.writeAttributeXML(null, null, null, true);
        } else if (attType == -3) {
            Map mapAttr = attributes.getMapAttribute(id, attributeName);
            this.writeAttributeXML(attributeName, ObjectType.MAP, null, false, hidden, editable);
            ++this.depth;
            for (Object obj : mapAttr.keySet()) {
                String key = (String)obj;
                Object val = mapAttr.get(key);
                String sAttr = val.toString();
                if (sAttr != null) {
                    sAttr = sAttr.replace("\n", "\\n");
                    sAttr = sAttr.replace("\t", "\\t");
                }
                this.writeAttributeXML(key, this.checkType(val), sAttr, true);
            }
            --this.depth;
            this.writeAttributeXML(null, null, null, true);
        } else if (attType == -4) {
            MultiHashMap mmap = attributes.getMultiHashMap();
            MultiHashMapDefinition mmapDef = attributes.getMultiHashMapDefinition();
            byte[] dimTypes = mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (!this.objectHasKey(id, attributes, attributeName)) {
                return;
            }
            this.writeAttributeXML(attributeName, ObjectType.COMPLEX, String.valueOf(dimTypes.length), false, hidden, editable);
            Map complexAttributeStructure = this.getComplexAttributeStructure(mmap, id, attributeName, null, 0, dimTypes.length);
            ObjectType valType = this.getType(mmapDef.getAttributeValueType(attributeName));
            ++this.depth;
            this.writeComplexAttribute(complexAttributeStructure, valType, dimTypes, 0);
            --this.depth;
            this.writeAttributeXML(null, null, null, true);
        }
    }

    private Map getComplexAttributeStructure(MultiHashMap mmap, String id, String attributeName, Object[] keys, int keysIndex, int numKeyDimensions) {
        if (keysIndex == numKeyDimensions) {
            return null;
        }
        HashMap keyHashMap = new HashMap();
        Object[] newKeys = new Object[keysIndex + 1];
        for (int lc = 0; lc < keysIndex; ++lc) {
            newKeys[lc] = keys[lc];
        }
        CountedIterator keyspan = mmap.getAttributeKeyspan(id, attributeName, keys);
        while (keyspan.hasNext()) {
            Object newKey = keyspan.next();
            newKeys[keysIndex] = newKey;
            Map nextLevelMap = this.getComplexAttributeStructure(mmap, id, attributeName, newKeys, keysIndex + 1, numKeyDimensions);
            Map objectToStore = nextLevelMap == null ? mmap.getAttributeValue(id, attributeName, newKeys) : nextLevelMap;
            keyHashMap.put(newKey, objectToStore);
        }
        return keyHashMap;
    }

    private void writeComplexAttribute(Map complexAttributeStructure, ObjectType type, byte[] dimTypes, int dimTypesIndex) throws IOException {
        for (Object key : complexAttributeStructure.keySet()) {
            Object possibleAttributeValue = complexAttributeStructure.get(key);
            if (possibleAttributeValue instanceof Map) {
                this.writeAttributeXML(key.toString(), this.getType(dimTypes[dimTypesIndex]), String.valueOf(((Map)possibleAttributeValue).size()), false);
                ++this.depth;
                this.writeComplexAttribute((Map)possibleAttributeValue, type, dimTypes, dimTypesIndex + 1);
                --this.depth;
                this.writeAttributeXML(null, null, null, true);
                continue;
            }
            this.writeAttributeXML(key.toString(), this.getType(dimTypes[dimTypesIndex]), String.valueOf(1), false);
            ++this.depth;
            this.writeAttributeXML(null, type, possibleAttributeValue.toString(), true);
            --this.depth;
            this.writeAttributeXML(null, null, null, true);
        }
    }

    private void writeAttributeXML(String name, ObjectType type, Object value, boolean end) throws IOException {
        if (name == null && type == null) {
            this.writeElement("</att>\n");
        } else {
            this.writeElement("<att type=" + this.quote(type.toString()));
            if (name != null) {
                this.writer.write(" name=" + this.quote(name));
            }
            if (value != null) {
                this.writer.write(" value=" + this.quote(value.toString()));
            }
            if (end) {
                this.writer.write("/>\n");
            } else {
                this.writer.write(">\n");
            }
        }
    }

    private void writeAttributeXML(String name, ObjectType type, Object value, boolean end, boolean hidden, boolean editable) throws IOException {
        if (name == null && type == null) {
            this.writeElement("</att>\n");
        } else {
            this.writeElement("<att type=" + this.quote(type.toString()));
            if (name != null) {
                this.writer.write(" name=" + this.quote(name));
            }
            if (value != null) {
                this.writer.write(" value=" + this.quote(value.toString()));
            }
            if (hidden) {
                this.writer.write(" cy:hidden=\"true\"");
            }
            if (!editable) {
                this.writer.write(" cy:editable=\"false\"");
            }
            if (end) {
                this.writer.write("/>\n");
            } else {
                this.writer.write(">\n");
            }
        }
    }

    private void writeAttributePair(String name, Object value) throws IOException {
        this.writer.write(" " + name + "=\"" + value.toString() + "\"");
    }

    private void writeElement(String line) throws IOException {
        while (this.depth * 2 > this.indentString.length() - 1) {
            this.indentString = this.indentString + "                        ";
        }
        this.writer.write(this.indentString, 0, this.depth * 2);
        this.writer.write(line);
    }

    private GraphicsType number2shape(int type) {
        switch (type) {
            case 2: {
                return GraphicsType.ELLIPSE;
            }
            case 6: {
                return GraphicsType.RECTANGLE;
            }
            case 7: {
                return GraphicsType.ROUNDED_RECTANGLE;
            }
            case 1: {
                return GraphicsType.DIAMOND;
            }
            case 3: {
                return GraphicsType.HEXAGON;
            }
            case 4: {
                return GraphicsType.OCTAGON;
            }
            case 5: {
                return GraphicsType.PARALLELOGRAM;
            }
            case 0: {
                return GraphicsType.TRIANGLE;
            }
        }
        return null;
    }

    private String paint2string(Paint p) {
        Color c = (Color)p;
        return "#" + Integer.toHexString(256 + c.getRed()).substring(1) + Integer.toHexString(256 + c.getGreen()).substring(1) + Integer.toHexString(256 + c.getBlue()).substring(1);
    }

    private String encodeFont(Font font) {
        return font.getName() + "-" + font.getStyle() + "-" + font.getSize();
    }

    private ObjectType checkType(Object obj) {
        if (obj.getClass() == String.class) {
            return ObjectType.STRING;
        }
        if (obj.getClass() == Integer.class) {
            return ObjectType.INTEGER;
        }
        if (obj.getClass() == Double.class || obj.getClass() == Float.class) {
            return ObjectType.REAL;
        }
        if (obj.getClass() == Boolean.class) {
            return ObjectType.BOOLEAN;
        }
        return null;
    }

    private ObjectType getType(byte dimType) {
        if (dimType == 1) {
            return ObjectType.BOOLEAN;
        }
        if (dimType == 2) {
            return ObjectType.REAL;
        }
        if (dimType == 3) {
            return ObjectType.INTEGER;
        }
        if (dimType == 4) {
            return ObjectType.STRING;
        }
        return null;
    }

    private String quote(String str) {
        if (str.contains("&")) {
            str = str.replaceAll("&", "&amp;");
        }
        if (str.contains("\"")) {
            str = str.replaceAll("\"", "&quot;");
        }
        if (str.contains("'")) {
            str = str.replaceAll("'", "&apos;");
        }
        if (str.contains("<")) {
            str = str.replaceAll("<", "&lt;");
        }
        if (str.contains(">")) {
            str = str.replaceAll(">", "&gt;");
        }
        return "\"" + str + "\"";
    }

    private boolean objectHasKey(String id, CyAttributes attributes, String attributeName) {
        MultiHashMap mmap = attributes.getMultiHashMap();
        CountedIterator keysIt = mmap.getObjectKeys(attributeName);
        while (keysIt.hasNext()) {
            String thisKey = (String)keysIt.next();
            if (thisKey == null || !thisKey.equals(id)) continue;
            return true;
        }
        return false;
    }
}

