/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.writers;

import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CyAttributesWriter {
    public static String newline = System.getProperty("line.separator");
    private final CyAttributes cyAttributes;
    private final String attributeName;
    private Writer fileWriter;

    public CyAttributesWriter(CyAttributes attributes, String attributeName, Writer fileWriter) {
        this.cyAttributes = attributes;
        this.attributeName = attributeName;
        this.fileWriter = fileWriter;
    }

    public void writeAttributes() throws IOException {
        byte dataType = this.cyAttributes.getMultiHashMapDefinition().getAttributeValueType(this.attributeName);
        if (dataType == -4 || dataType == -3 || dataType == -1) {
            throw new IOException("Unsupported Datatype.");
        }
        String className = dataType == 1 ? "java.lang.Boolean" : (dataType == 3 ? "java.lang.Integer" : (dataType == 2 ? "java.lang.Double" : "java.lang.String"));
        this.fileWriter.write(this.attributeName + " (class=" + className + ")" + newline);
        MultiHashMap attributeMap = this.cyAttributes.getMultiHashMap();
        if (attributeMap != null) {
            CountedIterator keys = this.cyAttributes.getMultiHashMap().getObjectKeys(this.attributeName);
            StringBuilder result = new StringBuilder();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = this.cyAttributes.getType(this.attributeName) == -2 ? this.cyAttributes.getListAttribute(key, this.attributeName) : this.cyAttributes.getAttribute(key, this.attributeName);
                if (value == null) continue;
                if (value instanceof List) {
                    result.append(key + " = ");
                    if (((Collection)value).size() <= 0) continue;
                    Iterator objIt = ((Collection)value).iterator();
                    result.append("(" + objIt.next());
                    while (objIt.hasNext()) {
                        result.append("::" + objIt.next());
                    }
                    result.append(")" + newline);
                    this.fileWriter.write(result.toString());
                    result = new StringBuilder();
                    continue;
                }
                this.fileWriter.write(key + " = " + value + newline);
            }
            this.fileWriter.flush();
        }
        this.fileWriter.close();
        this.fileWriter = null;
    }
}

