/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers.ui;

import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.servers.ui.PreviewTableCellRenderer;
import cytoscape.logger.CyLogger;
import cytoscape.util.BioDataServerUtil;
import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import cytoscape.util.URLUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;

public class AnotationPanel
extends JPanel {
    private final String LS = System.getProperty("line.separator");
    private static final String TAXON_RESOURCE_FILE = "/cytoscape/resources/tax_report.txt";
    private static final String BIOLOGICAL_PROCESS = "P";
    private static final String MOLECULAR_FUNCTION = "F";
    private static final String CELLULAR_COMPONENT = "C";
    String[] columnNames = new String[]{"GO Symbol", "GO Term", "GO Aspect", "GO Synonym", "GO Taxon ID"};
    private File oboFile = null;
    private HashMap gaFiles = null;
    private CyAttributes nodeAttributes;
    private BioDataServerUtil bdsu;
    private HashMap taxonMap = null;
    private HashMap nodeSpeciesMap;
    private HashMap synoMap;
    private boolean isSpecies;
    private HashMap originalSpecies;
    private CyLogger logger = CyLogger.getLogger(AnotationPanel.class);
    private JScrollPane headerScrollPane;
    private JButton oboButton;
    private JButton gaButton;
    private JCheckBox flipCheckBox;
    private JComboBox speciesComboBox;
    private JEditorPane headerEditorPane;
    private JLabel jLabel1;
    private JList nodeNameList;
    private JList gaList;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel upperPanel;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JTable previewTable;
    private JTextField oboTextField;
    private JScrollPane previewScrollPane;
    private JCheckBox speciesCheckBox;
    private DefaultListModel gaListModel;
    private DefaultTableModel previewTableModel;

    public AnotationPanel() {
        this.initComponents();
        this.originalSpecies = new HashMap();
        this.nodeAttributes = Cytoscape.getNodeAttributes();
        String[] attrNames = this.nodeAttributes.getAttributeNames();
        this.isSpecies = false;
        for (int i = 0; i < attrNames.length; ++i) {
            if (!attrNames[i].equals("species")) continue;
            this.isSpecies = true;
            break;
        }
        if (this.isSpecies) {
            Iterator it = Cytoscape.getRootGraph().nodesIterator();
            while (it.hasNext()) {
                CyNode node = (CyNode)it.next();
                String nodeId = node.getIdentifier();
                this.originalSpecies.put(nodeId, this.nodeAttributes.getStringAttribute(nodeId, "species"));
            }
        }
        this.nodeSpeciesMap = new HashMap();
        this.synoMap = new HashMap();
        this.gaFiles = new HashMap();
        this.bdsu = new BioDataServerUtil();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.nodeNameList = new JList();
        this.jPanel2 = new JPanel();
        this.previewScrollPane = new JScrollPane();
        this.speciesCheckBox = new JCheckBox();
        this.speciesCheckBox.setFont(new Font("Dialog", 1, 10));
        this.speciesCheckBox.setText("Transfer GO Species Name to Nodes");
        this.speciesCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.speciesCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.speciesCheckBox.setSelected(true);
        this.speciesCheckBox.setEnabled(false);
        this.speciesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnotationPanel.this.speciesCheckBoxActionPerformed(evt);
            }
        });
        this.previewTable = new JTable(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.headerScrollPane = new JScrollPane();
        this.headerEditorPane = new JEditorPane();
        this.oboTextField = new JTextField();
        this.oboButton = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.gaList = new JList();
        this.gaListModel = new DefaultListModel();
        this.gaButton = new JButton();
        this.jPanel1 = new JPanel();
        this.flipCheckBox = new JCheckBox();
        this.flipCheckBox.setEnabled(false);
        this.speciesComboBox = new JComboBox();
        this.setPreferredSize(new Dimension(350, 300));
        this.jLabel1.setFont(new Font("Serif", 1, 14));
        this.jLabel1.setText("Select Annotation Files");
        this.jSplitPane1.setDividerLocation(130);
        this.jSplitPane1.setDividerSize(5);
        this.jScrollPane2.setBorder(BorderFactory.createTitledBorder(null, "Node IDs and Species", 0, 0, new Font("Serif", 1, 10)));
        this.gaList.setModel(this.gaListModel);
        this.gaList.setSelectionMode(0);
        this.gaList.setToolTipText("Click file name for preview (First 50 entries)");
        this.gaList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AnotationPanel.this.gaListMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.nodeNameList);
        this.jSplitPane1.setLeftComponent(this.jScrollPane2);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Preview of Gene Association File", 0, 0, new Font("Serif", 1, 10)));
        this.previewTable.getTableHeader().setReorderingAllowed(false);
        this.previewTable.setRowSelectionAllowed(false);
        this.previewTable.setColumnSelectionAllowed(false);
        this.previewTable.setCellSelectionEnabled(false);
        this.previewScrollPane.setViewportView(this.previewTable);
        this.headerScrollPane.setBorder(BorderFactory.createTitledBorder("Header Preview"));
        this.headerScrollPane.setViewportView(this.headerEditorPane);
        this.headerEditorPane.setContentType("text/html");
        this.headerEditorPane.setText("<html><body><blink><u><strong>Important Note</strong></u></blink><br>Each node ID will be tested against each GO Symbol and GO Synonym for a match. <br><br>If Transfer checkbox is unchecked, each node ID <strong><font color=\"red\">must</font></strong> have defined a Species attribute that matches the GO Taxon ID.</body></html>");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (Component)this.previewScrollPane, -1, 405, Short.MAX_VALUE).add((Component)this.headerScrollPane, -1, 405, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.headerScrollPane, -1, 74, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.previewScrollPane, -2, 137, -2)));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        this.jScrollPane3.setBorder(BorderFactory.createTitledBorder(null, "Gene Association Files", 0, 0, new Font("Serif", 1, 10)));
        this.nodeNameList.setModel(new NodeListModel(this.getNodeList()));
        this.nodeNameList.setEnabled(true);
        this.nodeNameList.setToolTipText("These node names will be used for mapping.");
        this.jScrollPane3.setViewportView(this.gaList);
        this.gaButton.setText("Add");
        this.gaButton.setActionCommand("addGa");
        this.gaButton.setMargin(new Insets(2, 2, 2, 2));
        this.flipCheckBox.setFont(new Font("Dialog", 1, 10));
        this.flipCheckBox.setText("Flip GO's Canonical Name and First Synonym");
        this.flipCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.flipCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.flipCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnotationPanel.this.flipCheckBoxActionPerformed(evt);
            }
        });
        this.upperPanel = new JPanel();
        GroupLayout upperPanelLayout = new GroupLayout((Container)this.upperPanel);
        this.upperPanel.setLayout((LayoutManager)upperPanelLayout);
        upperPanelLayout.setHorizontalGroup((GroupLayout.Group)upperPanelLayout.createParallelGroup(1).add((GroupLayout.Group)upperPanelLayout.createSequentialGroup().add((Component)this.jScrollPane3, -2, 263, -2).addPreferredGap(0).add((GroupLayout.Group)upperPanelLayout.createParallelGroup(1).add((Component)this.gaButton, -2, 56, -2).add((Component)this.speciesCheckBox))));
        upperPanelLayout.setVerticalGroup((GroupLayout.Group)upperPanelLayout.createParallelGroup(1).add((GroupLayout.Group)upperPanelLayout.createSequentialGroup().add((GroupLayout.Group)upperPanelLayout.createParallelGroup(1).add((GroupLayout.Group)upperPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.gaButton).addPreferredGap(0).add((Component)this.speciesCheckBox)).add((Component)this.jScrollPane3, -2, 67, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jSplitPane1, -1, 485, Short.MAX_VALUE).add(1, (Component)this.jSeparator1, -1, 485, Short.MAX_VALUE).add(1, (Component)this.jLabel1, -1, 485, Short.MAX_VALUE).add(1, (Component)this.upperPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.upperPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.jSplitPane1, -1, 229, Short.MAX_VALUE).addContainerGap()));
    }

    protected void gaButtonMouseClicked() {
        File gaFile = FileUtil.getFile("Import Annotation File", FileUtil.LOAD, new CyFileFilter[0]);
        if (gaFile != null) {
            this.gaFiles.put(gaFile.getName(), gaFile);
            this.gaListModel.addElement(gaFile.getName());
            this.gaList.setSelectedValue(gaFile.getName(), true);
            try {
                this.showPreview(gaFile.getName());
            }
            catch (IOException e) {
                this.logger.warn("I/O error trying to show preview for: " + gaFile.getName(), e);
            }
        }
        this.flipCheckBox.setEnabled(true);
        this.syncSpecies(true);
        this.speciesCheckBox.setEnabled(true);
    }

    protected void oboButtonMouseClicked() {
        CyFileFilter oboFilter = new CyFileFilter();
        oboFilter.addExtension("obo");
        oboFilter.setDescription("OBO files");
        this.oboFile = FileUtil.getFile("Import OBO File", FileUtil.LOAD, new CyFileFilter[]{oboFilter});
        if (this.oboFile != null) {
            this.oboTextField.setText(this.oboFile.getAbsolutePath());
            this.oboTextField.setToolTipText(this.oboFile.getAbsolutePath());
        }
    }

    private void flipCheckBoxActionPerformed(ActionEvent evt) {
        if (this.flipCheckBox.isSelected()) {
            this.previewTable.setDefaultRenderer(Object.class, new PreviewTableCellRenderer(1));
            this.previewTable.repaint();
        } else {
            this.previewTable.setDefaultRenderer(Object.class, new PreviewTableCellRenderer(0));
            this.previewTable.repaint();
        }
    }

    private void speciesCheckBoxActionPerformed(ActionEvent evt) {
        if (this.speciesCheckBox.isSelected()) {
            this.syncSpecies(true);
        } else {
            this.syncSpecies(false);
        }
    }

    private void gaListMouseClicked(MouseEvent evt) {
        try {
            this.showPreview(this.gaList.getSelectedValue().toString());
        }
        catch (FileNotFoundException e) {
            this.logger.error("The file " + this.gaList.getSelectedValue().toString() + " does not exist");
        }
        catch (IOException e) {
            this.logger.error("I/O error trying to show preview of " + this.gaList.getSelectedValue().toString(), e);
        }
    }

    private void restoreSpecies() {
        ArrayList<String> nodeNames = new ArrayList<String>();
        this.nodeAttributes.deleteAttribute("species");
        Iterator it = Cytoscape.getRootGraph().nodesIterator();
        String nodeName = null;
        String entry = null;
        CyNode node = null;
        while (it.hasNext()) {
            node = (CyNode)it.next();
            nodeName = node.getIdentifier();
            entry = !this.isSpecies ? nodeName + " = " + "No species data" : nodeName + " = " + this.originalSpecies.get(nodeName).toString();
            nodeNames.add(entry);
        }
        this.nodeNameList.setModel(new NodeListModel(nodeNames));
        this.nodeNameList.repaint();
    }

    private void syncSpecies(boolean syncFlag) {
        if (!syncFlag) {
            this.restoreSpecies();
            return;
        }
        if (this.nodeSpeciesMap == null) {
            return;
        }
        if (this.nodeSpeciesMap.size() == 0) {
            return;
        }
        ArrayList<String> nodeNames = new ArrayList<String>();
        Iterator it = Cytoscape.getRootGraph().nodesIterator();
        String nodeName = null;
        String entry = null;
        String speciesName = null;
        boolean synoFlag = false;
        CyNode node = null;
        while (it.hasNext()) {
            String alias;
            node = (CyNode)it.next();
            nodeName = node.getIdentifier();
            speciesName = (String)this.nodeSpeciesMap.get(nodeName);
            if (speciesName == null && (alias = (String)this.synoMap.get(nodeName)) != null && (speciesName = (String)this.nodeSpeciesMap.get(alias)) != null) {
                synoFlag = true;
            }
            if (speciesName == null) {
                entry = nodeName + " = " + "No species data";
            } else if (synoFlag) {
                entry = nodeName + " = " + speciesName + " (Mapped by synonym)";
                this.nodeAttributes.setAttribute(nodeName, "species", speciesName);
            } else {
                entry = nodeName + " = " + speciesName;
                this.nodeAttributes.setAttribute(nodeName, "species", speciesName);
            }
            nodeNames.add(entry);
            synoFlag = false;
        }
        this.nodeNameList.setModel(new NodeListModel(nodeNames));
        this.nodeNameList.repaint();
    }

    private HashMap buildSpeciesHash() throws IOException {
        HashMap speceisHash = new HashMap();
        Set keys = this.gaFiles.keySet();
        Iterator fileIt = keys.iterator();
        while (fileIt.hasNext()) {
            String line = null;
            File annotationFile = (File)fileIt.next();
            BufferedReader br = new BufferedReader(new FileReader(annotationFile));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("!")) continue;
            }
        }
        return speceisHash;
    }

    private void showPreview(String fileName) throws IOException {
        File previewTarget = (File)this.gaFiles.get(fileName);
        BufferedReader br = new BufferedReader(new FileReader(previewTarget));
        this.headerEditorPane.setContentType("text/plain");
        this.headerEditorPane.setText("Loading annotation file...");
        this.headerEditorPane.setText(this.getHeader(br));
        this.buildPreviewTable(br);
        br.close();
    }

    private String getHeader(BufferedReader br) throws IOException {
        String line;
        String header = "";
        while ((line = br.readLine()) != null && line.startsWith("!")) {
            header = header + line + this.LS;
        }
        return header.trim();
    }

    private void buildPreviewTable(BufferedReader br) throws IOException {
        String line;
        Vector data = new Vector();
        Vector<String> cn = new Vector<String>();
        BufferedReader spListReader = null;
        try {
            URL taxURL = this.getClass().getResource(TAXON_RESOURCE_FILE);
            spListReader = new BufferedReader(new InputStreamReader(URLUtil.getBasicInputStream(taxURL)));
            this.logger.info("Taxonomy table found in jar file...");
        }
        catch (IOException e) {
            this.logger.warn("Failed to load taxonomy table!", e);
        }
        HashMap taxonMap = this.bdsu.getTaxonMap(spListReader);
        String[] taxonID = null;
        boolean aspectErrorFlag = false;
        boolean taxonErrorFlag = false;
        while ((line = br.readLine()) != null) {
            String[] rowString = line.split("\t");
            Vector<String> row = new Vector<String>();
            String taxonName = null;
            for (int i = 0; i < rowString.length; ++i) {
                if (i == 2 && rowString[i] != null) {
                    row.add(rowString[i]);
                    continue;
                }
                if (i == 4 && rowString[i] != null) {
                    row.add(rowString[i]);
                    continue;
                }
                if (i == 8) {
                    if (rowString[i].equalsIgnoreCase(BIOLOGICAL_PROCESS)) {
                        row.add("Biological Process (P)");
                        continue;
                    }
                    if (rowString[i].equalsIgnoreCase(CELLULAR_COMPONENT)) {
                        row.add("Cellular Component (C)");
                        continue;
                    }
                    if (rowString[i].equalsIgnoreCase(MOLECULAR_FUNCTION)) {
                        row.add("Molecular Function (F)");
                        continue;
                    }
                    row.add("Error!: Invalid Aspect");
                    aspectErrorFlag = true;
                    continue;
                }
                if (i == 10 && rowString[i] != null) {
                    row.add(rowString[i]);
                    String[] syno = rowString[i].split("\\|");
                    for (int j = 0; j < syno.length; ++j) {
                        this.synoMap.put(syno[j].trim(), row.get(0));
                    }
                    continue;
                }
                if (i != 12 || rowString[i] == null) continue;
                taxonID = rowString[i].split(":");
                if (taxonID.length != 2) {
                    row.add("ERROR!: Invalid Taxon ID " + rowString[i]);
                    taxonErrorFlag = true;
                    continue;
                }
                if (taxonID.length == 2) {
                    taxonName = (String)taxonMap.get(taxonID[1]);
                    row.add(taxonName + " (" + taxonID[1] + ")");
                    continue;
                }
                row.add("ERROR!: Invalid Taxon ID " + rowString[i]);
                taxonErrorFlag = true;
            }
            this.nodeSpeciesMap.put(row.get(0), taxonName);
            data.add(row);
        }
        for (int i = 0; i < this.columnNames.length; ++i) {
            cn.add(this.columnNames[i]);
        }
        this.previewTableModel = new DefaultTableModel(data, cn);
        this.previewTable.setModel(this.previewTableModel);
        this.previewTable.setDefaultRenderer(Object.class, new PreviewTableCellRenderer(0));
        if (taxonErrorFlag || aspectErrorFlag) {
            this.gaFileErrorHandler(taxonErrorFlag, aspectErrorFlag);
        }
    }

    private void gaFileErrorHandler(boolean taxonFlag, boolean aspectFlag) {
        if (taxonFlag) {
            JOptionPane.showMessageDialog(this, "Some Taxonomy IDs are invalid.", "Warning", 1);
        }
        if (aspectFlag) {
            JOptionPane.showMessageDialog(this, "This file contains invalid GO Aspects.\n Aspects in OBO file will be used instead.", "Warning!", 1);
        }
    }

    private List getNodeList() {
        ArrayList nodes = (ArrayList)Cytoscape.getCyNodesList();
        ArrayList<String> nodeNames = new ArrayList<String>();
        Iterator it = nodes.iterator();
        String nodeName = null;
        String entry = null;
        CyNode node = null;
        while (it.hasNext()) {
            node = (CyNode)it.next();
            nodeName = node.getIdentifier();
            entry = !this.isSpecies ? nodeName + " = " + "No Species attr." : nodeName + " = " + this.nodeAttributes.getStringAttribute(nodeName, "species");
            nodeNames.add(entry);
        }
        return nodeNames;
    }

    protected void setSpeciesList(BufferedReader rd) throws IOException {
        String curLine = null;
        String name1 = null;
        curLine = rd.readLine();
        while ((curLine = rd.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(curLine, "|");
            st.nextToken();
            name1 = st.nextToken().trim();
            this.speciesComboBox.addItem(name1);
        }
    }

    public String getOverwiteComboBox() {
        return (String)this.speciesComboBox.getSelectedItem();
    }

    public boolean getFlipCheckBoxStatus() {
        return this.flipCheckBox.isSelected();
    }

    public boolean isFilesSelected() {
        return this.gaFiles.size() > 0;
    }

    public File getOBOFile() {
        return this.oboFile;
    }

    public Map getGAFiles() {
        return this.gaFiles;
    }

    public void addButtonActionListener(ActionListener l) {
        this.gaButton.addActionListener(l);
    }

    class NodeListModel
    extends AbstractListModel {
        List list;

        NodeListModel(List list) {
            this.list = list;
        }

        public int getSize() {
            return this.list.size();
        }

        public Object getElementAt(int i) {
            return this.list.get(i);
        }
    }
}

