/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.logger.CyLogger;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.mappings.DiscreteMapping;
import cytoscape.visual.mappings.ObjectMapping;
import java.awt.Color;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class VisualStyleBuilder {
    Map<VisualPropertyType, Map<Object, Object>> valueMaps;
    Map<VisualPropertyType, Map<Object, Integer>> counts;
    String name;
    private boolean nodeSizeLocked = true;
    private int nodeMax;
    private int edgeMax;
    private Color backgroundColor;

    public VisualStyleBuilder(String name) {
        this.name = name.replaceAll("\\.", "_");
        this.valueMaps = new EnumMap<VisualPropertyType, Map<Object, Object>>(VisualPropertyType.class);
        this.counts = new EnumMap<VisualPropertyType, Map<Object, Integer>>(VisualPropertyType.class);
        this.backgroundColor = null;
    }

    public VisualStyleBuilder(String newName, Map nodeGraphics, Map edgeGraphics, Map globalGraphics) {
        this(newName);
    }

    public VisualStyleBuilder(String name, boolean addOvAttr) {
        this(name);
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void buildStyle() {
        VisualMappingManager vm = Cytoscape.getVisualMappingManager();
        VisualStyle currentStyle = vm.getVisualStyle();
        NodeAppearanceCalculator nac = new NodeAppearanceCalculator(currentStyle.getNodeAppearanceCalculator());
        EdgeAppearanceCalculator eac = new EdgeAppearanceCalculator(currentStyle.getEdgeAppearanceCalculator());
        GlobalAppearanceCalculator gac = new GlobalAppearanceCalculator(currentStyle.getGlobalAppearanceCalculator());
        if (this.backgroundColor != null) {
            gac.setDefaultBackgroundColor(this.backgroundColor);
        }
        nac.setNodeSizeLocked(this.nodeSizeLocked);
        this.processCounts();
        for (VisualPropertyType type : this.valueMaps.keySet()) {
            Map<Object, Object> valMap = this.valueMaps.get((Object)type);
            if (this.createMapping(type)) {
                DiscreteMapping dm = new DiscreteMapping(type.getVisualProperty().getDefaultAppearanceObject(), this.getAttrName(type), type.isNodeProp() ? (byte)1 : 0);
                CyLogger.getLogger().info("ValueMaps size: " + this.valueMaps.get((Object)type).size());
                dm.putAll(valMap);
                BasicCalculator calc = new BasicCalculator("VisualStyleBuilder-" + this.getAttrName(type), (ObjectMapping)dm, type);
                if (type.isNodeProp()) {
                    nac.setCalculator(calc);
                    continue;
                }
                eac.setCalculator(calc);
                continue;
            }
            if (type.isNodeProp()) {
                for (Object key : valMap.keySet()) {
                    nac.getDefaultAppearance().set(type, valMap.get(key));
                }
                Cytoscape.getNodeAttributes().deleteAttribute(this.getAttrName(type));
                continue;
            }
            for (Object key : valMap.keySet()) {
                eac.getDefaultAppearance().set(type, valMap.get(key));
            }
            Cytoscape.getEdgeAttributes().deleteAttribute(this.getAttrName(type));
        }
        VisualMappingManager vizmapper = Cytoscape.getVisualMappingManager();
        CalculatorCatalog catalog = vizmapper.getCalculatorCatalog();
        String styleName = this.name + " style";
        VisualStyle graphStyle = new VisualStyle(styleName, nac, eac, gac);
        catalog.removeVisualStyle(styleName);
        catalog.addVisualStyle(graphStyle);
        vizmapper.setVisualStyle(graphStyle);
    }

    private String getAttrName(VisualPropertyType type) {
        return "vizmap:" + this.name + " " + type.toString();
    }

    public void addProperty(String id, VisualPropertyType type, String desc) {
        Object value = type.getValueParser().parseStringValue(desc);
        if (value == null) {
            return;
        }
        CyAttributes attrs = type.isNodeProp() ? Cytoscape.getNodeAttributes() : Cytoscape.getEdgeAttributes();
        attrs.setAttribute(id, this.getAttrName(type), value.toString());
        String vString = value.toString();
        if (!this.valueMaps.containsKey((Object)type)) {
            this.valueMaps.put(type, new HashMap());
        }
        this.valueMaps.get((Object)type).put(vString, value);
        if (!this.counts.containsKey((Object)type)) {
            this.counts.put(type, new HashMap());
        }
        if (!this.counts.get((Object)type).containsKey(vString)) {
            this.counts.get((Object)type).put(vString, 0);
        }
        this.counts.get((Object)type).put(vString, this.counts.get((Object)type).get(vString) + 1);
    }

    public void setNodeSizeLocked(boolean pLock) {
        this.nodeSizeLocked = pLock;
    }

    private void processCounts() {
        EnumMap<VisualPropertyType, Integer> cm = new EnumMap<VisualPropertyType, Integer>(VisualPropertyType.class);
        for (VisualPropertyType vpt : this.counts.keySet()) {
            int total = 0;
            for (Object o : this.counts.get((Object)vpt).keySet()) {
                total += this.counts.get((Object)vpt).get(o).intValue();
            }
            cm.put(vpt, total);
            CyLogger.getLogger().info((Object)((Object)vpt) + "  " + total);
        }
        this.nodeMax = 0;
        this.edgeMax = 0;
        for (VisualPropertyType vpt : this.counts.keySet()) {
            if (this.counts.get((Object)vpt).size() != 1) continue;
            for (Object o : this.counts.get((Object)vpt).keySet()) {
                if (vpt.isNodeProp()) {
                    this.nodeMax = Math.max(this.counts.get((Object)vpt).get(o), this.nodeMax);
                    continue;
                }
                this.edgeMax = Math.max(this.counts.get((Object)vpt).get(o), this.edgeMax);
            }
        }
    }

    private boolean createMapping(VisualPropertyType vpt) {
        if (this.counts.get((Object)vpt).size() > 1) {
            return true;
        }
        Iterator<Object> i$ = this.counts.get((Object)vpt).keySet().iterator();
        if (i$.hasNext()) {
            Object o = i$.next();
            int ct = this.counts.get((Object)vpt).get(o);
            if (vpt.isNodeProp()) {
                return ct < this.nodeMax;
            }
            return ct < this.edgeMax;
        }
        return false;
    }
}

