/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.logger.CyLogger;
import cytoscape.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class TextJarReader {
    String filename;
    InputStreamReader reader;
    StringBuffer sb;

    public TextJarReader(String urlString) throws IOException {
        if (!urlString.startsWith("jar")) {
            throw new IOException("Ok, so this isn't an IOException, but it's still a problem: " + urlString + "  This class only accepts JAR urls!!! " + "  See java.net.JarURLConnection for syntax");
        }
        this.sb = new StringBuffer();
        InputStream is = null;
        if (urlString.matches("jar\\:\\/\\/.+")) {
            this.filename = urlString.substring(5);
            is = this.getClass().getResourceAsStream(this.filename);
        } else {
            this.filename = urlString;
            URL url = new URL(urlString);
            is = URLUtil.getBasicInputStream(url);
        }
        this.reader = new InputStreamReader(is);
    }

    public int read() throws IOException {
        int bytesRead;
        CyLogger.getLogger().info("-- reading " + this.filename);
        char[] cBuffer = new char[1024];
        while ((bytesRead = this.reader.read(cBuffer, 0, 1024)) != -1) {
            this.sb.append(new String(cBuffer, 0, bytesRead));
        }
        return this.sb.length();
    }

    public String getText() {
        return this.sb.toString();
    }
}

