/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.data.ontology.Ontology;
import cytoscape.data.readers.XGMMLReader;
import cytoscape.generated.Child;
import cytoscape.generated.Cysession;
import cytoscape.generated.Edge;
import cytoscape.generated.HiddenEdges;
import cytoscape.generated.HiddenNodes;
import cytoscape.generated.Network;
import cytoscape.generated.NetworkFrame;
import cytoscape.generated.Node;
import cytoscape.generated.SelectedEdges;
import cytoscape.generated.SelectedNodes;
import cytoscape.logger.CyLogger;
import cytoscape.task.TaskMonitor;
import cytoscape.util.PercentUtil;
import cytoscape.util.URLUtil;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.DuplicateCalculatorNameException;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JInternalFrame;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class CytoscapeSessionReader {
    public static final String PACKAGE_NAME = "cytoscape.generated";
    public static final String BOOKMARK_PACKAGE_NAME = "cytoscape.bookmarks";
    public static final String CYSESSION = "cysession.xml";
    public static final String VIZMAP_PROPS = "vizmap.props";
    public static final String CY_PROPS = "cytoscape.props";
    public static final String XGMML_EXT = ".xgmml";
    private static final String BOOKMARKS_FILE = "session_bookmarks.xml";
    private static final String NETWORK_ROOT = "Network Root";
    private URL sourceURL;
    private HashMap networkURLs = null;
    private URL cysessionFileURL = null;
    private URL vizmapFileURL = null;
    private URL cytoscapePropsURL = null;
    private URL bookmarksFileURL = null;
    private HashMap<String, Network> netMap;
    private String sessionID;
    private Cysession session;
    private List networkList;
    private Bookmarks bookmarks = null;
    private HashMap<String, List<File>> pluginFileListMap;
    private HashMap<String, List<String>> theURLstrMap = new HashMap();
    private TaskMonitor taskMonitor = null;
    private PercentUtil percentUtil;
    private float networkCounter = 0.0f;
    private float netIndex = 0.0f;
    private long start;
    private String lastVSName = null;
    private CyLogger logger = null;

    public CytoscapeSessionReader(URL sourceName, TaskMonitor monitor) throws IOException {
        this.sourceURL = sourceName;
        this.sourceURL = sourceName.getProtocol().equals("file") ? sourceName : this.temporaryLocalFileURL(sourceName);
        this.networkList = new ArrayList();
        this.bookmarks = new Bookmarks();
        this.pluginFileListMap = new HashMap();
        this.taskMonitor = monitor;
        if (monitor != null) {
            this.percentUtil = new PercentUtil(1);
        }
        this.logger = CyLogger.getLogger(CytoscapeSessionReader.class);
    }

    public CytoscapeSessionReader(String fileName, TaskMonitor monitor) throws IOException {
        this(new File(fileName).toURL(), monitor);
    }

    public CytoscapeSessionReader(String fileName) throws IOException {
        this(new File(fileName).toURL(), (TaskMonitor)null);
    }

    public CytoscapeSessionReader(URL sourceName) throws IOException {
        this(sourceName, (TaskMonitor)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractEntry() throws IOException {
        URLConnection juc = this.sourceURL.openConnection();
        juc.setDefaultUseCaches(false);
        ZipInputStream zis = new ZipInputStream(juc.getInputStream());
        this.networkURLs = new HashMap();
        ZipEntry zen = null;
        String entryName = null;
        while ((zen = zis.getNextEntry()) != null) {
            entryName = zen.getName();
            if (entryName.contains("/plugins/")) {
                this.extractPluginEntry(entryName);
                continue;
            }
            if (entryName.endsWith(CYSESSION)) {
                this.cysessionFileURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                continue;
            }
            if (entryName.endsWith(VIZMAP_PROPS)) {
                this.vizmapFileURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                continue;
            }
            if (entryName.endsWith(CY_PROPS)) {
                this.cytoscapePropsURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                continue;
            }
            if (entryName.endsWith(XGMML_EXT)) {
                URL networkURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                this.networkURLs.put(entryName, networkURL);
                this.networkCounter += 1.0f;
                continue;
            }
            if (entryName.endsWith(BOOKMARKS_FILE)) {
                this.bookmarksFileURL = new URL("jar:" + this.sourceURL.toString() + "!/" + entryName);
                continue;
            }
            this.logger.warn("Unknown entry found in session zip file: " + entryName);
        }
        if (zis != null) {
            try {
                zis.close();
            }
            finally {
                zis = null;
            }
        }
    }

    private void extractPluginEntry(String entryName) {
        String[] items = entryName.split("/");
        if (items.length < 3) {
            return;
        }
        String pluginName = items[2];
        String URLstr = "jar:" + this.sourceURL.toString() + "!/" + entryName;
        if (this.theURLstrMap.containsKey(pluginName)) {
            List<String> theURLstrList = this.theURLstrMap.get(pluginName);
            theURLstrList.add(URLstr);
        } else {
            ArrayList<String> theURLstrList = new ArrayList<String>();
            theURLstrList.add(URLstr);
            this.theURLstrMap.put(pluginName, theURLstrList);
        }
    }

    public void read() throws IOException, JAXBException, Exception {
        this.start = System.currentTimeMillis();
        Cytoscape.firePropertyChange(Integer.toString(Cytoscape.SESSION_OPENED), null, true);
        if (Cytoscape.getDesktop() != null) {
            Cytoscape.getDesktop().getVizMapperUI().initializeTableState();
        }
        try {
            this.unzipSessionFromURL();
        }
        catch (DuplicateCalculatorNameException dcne) {
            this.logger.warn("Duplicate VS name found.  It will be ignored...", dcne);
        }
        if (this.session.getSessionState().getDesktop() != null) {
            this.restoreDesktopState();
        }
        if (this.session.getSessionState().getServer() != null) {
            this.restoreOntologyServerStatus();
        }
        Cytoscape.firePropertyChange(Cytoscape.ATTRIBUTES_CHANGED, null, null);
        Cytoscape.firePropertyChange("NETWORK_LOADED", null, null);
        Cytoscape.firePropertyChange("RESTORE_PLUGIN_STATE", this.pluginFileListMap, null);
        this.deleteTmpPluginFiles();
        Cytoscape.firePropertyChange(Cytoscape.SESSION_LOADED, null, this.networkList);
        if (Cytoscape.getDesktop() != null) {
            CyNetworkView curView = Cytoscape.getCurrentNetworkView();
            if (curView != null && !curView.equals(Cytoscape.getNullNetworkView())) {
                curView.setVisualStyle(this.lastVSName);
                Cytoscape.getVisualMappingManager().setNetworkView(curView);
                Cytoscape.getVisualMappingManager().setVisualStyle(curView.getVisualStyle());
                curView.redrawGraph(false, true);
            }
            Cytoscape.getDesktop().getVizMapperUI().enableListeners(true);
        }
        this.logger.info("Session loaded in " + (System.currentTimeMillis() - this.start) + " msec.");
    }

    private void deleteTmpPluginFiles() {
        if (this.pluginFileListMap == null || this.pluginFileListMap.size() == 0) {
            return;
        }
        Set<String> pluginSet = this.pluginFileListMap.keySet();
        for (String plugin : pluginSet) {
            List<File> theFileList = this.pluginFileListMap.get(plugin);
            for (File theFile : theFileList) {
                if (theFile == null) continue;
                theFile.delete();
            }
        }
    }

    private void unzipSessionFromURL() throws IOException, JAXBException, Exception {
        this.extractEntry();
        this.logger.info("extractEntry: " + (System.currentTimeMillis() - this.start) + " msec.");
        if (this.cysessionFileURL == null || this.vizmapFileURL == null || this.cytoscapePropsURL == null) {
            IOException e = new IOException("Session file is broken or this is not a session file.");
            throw e;
        }
        Cytoscape.firePropertyChange(Cytoscape.VIZMAP_RESTORED, null, this.vizmapFileURL);
        if (this.bookmarksFileURL != null) {
            this.bookmarks = this.getBookmarksFromZip(this.bookmarksFileURL);
            Cytoscape.setBookmarks(this.bookmarks);
        }
        CytoscapeInit.getProperties().load(URLUtil.getBasicInputStream(this.cytoscapePropsURL));
        this.loadCySession();
        this.logger.info("loadCySession: " + (System.currentTimeMillis() - this.start) + " msec.");
        this.restorePlugnStateFilesFromZip();
    }

    private void restorePlugnStateFilesFromZip() {
        if (this.theURLstrMap == null || this.theURLstrMap.size() == 0) {
            return;
        }
        Set<String> pluginSet = this.theURLstrMap.keySet();
        for (String pluginName : pluginSet) {
            List<String> URLstrList = this.theURLstrMap.get(pluginName);
            if (URLstrList == null || URLstrList.size() == 0) continue;
            File theFile = null;
            for (String URLstr : URLstrList) {
                List<Object> fileList;
                int index = URLstr.lastIndexOf("/");
                String fileName = System.getProperty("java.io.tmpdir") + File.separator + pluginName + "_" + URLstr.substring(index + 1);
                theFile = new File(fileName);
                try {
                    String inputLine;
                    URL theURL = new URL(URLstr);
                    InputStream is = URLUtil.getBasicInputStream(theURL);
                    BufferedWriter out = null;
                    BufferedReader in = null;
                    in = new BufferedReader(new InputStreamReader(is));
                    out = new BufferedWriter(new FileWriter(theFile));
                    while ((inputLine = in.readLine()) != null) {
                        out.write(inputLine);
                        out.newLine();
                    }
                    in.close();
                    out.close();
                }
                catch (IOException e) {
                    theFile = null;
                    this.logger.error("Error: reading from zip: " + URLstr, e);
                }
                if (theFile == null) continue;
                if (!this.pluginFileListMap.containsKey(pluginName)) {
                    fileList = new ArrayList<File>();
                    fileList.add(theFile);
                    this.pluginFileListMap.put(pluginName, fileList);
                    continue;
                }
                fileList = this.pluginFileListMap.get(pluginName);
                fileList.add(theFile);
            }
        }
    }

    private Bookmarks getBookmarksFromZip(URL pBookmarksFileURL) {
        Bookmarks theBookmark = null;
        try {
            InputStream is = URLUtil.getBasicInputStream(pBookmarksFileURL);
            JAXBContext jaxbContext = JAXBContext.newInstance((String)BOOKMARK_PACKAGE_NAME, (ClassLoader)this.getClass().getClassLoader());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            theBookmark = (Bookmarks)unmarshaller.unmarshal(is);
            if (is != null) {
                is.close();
            }
        }
        catch (FileNotFoundException e1) {
            this.logger.warn("Can not find bookmark file in " + pBookmarksFileURL.toString(), e1);
        }
        catch (IOException e2) {
            this.logger.warn("Can not read bookmark file from " + pBookmarksFileURL.toString(), e2);
        }
        catch (JAXBException e3) {
            this.logger.warn("XML parse err in bookmark file in " + pBookmarksFileURL.toString(), e3);
        }
        return theBookmark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCySession() throws JAXBException, IOException, Exception {
        InputStream is = URLUtil.getBasicInputStream(this.cysessionFileURL);
        JAXBContext jaxbContext = JAXBContext.newInstance((String)PACKAGE_NAME, (ClassLoader)this.getClass().getClassLoader());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        this.session = (Cysession)unmarshaller.unmarshal(is);
        if (is != null) {
            try {
                is.close();
            }
            finally {
                is = null;
            }
        }
        this.sessionID = this.session.getId();
        this.netMap = new HashMap();
        for (Network curNet : this.session.getNetworkTree().getNetwork()) {
            this.netMap.put(curNet.getId(), curNet);
        }
        this.walkTree(this.netMap.get(NETWORK_ROOT), null, this.cysessionFileURL);
    }

    private void restoreDesktopState() {
        Cytoscape.getDesktop().setSize(this.session.getSessionState().getDesktop().getDesktopSize().getWidth().intValue(), this.session.getSessionState().getDesktop().getDesktopSize().getHeight().intValue());
        List<NetworkFrame> frames = this.session.getSessionState().getDesktop().getNetworkFrames().getNetworkFrame();
        HashMap<String, NetworkFrame> frameMap = new HashMap<String, NetworkFrame>();
        for (NetworkFrame netFrame : frames) {
            frameMap.put(netFrame.getFrameID(), netFrame);
        }
        Component[] desktopFrames = Cytoscape.getDesktop().getNetworkViewManager().getDesktopPane().getComponents();
        for (int i = 0; i < desktopFrames.length; ++i) {
            JInternalFrame frame = (JInternalFrame)desktopFrames[i];
            NetworkFrame nFrame = (NetworkFrame)frameMap.get(frame.getTitle());
            if (nFrame == null) continue;
            frame.setSize(nFrame.getWidth().intValue(), nFrame.getHeight().intValue());
            frame.setLocation(nFrame.getX().intValue(), nFrame.getY().intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void walkTree(Network currentNetwork, CyNetwork parent, Object sessionSource) throws JAXBException, IOException {
        List<Child> children = currentNetwork.getChild();
        int numChildren = children.size();
        CyNetwork new_network = null;
        for (int i = 0; i < numChildren; ++i) {
            Child child = children.get(i);
            Network childNet = this.netMap.get(child.getId());
            String targetNwUrlName = this.sessionID + "/" + childNet.getFilename();
            URL targetNetworkURL = (URL)this.networkURLs.get(targetNwUrlName);
            if (targetNetworkURL == null) {
                this.logger.error("Session file corrupt: Filename " + childNet.getFilename() + " does not correspond to a network of that name in session file");
                continue;
            }
            JarURLConnection jarConnection = (JarURLConnection)targetNetworkURL.openConnection();
            InputStream networkStream = (InputStream)jarConnection.getContent();
            Properties prop = CytoscapeInit.getProperties();
            String vsbSwitch = prop.getProperty("visualStyleBuilder");
            prop.setProperty("visualStyleBuilder", "off");
            XGMMLReader reader = new XGMMLReader(networkStream);
            try {
                new_network = Cytoscape.createNetwork(reader, false, parent);
            }
            catch (Exception e) {
                String message = "Unable to read XGMML file: " + childNet.getFilename() + ".  " + e.getMessage();
                this.logger.error(message, e);
                Cytoscape.destroyNetwork(new_network);
                if (this.taskMonitor != null) {
                    this.taskMonitor.setException((Throwable)e, message);
                }
                if (childNet.getChild().size() == 0) continue;
                this.walkTree(childNet, new_network, sessionSource);
                continue;
            }
            this.logger.info("XGMMLReader " + new_network.getIdentifier() + ": " + (System.currentTimeMillis() - this.start) + " msec.");
            if (vsbSwitch != null) {
                prop.setProperty("visualStyleBuilder", vsbSwitch);
            } else {
                prop.remove("visualStyleBuilder");
            }
            if (this.taskMonitor != null && this.networkCounter >= 20.0f) {
                this.netIndex += 1.0f;
                this.taskMonitor.setPercentCompleted(((Number)Float.valueOf(this.netIndex / this.networkCounter * 100.0f)).intValue());
            }
            if (networkStream != null) {
                try {
                    networkStream.close();
                }
                finally {
                    networkStream = null;
                }
            }
            this.networkList.add(new_network.getIdentifier());
            if (childNet.isViewAvailable().booleanValue()) {
                String vsName = childNet.getVisualStyle();
                if (vsName == null) {
                    vsName = "default";
                }
                this.lastVSName = vsName;
                CyNetworkView curNetView = Cytoscape.createNetworkView(new_network, new_network.getTitle(), reader.getLayoutAlgorithm());
                curNetView.setVisualStyle(vsName);
                Cytoscape.getVisualMappingManager().setNetworkView(curNetView);
                Cytoscape.getVisualMappingManager().setVisualStyle(vsName);
                reader.doPostProcessing(new_network);
                this.setHiddenNodes(curNetView, childNet.getHiddenNodes());
                this.setHiddenEdges(curNetView, childNet.getHiddenEdges());
            }
            this.setSelectedNodes(new_network, childNet.getSelectedNodes());
            this.setSelectedEdges(new_network, childNet.getSelectedEdges());
            if (childNet.getChild().size() == 0) continue;
            this.walkTree(childNet, new_network, sessionSource);
        }
    }

    private void setSelectedNodes(CyNetwork network, SelectedNodes selected) {
        if (selected == null) {
            return;
        }
        ArrayList<CyNode> selectedNodeList = new ArrayList<CyNode>();
        for (Node selectedNode : selected.getNode()) {
            selectedNodeList.add(Cytoscape.getCyNode(selectedNode.getId(), false));
        }
        network.setSelectedNodeState(selectedNodeList, true);
    }

    private void setHiddenNodes(CyNetworkView view, HiddenNodes hidden) {
        if (hidden == null) {
            return;
        }
        for (Node hiddenNodeObject : hidden.getNode()) {
            CyNode hiddenNode = Cytoscape.getCyNode(hiddenNodeObject.getId(), false);
            view.hideGraphObject(view.getNodeView(hiddenNode));
        }
    }

    private void setHiddenEdges(CyNetworkView view, HiddenEdges hidden) {
        if (hidden == null) {
            return;
        }
        for (Edge hiddenEdgeObject : hidden.getEdge()) {
            CyEdge hiddenEdge = this.getCyEdge(hiddenEdgeObject);
            if (hiddenEdge == null) continue;
            view.hideGraphObject(view.getEdgeView(hiddenEdge));
        }
    }

    private void setSelectedEdges(CyNetwork network, SelectedEdges selected) {
        if (selected == null) {
            return;
        }
        CyEdge targetEdge = null;
        ArrayList<CyEdge> selectedEdgeList = new ArrayList<CyEdge>();
        for (Edge selectedEdge : selected.getEdge()) {
            targetEdge = this.getCyEdge(selectedEdge);
            if (targetEdge == null) continue;
            selectedEdgeList.add(targetEdge);
        }
        network.setSelectedEdgeState(selectedEdgeList, true);
    }

    private CyEdge getCyEdge(Edge edge) {
        String[] parts;
        CyEdge targetEdge = null;
        String sourceString = edge.getSource();
        String targetString = edge.getTarget();
        CyNode source = null;
        CyNode target = null;
        String interaction = edge.getInteraction();
        if (sourceString != null && targetString != null) {
            source = Cytoscape.getCyNode(sourceString);
            target = Cytoscape.getCyNode(targetString);
        }
        if (source != null & target != null && interaction != null) {
            targetEdge = Cytoscape.getCyEdge(source, target, "interaction", interaction, false, true);
        }
        if (targetEdge == null && (parts = edge.getId().split(" ")).length == 3) {
            source = Cytoscape.getCyNode(parts[0], false);
            target = Cytoscape.getCyNode(parts[2], false);
            interaction = parts[1].substring(1, parts[1].length() - 1);
            if (source != null && target != null && interaction != null) {
                targetEdge = Cytoscape.getCyEdge(source, target, "interaction", interaction, false, true);
            }
        }
        return targetEdge;
    }

    public String getCysessionNote() {
        return this.session.getSessionNote();
    }

    private void restoreOntologyServerStatus() throws MalformedURLException {
        HashMap<String, URL> newMap = new HashMap<String, URL>();
        List<cytoscape.generated.Ontology> servers = this.session.getSessionState().getServer().getOntologyServer().getOntology();
        String targetCyNetworkID = null;
        String curator = null;
        String description = null;
        for (cytoscape.generated.Ontology server : servers) {
            newMap.put(server.getName(), new URL(server.getHref()));
            targetCyNetworkID = this.getNetworkIdFromTitle(server.getName());
            Ontology onto = new Ontology(server.getName(), curator, description, Cytoscape.getNetwork(targetCyNetworkID));
            Cytoscape.getOntologyServer().addOntology(onto);
        }
        Cytoscape.getOntologyServer().setOntologySources(newMap);
    }

    private String getNetworkIdFromTitle(String title) {
        Set<CyNetwork> networks = Cytoscape.getNetworkSet();
        for (CyNetwork net : networks) {
            if (!net.getTitle().equals(title)) continue;
            return net.getIdentifier();
        }
        return null;
    }

    private URL temporaryLocalFileURL(URL remoteURL) {
        try {
            File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".cys");
            tempFile.deleteOnExit();
            byte[] buffer = new byte[100000];
            FileOutputStream localContent = new FileOutputStream(tempFile);
            InputStream remoteContent = URLUtil.getBasicInputStream(remoteURL);
            int nBytes = remoteContent.read(buffer);
            while (nBytes > 0) {
                ((OutputStream)localContent).write(buffer, 0, nBytes);
                nBytes = remoteContent.read(buffer);
            }
            remoteContent.close();
            ((OutputStream)localContent).close();
            remoteContent = null;
            localContent = null;
            buffer = null;
            return tempFile.toURL();
        }
        catch (FileNotFoundException e) {
            this.logger.error("Can't create a temporary file.", e);
        }
        catch (MalformedURLException e) {
            this.logger.error("Bad URL provided: " + remoteURL.toString(), e);
        }
        catch (IOException e) {
            this.logger.error("I/O error while cacheing URL data", e);
        }
        return remoteURL;
    }
}

