/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.Cytoscape;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.util.URLUtil;
import java.io.IOException;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class BookmarkReader {
    private static final String BOOKMARK_PACKAGE = "cytoscape.bookmarks";
    private static final String BOOKMARK_RESOURCE_FILE = "/cytoscape/resources/bookmarks.xml";
    private Bookmarks bookmarks;

    public void readBookmarks() throws JAXBException, IOException {
        URL bookmarkSource = this.getClass().getResource(BOOKMARK_RESOURCE_FILE);
        this.readBookmarks(bookmarkSource);
    }

    public void readBookmarks(URL bookmarkUrl) throws JAXBException, IOException {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)BOOKMARK_PACKAGE, (ClassLoader)Cytoscape.class.getClassLoader());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        this.bookmarks = (Bookmarks)unmarshaller.unmarshal(URLUtil.getBasicInputStream(bookmarkUrl));
    }

    public Bookmarks getBookmarks() {
        return this.bookmarks;
    }
}

