/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.CyNetwork;
import cytoscape.data.readers.GraphReader;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.CyLayouts;
import cytoscape.task.TaskMonitor;
import cytoscape.util.CyNetworkNaming;
import cytoscape.view.CyNetworkView;
import giny.view.GraphView;
import java.io.File;
import java.io.IOException;

public abstract class AbstractGraphReader
implements GraphReader {
    protected String fileName;

    public AbstractGraphReader(String fileName) {
        this.fileName = fileName;
    }

    public abstract void read() throws IOException;

    public int[] getNodeIndicesArray() {
        return null;
    }

    public int[] getEdgeIndicesArray() {
        return null;
    }

    public String getNetworkName() {
        String t = "";
        if (this.fileName != null) {
            File tempFile = new File(this.fileName);
            t = tempFile.getName();
        }
        return CyNetworkNaming.getSuggestedNetworkTitle(t);
    }

    public void doPostProcessing(CyNetwork network) {
    }

    public CyLayoutAlgorithm getLayoutAlgorithm() {
        return CyLayouts.getDefaultLayout();
    }

    public void setTaskMonitor(TaskMonitor monitor) {
    }

    public void layout(GraphView view) {
        this.getLayoutAlgorithm().doLayout((CyNetworkView)view);
    }
}

