/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNetworkAdapter;
import cytoscape.CyNetworkEvent;
import cytoscape.CyNetworkTitleChange;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyNetworkTest
extends TestCase {
    private String title = "My Network";
    private CyNetwork network;
    private int defaultNodeSetSize = 10;

    protected void setUp() throws Exception {
        super.setUp();
        Collection<CyNode> nodes = this.getNodes(this.defaultNodeSetSize);
        Collection<CyEdge> edges = this.getEdges(nodes);
        this.network = Cytoscape.createNetwork(nodes, edges, this.title);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Cytoscape.destroyNetwork(this.network);
    }

    public void testCreateNetwork() {
        CyNetworkTest.assertNotNull((Object)this.network);
        CyNetworkTest.assertEquals((int)this.network.getNodeCount(), (int)this.defaultNodeSetSize);
        CyNetworkTest.assertEquals((int)this.network.getEdgeCount(), (int)(this.defaultNodeSetSize - 1));
        System.err.println("Should be creating the network the way it's done in Fing!");
    }

    public void testGetTitle() {
        CyNetworkTest.assertEquals((String)this.network.getTitle(), (String)this.title);
    }

    public void testSetTitle() {
        this.network.setTitle("foobar");
        CyNetworkTest.assertEquals((String)this.network.getTitle(), (String)"foobar");
    }

    public void testGetIdentifier() {
        CyNetworkTest.assertNotNull((Object)this.network.getIdentifier());
    }

    public void testSetIdentifier() {
        String id = "12345";
        this.network.setIdentifier(id);
        CyNetworkTest.assertEquals((String)this.network.getIdentifier(), (String)id);
    }

    public void testAppendNetwork() {
        ArrayList<CyNode> nodes = new ArrayList<CyNode>();
        nodes.add(Cytoscape.getCyNode("foobar", true));
        nodes.add(Cytoscape.getCyNode("blat", true));
        nodes.add(Cytoscape.getCyNode("some name", true));
        Collection<CyEdge> edges = this.getEdges(nodes);
        CyNetwork appNet = Cytoscape.createNetwork(nodes, edges, "My network");
        CyNetworkTest.assertNotNull((Object)appNet);
        CyNetworkTest.assertNotSame((Object)appNet, (Object)this.network);
        this.network.appendNetwork(appNet);
        CyNetworkTest.assertEquals((int)this.network.getNodeCount(), (int)(this.defaultNodeSetSize + 3));
        CyNetworkTest.assertEquals((int)this.network.getEdgeCount(), (int)(this.defaultNodeSetSize + 1));
    }

    public void testSelectAllNodes() {
        this.network.selectAllNodes();
        CyNetworkTest.assertNotNull((Object)this.network.getSelectedNodes());
        CyNetworkTest.assertEquals((int)this.network.getSelectedNodes().size(), (int)this.network.getNodeCount());
    }

    public void testSelectAllEdges() {
        this.network.selectAllEdges();
        CyNetworkTest.assertNotNull((Object)this.network.getSelectedEdges());
        CyNetworkTest.assertEquals((int)this.network.getSelectedEdges().size(), (int)this.network.getEdgeCount());
    }

    public void testUnselectAllNodes() {
        this.network.selectAllNodes();
        CyNetworkTest.assertNotNull((Object)this.network.getSelectedNodes());
        CyNetworkTest.assertEquals((int)this.network.getSelectedNodes().size(), (int)this.network.getNodeCount());
        this.network.unselectAllNodes();
        CyNetworkTest.assertEquals((int)this.network.getSelectedNodes().size(), (int)0);
    }

    public void testUnselectAllEdges() {
        this.network.selectAllEdges();
        CyNetworkTest.assertNotNull((Object)this.network.getSelectedEdges());
        CyNetworkTest.assertEquals((int)this.network.getSelectedEdges().size(), (int)this.network.getEdgeCount());
        this.network.unselectAllEdges();
        CyNetworkTest.assertEquals((int)this.network.getSelectedEdges().size(), (int)0);
    }

    public void testSetSelectedNodeStateCollectionBoolean() {
        this.network.setSelectedNodeState(this.getNodes(3), true);
        CyNetworkTest.assertEquals((int)this.network.getSelectedNodes().size(), (int)3);
    }

    public void testSetSelectedNodeStateNodeBoolean() {
        this.network.setSelectedNodeState(Cytoscape.getCyNode("1"), true);
        CyNetworkTest.assertEquals((int)this.network.getSelectedNodes().size(), (int)1);
    }

    public void testSetSelectedEdgeStateCollectionBoolean() {
        this.network.unselectAllNodes();
        this.network.unselectAllEdges();
        this.network.setSelectedNodeState(this.getNodes(3), true);
        Set selectedNodes = this.network.getSelectedNodes();
        for (CyNode node : selectedNodes) {
            CyNetworkTest.assertTrue((boolean)this.network.containsNode(node));
        }
        Collection<CyEdge> edges = this.getEdges(selectedNodes);
        CyNetworkTest.assertEquals((int)2, (int)edges.size());
        this.network.setSelectedEdgeState(edges, true);
    }

    public void testSetSelectedEdgeStateEdgeBoolean() {
        this.network.setSelectedNodeState(this.getNodes(2), true);
        Set selectedNodes = this.network.getSelectedNodes();
        CyNetworkTest.assertEquals((int)this.getEdges(selectedNodes).size(), (int)1);
        for (CyEdge edge : this.getEdges(selectedNodes)) {
            this.network.setSelectedEdgeState(edge, true);
        }
        CyNetworkTest.assertEquals((int)this.network.getSelectedEdges().size(), (int)1);
    }

    public void testIsSelectedNode() {
        CyNode node = Cytoscape.getCyNode("1");
        this.network.setSelectedNodeState(node, true);
        CyNetworkTest.assertTrue((boolean)this.network.isSelected(node));
    }

    public void testIsSelectedEdge() {
        CyNode node_1 = Cytoscape.getCyNode("1");
        CyNode node_2 = Cytoscape.getCyNode("2");
        CyEdge edge = Cytoscape.getCyEdge(node_1, node_2, "interaction", "test", false);
        CyNetworkTest.assertNotNull((Object)edge);
        this.network.setSelectedEdgeState(edge, true);
        CyNetworkTest.assertTrue((boolean)this.network.isSelected(edge));
    }

    public void testGetSelectedNodes() {
        this.network.selectAllNodes();
        CyNetworkTest.assertNotNull((Object)this.network.getSelectedNodes());
        CyNetworkTest.assertEquals((int)this.network.getSelectedNodes().size(), (int)this.defaultNodeSetSize);
    }

    public void testGetSelectedEdges() {
        this.network.selectAllEdges();
        CyNetworkTest.assertNotNull((Object)this.network.getSelectedEdges());
        CyNetworkTest.assertEquals((int)this.network.getSelectedEdges().size(), (int)(this.defaultNodeSetSize - 1));
    }

    public void testCyNetworkListener() {
        CyNetworkAdapter listener = new CyNetworkAdapter(){

            public void onCyNetworkEvent(CyNetworkEvent event) {
            }
        };
        this.network.addCyNetworkListener(listener);
        CyNetworkTest.assertEquals((int)this.network.getCyNetworkListeners().size(), (int)1);
        CyNetworkTest.assertTrue((boolean)this.network.removeCyNetworkListener(listener));
    }

    public void testAddNodeInt() {
        CyNode newNode = Cytoscape.getCyNode("123", true);
        CyNetworkTest.assertNotNull((Object)this.network.addNode(newNode.getRootGraphIndex()));
        CyNetworkTest.assertTrue((boolean)this.network.containsNode(newNode));
    }

    public void testAddNodeNode() {
        CyNode newNode = Cytoscape.getCyNode("321", true);
        CyNetworkTest.assertNotNull((Object)this.network.addNode(newNode));
        CyNetworkTest.assertTrue((boolean)this.network.containsNode(newNode));
    }

    public void testRemoveNode() {
        CyNode node = Cytoscape.getCyNode("1");
        CyNetworkTest.assertNotNull((Object)node);
        CyNetworkTest.assertTrue((boolean)this.network.removeNode(node.getRootGraphIndex(), true));
    }

    public void testAddEdgeInt() {
        CyEdge edge = Cytoscape.getCyEdge(Cytoscape.getCyNode("1"), Cytoscape.getCyNode("4"), "interaction", "test", true);
        CyNetworkTest.assertNotNull((Object)edge);
        CyNetworkTest.assertNotNull((Object)this.network.addEdge(edge.getRootGraphIndex()));
    }

    public void testAddEdgeEdge() {
        CyEdge edge = Cytoscape.getCyEdge(Cytoscape.getCyNode("1"), Cytoscape.getCyNode("4"), "interaction", "test", true);
        CyNetworkTest.assertNotNull((Object)edge);
        CyNetworkTest.assertNotNull((Object)this.network.addEdge(edge));
    }

    public void testRemoveEdge() {
        CyEdge edge = Cytoscape.getCyEdge(Cytoscape.getCyNode("1"), Cytoscape.getCyNode("2"), "interaction", "test", true);
        CyNetworkTest.assertNotNull((Object)edge);
        CyNetworkTest.assertTrue((boolean)this.network.removeEdge(edge.getRootGraphIndex(), true));
    }

    public void testSetTitleEvent() {
        String InitialTitle = "My Network";
        String NewTitle = "Foobar";
        CyNetwork network = Cytoscape.createNetwork(InitialTitle);
        TitleListener tl = new TitleListener();
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(tl);
        network.setTitle(NewTitle);
        PropertyChangeEvent event = tl.getEvent();
        CyNetworkTest.assertEquals((String)event.getPropertyName(), (String)"NETWORK_TITLE_MODIFIED");
        CyNetworkTest.assertEquals((String)((CyNetworkTitleChange)event.getOldValue()).getNetworkIdentifier(), (String)((CyNetworkTitleChange)event.getNewValue()).getNetworkIdentifier());
        CyNetworkTest.assertEquals((String)((CyNetworkTitleChange)event.getOldValue()).getNetworkTitle(), (String)InitialTitle);
        CyNetworkTest.assertEquals((String)((CyNetworkTitleChange)event.getNewValue()).getNetworkTitle(), (String)NewTitle);
    }

    private Collection<CyNode> getNodes(int size) {
        ArrayList<CyNode> Nodes = new ArrayList<CyNode>();
        for (int i = 0; i < size; ++i) {
            Nodes.add(Cytoscape.getCyNode(Integer.toString(i), true));
        }
        return Nodes;
    }

    private Collection<CyEdge> getEdges(Collection<CyNode> Nodes) {
        ArrayList<CyEdge> Edges = new ArrayList<CyEdge>();
        Iterator<CyNode> nodeI = Nodes.iterator();
        CyNode LastNode2 = null;
        while (nodeI.hasNext()) {
            CyNode Node2 = nodeI.next();
            if (LastNode2 != null) {
                Edges.add(Cytoscape.getCyEdge(LastNode2, Node2, "interaction", "test", true));
            }
            LastNode2 = Node2;
        }
        return Edges;
    }

    private class TitleListener
    implements PropertyChangeListener {
        private PropertyChangeEvent pcEvent;

        private TitleListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            this.pcEvent = event;
        }

        public PropertyChangeEvent getEvent() {
            return this.pcEvent;
        }
    }
}

