/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import cytoscape.data.attr.MultiHashMapDefinition;
import cytoscape.data.attr.util.MultiHashMapFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CyAttributesImpl
implements CyAttributes {
    private final MultiHashMap mmap;
    private final MultiHashMapDefinition mmapDef;
    private Map descriptionMap;
    private Set userInvisibleSet;
    private Set userNonEditableSet;

    public CyAttributesImpl() {
        Object model = MultiHashMapFactory.instantiateDataModel();
        this.mmap = (MultiHashMap)model;
        this.mmapDef = (MultiHashMapDefinition)model;
        this.descriptionMap = new HashMap();
        this.userInvisibleSet = new HashSet();
        this.userNonEditableSet = new HashSet();
    }

    public void setAttributeDescription(String attributeName, String description) {
        this.descriptionMap.put(attributeName, description);
    }

    public String getAttributeDescription(String attributeName) {
        return (String)this.descriptionMap.get(attributeName);
    }

    public void setUserVisible(String attributeName, boolean value) {
        if (value) {
            if (this.userInvisibleSet.contains(attributeName)) {
                this.userInvisibleSet.remove(attributeName);
            }
        } else if (!this.userInvisibleSet.contains(attributeName)) {
            this.userInvisibleSet.add(attributeName);
        }
    }

    public boolean getUserVisible(String attributeName) {
        return !this.userInvisibleSet.contains(attributeName);
    }

    public void setUserEditable(String attributeName, boolean value) {
        if (value) {
            if (this.userNonEditableSet.contains(attributeName)) {
                this.userNonEditableSet.remove(attributeName);
            }
        } else if (!this.userNonEditableSet.contains(attributeName)) {
            this.userNonEditableSet.add(attributeName);
        }
    }

    public boolean getUserEditable(String attributeName) {
        return !this.userNonEditableSet.contains(attributeName);
    }

    public String[] getAttributeNames() {
        CountedIterator citer = this.mmapDef.getDefinedAttributes();
        String[] names = new String[citer.numRemaining()];
        int inx = 0;
        while (citer.hasNext()) {
            names[inx++] = (String)citer.next();
        }
        return names;
    }

    public boolean hasAttribute(String id, String attributeName) {
        byte valType = this.mmapDef.getAttributeValueType(attributeName);
        if (valType < 0) {
            return false;
        }
        byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
        if (dimTypes.length == 0) {
            return this.mmap.getAttributeValue(id, attributeName, null) != null;
        }
        return this.mmap.getAttributeKeyspan(id, attributeName, null).numRemaining() > 0;
    }

    public void setAttribute(String id, String attributeName, Boolean value) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            this.mmapDef.defineAttribute(attributeName, (byte)1, null);
        } else {
            if (type != 1) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_BOOLEAN");
            }
            byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (dimTypes.length != 0) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_BOOLEAN");
            }
        }
        this.mmap.setAttributeValue(id, attributeName, value, null);
    }

    public void setAttribute(String id, String attributeName, Integer value) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            this.mmapDef.defineAttribute(attributeName, (byte)3, null);
        } else {
            if (type != 3) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_INTEGER");
            }
            byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (dimTypes.length != 0) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_INTEGER");
            }
        }
        this.mmap.setAttributeValue(id, attributeName, value, null);
    }

    public void setAttribute(String id, String attributeName, Double value) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            this.mmapDef.defineAttribute(attributeName, (byte)2, null);
        } else {
            if (type != 2) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_FLOATING");
            }
            byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (dimTypes.length != 0) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_FLOATING");
            }
        }
        this.mmap.setAttributeValue(id, attributeName, value, null);
    }

    public void setAttribute(String id, String attributeName, String value) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            this.mmapDef.defineAttribute(attributeName, (byte)4, null);
        } else {
            if (type != 4) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_STRING");
            }
            byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (dimTypes.length != 0) {
                throw new IllegalArgumentException("definition for attributeName '" + attributeName + "' already exists and it is not of TYPE_STRING");
            }
        }
        this.mmap.setAttributeValue(id, attributeName, value, null);
    }

    public Boolean getBooleanAttribute(String id, String attributeName) {
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            return null;
        }
        if (type != 1) {
            throw new ClassCastException("definition for attributeName '" + attributeName + "' is not of TYPE_BOOLEAN");
        }
        return (Boolean)this.mmap.getAttributeValue(id, attributeName, null);
    }

    public Integer getIntegerAttribute(String id, String attributeName) {
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            return null;
        }
        if (type != 3) {
            throw new ClassCastException("definition for attributeName '" + attributeName + "' is not of TYPE_INTEGER");
        }
        return (Integer)this.mmap.getAttributeValue(id, attributeName, null);
    }

    public Double getDoubleAttribute(String id, String attributeName) {
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            return null;
        }
        if (type != 2) {
            throw new ClassCastException("definition for attributeName '" + attributeName + "' is not of TYPE_FLOATING");
        }
        return (Double)this.mmap.getAttributeValue(id, attributeName, null);
    }

    public String getStringAttribute(String id, String attributeName) {
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            return null;
        }
        if (type != 4) {
            throw new ClassCastException("definition for attributeName '" + attributeName + "' is not of TYPE_STRING");
        }
        return (String)this.mmap.getAttributeValue(id, attributeName, null);
    }

    public Object getAttribute(String id, String attributeName) {
        byte type = this.mmapDef.getAttributeValueType(attributeName);
        if (type < 0) {
            return null;
        }
        return this.mmap.getAttributeValue(id, attributeName, null);
    }

    public byte getType(String attributeName) {
        byte valType = this.mmapDef.getAttributeValueType(attributeName);
        if (valType < 0) {
            return -1;
        }
        byte[] dimTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
        if (dimTypes.length == 0) {
            return valType;
        }
        if (dimTypes.length > 1) {
            return -4;
        }
        if (dimTypes[0] == 3) {
            return -2;
        }
        if (dimTypes[0] == 4) {
            return -3;
        }
        return -4;
    }

    public boolean deleteAttribute(String id, String attributeName) {
        boolean b = this.mmap.removeAllAttributeValues(id, attributeName);
        return b;
    }

    public boolean deleteAttribute(String attributeName) {
        boolean b = this.mmapDef.undefineAttribute(attributeName);
        return b;
    }

    public void setAttributeList(String id, String attributeName, List list) {
        this.setListAttribute(id, attributeName, list);
    }

    public void setListAttribute(String id, String attributeName, List list) {
        byte type;
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        if (list == null) {
            throw new IllegalArgumentException("list is null");
        }
        Iterator itor = list.iterator();
        if (!itor.hasNext()) {
            return;
        }
        Object obj = itor.next();
        if (obj instanceof Double) {
            type = 2;
        } else if (obj instanceof Integer) {
            type = 3;
        } else if (obj instanceof Boolean) {
            type = 1;
        } else if (obj instanceof String) {
            type = 4;
        } else {
            throw new IllegalArgumentException("objects in list are of unrecognized type");
        }
        while (itor.hasNext()) {
            obj = itor.next();
            if (!(type == 2 && !(obj instanceof Double) || type == 3 && !(obj instanceof Integer) || type == 1 && !(obj instanceof Boolean)) && (type != 4 || obj instanceof String)) continue;
            throw new IllegalArgumentException("items in list are not all of the same type");
        }
        byte valType = this.mmapDef.getAttributeValueType(attributeName);
        if (valType < 0) {
            this.mmapDef.defineAttribute(attributeName, type, new byte[]{3});
        } else {
            if (valType != type) {
                throw new IllegalArgumentException("existing definition for attributeName '" + attributeName + "' is a TYPE_SIMPLE_LIST that stores other value types");
            }
            byte[] keyTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (keyTypes.length != 1 || keyTypes[0] != 3) {
                throw new IllegalArgumentException("existing definition for attributeName '" + attributeName + "' is not of TYPE_SIMPLE_LIST");
            }
        }
        this.mmap.removeAllAttributeValues(id, attributeName);
        itor = list.iterator();
        int inx = 0;
        Object[] key = new Object[1];
        while (itor.hasNext()) {
            key[0] = new Integer(inx++);
            this.mmap.setAttributeValue(id, attributeName, itor.next(), key);
        }
    }

    public List getAttributeList(String id, String attributeName) {
        return this.getListAttribute(id, attributeName);
    }

    public List getListAttribute(String id, String attributeName) {
        if (this.mmapDef.getAttributeValueType(attributeName) < 0) {
            return null;
        }
        byte[] keyTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
        if (keyTypes.length != 1 || keyTypes[0] != 3) {
            throw new ClassCastException("attributeName '" + attributeName + "' is not of TYPE_SIMPLE_LIST");
        }
        ArrayList<Object> returnThis = new ArrayList<Object>();
        Object[] key = new Object[1];
        int i = 0;
        while (true) {
            key[0] = new Integer(i);
            Object val = this.mmap.getAttributeValue(id, attributeName, key);
            if (val == null) break;
            returnThis.add(i, val);
            ++i;
        }
        return returnThis;
    }

    public void setAttributeMap(String id, String attributeName, Map map) {
        this.setMapAttribute(id, attributeName, map);
    }

    public void setMapAttribute(String id, String attributeName, Map map) {
        byte type;
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("attributeName is null");
        }
        Set entrySet = map.entrySet();
        Iterator itor = entrySet.iterator();
        if (!itor.hasNext()) {
            return;
        }
        Map.Entry entry = itor.next();
        if (!(entry.getKey() instanceof String)) {
            throw new IllegalArgumentException("keys in map are not all String");
        }
        Object val = entry.getValue();
        if (val instanceof Double) {
            type = 2;
        } else if (val instanceof Integer) {
            type = 3;
        } else if (val instanceof Boolean) {
            type = 1;
        } else if (val instanceof String) {
            type = 4;
        } else {
            throw new IllegalArgumentException("values in map are of unrecognized type");
        }
        while (itor.hasNext()) {
            entry = itor.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("keys in map are not all String");
            }
            val = entry.getValue();
            if (!(type == 2 && !(val instanceof Double) || type == 3 && !(val instanceof Integer) || type == 1 && !(val instanceof Boolean)) && (type != 4 || val instanceof String)) continue;
            throw new IllegalArgumentException("values in map are not all of the same type");
        }
        byte valType = this.mmapDef.getAttributeValueType(attributeName);
        if (valType < 0) {
            this.mmapDef.defineAttribute(attributeName, type, new byte[]{4});
        } else {
            if (valType != type) {
                throw new IllegalArgumentException("existing definition for attributeName '" + attributeName + "' is a TYPE_SIMPLE_MAP that stores other value types");
            }
            byte[] keyTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
            if (keyTypes.length != 1 || keyTypes[0] != 4) {
                throw new IllegalArgumentException("existing definition for attributeName '" + attributeName + "' is not of TYPE_SIMPLE_MAP");
            }
        }
        this.mmap.removeAllAttributeValues(id, attributeName);
        itor = entrySet.iterator();
        Object[] key = new Object[1];
        while (itor.hasNext()) {
            entry = itor.next();
            key[0] = entry.getKey();
            this.mmap.setAttributeValue(id, attributeName, entry.getValue(), key);
        }
    }

    public Map getAttributeMap(String id, String attributeName) {
        return this.getMapAttribute(id, attributeName);
    }

    public Map getMapAttribute(String id, String attributeName) {
        if (this.mmapDef.getAttributeValueType(attributeName) < 0) {
            return null;
        }
        byte[] keyTypes = this.mmapDef.getAttributeKeyspaceDimensionTypes(attributeName);
        if (keyTypes.length != 1 || keyTypes[0] != 4) {
            throw new ClassCastException("attributeName '" + attributeName + "' is not of TYPE_SIMPLE_MAP");
        }
        HashMap<Object, Object> returnThis = new HashMap<Object, Object>();
        CountedIterator keyspan = this.mmap.getAttributeKeyspan(id, attributeName, null);
        Object[] key = new Object[1];
        while (keyspan.hasNext()) {
            key[0] = keyspan.next();
            returnThis.put(key[0], this.mmap.getAttributeValue(id, attributeName, key));
        }
        return returnThis;
    }

    public MultiHashMap getMultiHashMap() {
        return this.mmap;
    }

    public MultiHashMapDefinition getMultiHashMapDefinition() {
        return this.mmapDef;
    }
}

