/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.dialogs.plugins.PluginUpdateDialog;
import cytoscape.logger.CyLogger;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.PluginManager;
import cytoscape.plugin.PluginStatus;
import cytoscape.util.CytoscapeAction;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.jdom.JDOMException;

public class PluginUpdateAction
extends CytoscapeAction {
    protected static CyLogger logger = CyLogger.getLogger(PluginUpdateAction.class);

    public PluginUpdateAction() {
        super("Update Plugins");
        this.setPreferredMenu("Plugins");
        if (PluginManager.usingWebstartManager()) {
            this.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PluginUpdateDialog Dialog2 = new PluginUpdateDialog(Cytoscape.getDesktop());
        ArrayList<String> XmlIncorrect = new ArrayList<String>();
        ArrayList<String> BadXml = new ArrayList<String>();
        if (!PluginManager.usingWebstartManager()) {
            boolean updateFound = false;
            PluginManager Mgr = PluginManager.getPluginManager();
            for (DownloadableInfo Current : Mgr.getDownloadables(PluginStatus.CURRENT)) {
                try {
                    List<DownloadableInfo> Updates = Mgr.findUpdates(Current);
                    if (Updates.size() <= 0) continue;
                    Dialog2.addCategory(Current.getCategory(), Current, Updates);
                    updateFound = true;
                }
                catch (JDOMException jde) {
                    logger.warn(jde.getMessage());
                    XmlIncorrect.add(Current.toString());
                }
                catch (IOException ioe) {
                    logger.warn("Failed to read XML file for " + Current.getName() + " at " + Current.getDownloadableURL(), ioe);
                    BadXml.add(Current.toString());
                }
            }
            if (XmlIncorrect.size() > 0) {
                // empty if block
            }
            if (updateFound) {
                Dialog2.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "No updates available for currently installed plugins.", "Plugin Updates", 1);
            }
        } else {
            JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Plugin updates are not available when using Cytoscape through webstart", "Plugin Update", 1);
        }
    }
}

