/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.VisualStyle;
import ding.view.DGraphView;
import giny.model.Edge;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.event.MenuEvent;

public class CloneGraphInNewWindowAction
extends CytoscapeAction {
    public CloneGraphInNewWindowAction() {
        super("Clone current network");
        this.setPreferredMenu("File.New.Network");
    }

    public void actionPerformed(ActionEvent e) {
        CyNetwork origNet = Cytoscape.getCurrentNetwork();
        CyNetworkView origView = Cytoscape.getCurrentNetworkView();
        VisualStyle vs = Cytoscape.getVisualMappingManager().getVisualStyle();
        CyNetwork new_network = Cytoscape.createNetwork(origNet.getNodeIndicesArray(), origNet.getEdgeIndicesArray(), origNet.getTitle() + " copy", null, true);
        if (origView == null || origView == Cytoscape.getNullNetworkView()) {
            return;
        }
        CyNetworkView newView = Cytoscape.getNetworkView(new_network.getIdentifier());
        if (newView != null || newView != Cytoscape.getNullNetworkView()) {
            Iterator ni = origView.getGraphPerspective().nodesIterator();
            while (ni.hasNext()) {
                Node n = (Node)ni.next();
                NodeView onv = origView.getNodeView(n);
                NodeView nnv = newView.getNodeView(n);
                nnv.setXPosition(onv.getXPosition());
                nnv.setYPosition(onv.getYPosition());
            }
            newView.setZoom(origView.getZoom());
            Point2D origCenter = ((DGraphView)origView).getCenter();
            ((DGraphView)newView).setCenter(origCenter.getX(), origCenter.getY());
            Iterator ei = origView.getGraphPerspective().edgesIterator();
            while (ei.hasNext()) {
                Edge ee = (Edge)ei.next();
                EdgeView oev = origView.getEdgeView(ee);
                EdgeView nev = newView.getEdgeView(ee);
                nev.getBend().setHandles(oev.getBend().getHandles());
                nev.getBend().setHandles(oev.getBend().getHandles());
                nev.setLineType(oev.getLineType());
            }
            Cytoscape.getVisualMappingManager().setVisualStyle(vs);
        }
    }

    public void menuSelected(MenuEvent e) {
        this.enableForNetwork();
    }
}

