/*
 * Decompiled with CFR 0.152.
 */
package weka.associations.tertius;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import weka.associations.tertius.Body;
import weka.associations.tertius.Head;
import weka.associations.tertius.IndividualLiteral;
import weka.associations.tertius.Literal;
import weka.associations.tertius.LiteralSet;
import weka.associations.tertius.Predicate;
import weka.associations.tertius.SimpleLinkedList;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class Rule
implements Serializable,
Cloneable,
RevisionHandler {
    private static final long serialVersionUID = -7763378359090435505L;
    private Body m_body;
    private Head m_head;
    private boolean m_repeatPredicate;
    private int m_maxLiterals;
    private boolean m_negBody;
    private boolean m_negHead;
    private boolean m_classRule;
    private boolean m_singleHead;
    private int m_numInstances;
    private ArrayList m_counterInstances;
    private int m_counter;
    private double m_confirmation;
    private double m_optimistic;
    public static Comparator confirmationComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            double d;
            Rule rule = (Rule)object;
            Rule rule2 = (Rule)object2;
            double d2 = rule.getConfirmation();
            if (d2 > (d = rule2.getConfirmation())) {
                return -1;
            }
            if (d2 < d) {
                return 1;
            }
            return 0;
        }
    };
    public static Comparator observedComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            double d;
            Rule rule = (Rule)object;
            Rule rule2 = (Rule)object2;
            double d2 = rule.getObservedFrequency();
            if (d2 < (d = rule2.getObservedFrequency())) {
                return -1;
            }
            if (d2 > d) {
                return 1;
            }
            return 0;
        }
    };
    public static Comparator optimisticComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            double d;
            Rule rule = (Rule)object;
            Rule rule2 = (Rule)object2;
            double d2 = rule.getOptimistic();
            if (d2 > (d = rule2.getOptimistic())) {
                return -1;
            }
            if (d2 < d) {
                return 1;
            }
            return 0;
        }
    };
    public static Comparator confirmationThenObservedComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            int n = confirmationComparator.compare(object, object2);
            if (n != 0) {
                return n;
            }
            return observedComparator.compare(object, object2);
        }
    };
    public static Comparator optimisticThenObservedComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            int n = optimisticComparator.compare(object, object2);
            if (n != 0) {
                return n;
            }
            return observedComparator.compare(object, object2);
        }
    };

    public Rule(boolean bl, int n, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.m_body = new Body();
        this.m_head = new Head();
        this.m_repeatPredicate = bl;
        this.m_maxLiterals = n;
        this.m_negBody = bl2 && !bl5;
        this.m_negHead = bl3 && !bl5;
        this.m_classRule = bl4;
        this.m_singleHead = bl4 || bl5;
    }

    public Rule(Instances instances, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.m_body = new Body(instances);
        this.m_head = new Head(instances);
        this.m_repeatPredicate = bl;
        this.m_maxLiterals = n;
        this.m_negBody = bl2 && !bl5;
        this.m_negHead = bl3 && !bl5;
        this.m_classRule = bl4;
        this.m_singleHead = bl4 || bl5;
        this.m_numInstances = instances.numInstances();
        this.m_counterInstances = new ArrayList(this.m_numInstances);
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            this.m_counterInstances.add(enumeration.nextElement());
        }
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
            ((Rule)object).m_body = (Body)this.m_body.clone();
            ((Rule)object).m_head = (Head)this.m_head.clone();
            if (this.m_counterInstances != null) {
                ((Rule)object).m_counterInstances = (ArrayList)this.m_counterInstances.clone();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        return object;
    }

    public boolean counterInstance(Instance instance) {
        return this.m_body.counterInstance(instance) && this.m_head.counterInstance(instance);
    }

    public void upDate(Instances instances) {
        Enumeration enumeration = instances.enumerateInstances();
        this.m_numInstances = instances.numInstances();
        this.m_counter = 0;
        while (enumeration.hasMoreElements()) {
            if (!this.counterInstance((Instance)enumeration.nextElement())) continue;
            ++this.m_counter;
        }
        this.m_head.upDate(instances);
        this.m_body.upDate(instances);
    }

    public double getConfirmation() {
        return this.m_confirmation;
    }

    public double getOptimistic() {
        return this.m_optimistic;
    }

    public double getExpectedNumber() {
        return (double)this.m_body.getCounterInstancesNumber() * (double)this.m_head.getCounterInstancesNumber() / (double)this.m_numInstances;
    }

    public double getExpectedFrequency() {
        return this.getExpectedNumber() / (double)this.m_numInstances;
    }

    public int getObservedNumber() {
        if (this.m_counterInstances != null) {
            return this.m_counterInstances.size();
        }
        return this.m_counter;
    }

    public double getObservedFrequency() {
        return (double)this.getObservedNumber() / (double)this.m_numInstances;
    }

    public double getTPRate() {
        int n = this.m_body.getCounterInstancesNumber() - this.getObservedNumber();
        int n2 = this.m_numInstances - this.m_head.getCounterInstancesNumber() - n;
        return (double)n / (double)(n + n2);
    }

    public double getFPRate() {
        int n = this.getObservedNumber();
        int n2 = this.m_head.getCounterInstancesNumber() - n;
        return (double)n / (double)(n + n2);
    }

    public void calculateConfirmation() {
        double d = this.getExpectedFrequency();
        double d2 = this.getObservedFrequency();
        this.m_confirmation = d == 0.0 || d == 1.0 ? 0.0 : (d - d2) / (Math.sqrt(d) - d);
    }

    public void calculateOptimistic() {
        int n = this.getObservedNumber();
        int n2 = this.m_body.getCounterInstancesNumber();
        int n3 = this.m_head.getCounterInstancesNumber();
        int n4 = this.m_numInstances;
        double d = n <= n2 - n3 ? (double)(n3 * (n2 - n)) / (double)(n4 * n4) : (n <= n3 - n2 ? (double)(n2 * (n3 - n)) / (double)(n4 * n4) : (double)((n3 + n2 - n) * (n3 + n2 - n)) / (double)(4 * n4 * n4));
        this.m_optimistic = d == 0.0 || d == 1.0 ? 0.0 : d / (Math.sqrt(d) - d);
    }

    public boolean isEmpty() {
        return this.m_head.isEmpty() && this.m_body.isEmpty();
    }

    public int numLiterals() {
        return this.m_body.numLiterals() + this.m_head.numLiterals();
    }

    private Rule addTermToBody(Literal literal) {
        if (!this.m_negBody && literal.negative() || this.m_classRule && literal.getPredicate().isClass() || literal instanceof IndividualLiteral && ((IndividualLiteral)literal).getType() - this.m_body.getType() > 1 && ((IndividualLiteral)literal).getType() - this.m_head.getType() > 1) {
            return null;
        }
        Rule rule = (Rule)this.clone();
        rule.m_body.addElement(literal);
        if (this.m_counterInstances != null) {
            for (int i = rule.m_counterInstances.size() - 1; i >= 0; --i) {
                Instance instance = (Instance)rule.m_counterInstances.get(i);
                if (rule.m_body.canKeep(instance, literal)) continue;
                rule.m_counterInstances.remove(i);
            }
        }
        return rule;
    }

    private Rule addTermToHead(Literal literal) {
        if (!this.m_negHead && literal.negative() || this.m_classRule && !literal.getPredicate().isClass() || this.m_singleHead && !this.m_head.isEmpty() || literal instanceof IndividualLiteral && ((IndividualLiteral)literal).getType() != IndividualLiteral.INDIVIDUAL_PROPERTY) {
            return null;
        }
        Rule rule = (Rule)this.clone();
        rule.m_head.addElement(literal);
        if (this.m_counterInstances != null) {
            for (int i = rule.m_counterInstances.size() - 1; i >= 0; --i) {
                Instance instance = (Instance)rule.m_counterInstances.get(i);
                if (rule.m_head.canKeep(instance, literal)) continue;
                rule.m_counterInstances.remove(i);
            }
        }
        return rule;
    }

    private SimpleLinkedList refine(Predicate predicate, int n, int n2, boolean bl, boolean bl2) {
        SimpleLinkedList simpleLinkedList = new SimpleLinkedList();
        for (int i = n; i < n2; ++i) {
            Literal literal;
            Rule rule;
            Literal literal2 = predicate.getLiteral(i);
            if (bl && (rule = this.addTermToBody(literal2)) != null) {
                simpleLinkedList.add(rule);
            }
            if (bl2 && (rule = this.addTermToHead(literal2)) != null) {
                simpleLinkedList.add(rule);
            }
            if ((literal = literal2.getNegation()) == null) continue;
            if (bl && (rule = this.addTermToBody(literal)) != null) {
                simpleLinkedList.add(rule);
            }
            if (!bl2 || (rule = this.addTermToHead(literal)) == null) continue;
            simpleLinkedList.add(rule);
        }
        return simpleLinkedList;
    }

    public SimpleLinkedList refine(ArrayList arrayList) {
        SimpleLinkedList simpleLinkedList = new SimpleLinkedList();
        if (this.numLiterals() == this.m_maxLiterals) {
            return simpleLinkedList;
        }
        if (this.isEmpty()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Predicate predicate = (Predicate)arrayList.get(i);
                simpleLinkedList.addAll(this.refine(predicate, 0, predicate.numLiterals(), true, true));
            }
        } else if (this.m_body.isEmpty() || this.m_head.isEmpty()) {
            boolean bl;
            boolean bl2;
            LiteralSet literalSet;
            if (this.m_body.isEmpty()) {
                literalSet = this.m_head;
                bl2 = true;
                bl = false;
            } else {
                literalSet = this.m_body;
                bl2 = false;
                bl = true;
            }
            Literal literal = literalSet.getLastLiteral();
            Predicate predicate = literal.getPredicate();
            if (this.m_repeatPredicate) {
                simpleLinkedList.addAll(this.refine(predicate, predicate.indexOf(literal) + 1, predicate.numLiterals(), bl2, bl));
            }
            for (int i = arrayList.indexOf(predicate) + 1; i < arrayList.size(); ++i) {
                predicate = (Predicate)arrayList.get(i);
                simpleLinkedList.addAll(this.refine(predicate, 0, predicate.numLiterals(), bl2, bl));
            }
        } else {
            Predicate predicate;
            int n;
            int n2;
            Predicate predicate2;
            boolean bl;
            Literal literal = this.m_body.getLastLiteral();
            Literal literal2 = this.m_head.getLastLiteral();
            Predicate predicate3 = literal.getPredicate();
            Predicate predicate4 = literal2.getPredicate();
            int n3 = predicate3.indexOf(literal);
            int n4 = predicate4.indexOf(literal2);
            int n5 = arrayList.indexOf(predicate3);
            int n6 = arrayList.indexOf(predicate4);
            boolean bl3 = this.m_head.numLiterals() == 1 && (n5 < n6 || n5 == n6 && n3 < n4);
            boolean bl4 = bl = this.m_body.numLiterals() == 1 && (n6 < n5 || n6 == n5 && n4 < n3);
            if (bl3 || bl) {
                int n7;
                Predicate predicate5;
                if (bl3) {
                    predicate5 = predicate3;
                    n7 = n3;
                    predicate2 = predicate4;
                    n2 = n4;
                } else {
                    predicate5 = predicate4;
                    n7 = n4;
                    predicate2 = predicate3;
                    n2 = n3;
                }
                if (arrayList.indexOf(predicate5) < arrayList.indexOf(predicate2)) {
                    if (this.m_repeatPredicate) {
                        simpleLinkedList.addAll(this.refine(predicate5, n7 + 1, predicate5.numLiterals(), bl3, bl));
                    }
                    for (n = arrayList.indexOf(predicate5) + 1; n < arrayList.indexOf(predicate2); ++n) {
                        predicate = (Predicate)arrayList.get(n);
                        simpleLinkedList.addAll(this.refine(predicate, 0, predicate.numLiterals(), bl3, bl));
                    }
                    if (this.m_repeatPredicate) {
                        simpleLinkedList.addAll(this.refine(predicate2, 0, n2, bl3, bl));
                    }
                } else if (this.m_repeatPredicate) {
                    simpleLinkedList.addAll(this.refine(predicate5, n7 + 1, n2, bl3, bl));
                }
            }
            if (arrayList.indexOf(predicate3) > arrayList.indexOf(predicate4)) {
                predicate2 = predicate3;
                n2 = predicate3.indexOf(literal);
            } else if (arrayList.indexOf(predicate3) < arrayList.indexOf(predicate4)) {
                predicate2 = predicate4;
                n2 = predicate4.indexOf(literal2);
            } else {
                predicate2 = predicate3;
                n2 = n3 > n4 ? predicate3.indexOf(literal) : predicate4.indexOf(literal2);
            }
            if (this.m_repeatPredicate) {
                simpleLinkedList.addAll(this.refine(predicate2, n2 + 1, predicate2.numLiterals(), true, true));
            }
            for (n = arrayList.indexOf(predicate2) + 1; n < arrayList.size(); ++n) {
                predicate = (Predicate)arrayList.get(n);
                simpleLinkedList.addAll(this.refine(predicate, 0, predicate.numLiterals(), true, true));
            }
        }
        return simpleLinkedList;
    }

    public boolean subsumes(Rule rule) {
        if (this.numLiterals() > rule.numLiterals()) {
            return false;
        }
        return this.m_body.isIncludedIn(rule) && this.m_head.isIncludedIn(rule);
    }

    public boolean sameClauseAs(Rule rule) {
        return this.numLiterals() == rule.numLiterals() && this.subsumes(rule);
    }

    public boolean equivalentTo(Rule rule) {
        return this.numLiterals() == rule.numLiterals() && this.m_head.negationIncludedIn(rule.m_body) && this.m_body.negationIncludedIn(rule.m_head);
    }

    public boolean bodyContains(Literal literal) {
        return this.m_body.contains(literal);
    }

    public boolean headContains(Literal literal) {
        return this.m_head.contains(literal);
    }

    public boolean overFrequencyThreshold(double d) {
        return this.m_body.overFrequencyThreshold(d) && this.m_head.overFrequencyThreshold(d);
    }

    public boolean hasTrueBody() {
        return !this.m_body.isEmpty() && this.m_body.hasMaxCounterInstances();
    }

    public boolean hasFalseHead() {
        return !this.m_head.isEmpty() && this.m_head.hasMaxCounterInstances();
    }

    public String valuesToString() {
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        stringBuffer.append(decimalFormat.format(this.getConfirmation()));
        stringBuffer.append(" ");
        stringBuffer.append(decimalFormat.format(this.getObservedFrequency()));
        return stringBuffer.toString();
    }

    public String rocToString() {
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        stringBuffer.append(decimalFormat.format(this.getConfirmation()));
        stringBuffer.append(" ");
        stringBuffer.append(decimalFormat.format(this.getTPRate()));
        stringBuffer.append(" ");
        stringBuffer.append(decimalFormat.format(this.getFPRate()));
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_body.toString());
        stringBuffer.append(" ==> ");
        stringBuffer.append(this.m_head.toString());
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.7 $");
    }
}

