/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.task.sample;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.io.IOException;

public class SampleTask
implements Task {
    private static final int MIN_VALUE = 0;
    private int maxValue;
    private long countDelay;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private int exceptionIndex = Integer.MAX_VALUE;

    public SampleTask(int max, long countDelay) {
        this.maxValue = max;
        this.countDelay = countDelay;
    }

    public SampleTask(int max, long countDelay, int exceptionIndex) {
        this.maxValue = max;
        this.countDelay = countDelay;
        this.exceptionIndex = exceptionIndex;
    }

    public void run() {
        if (this.taskMonitor == null) {
            throw new IllegalStateException("Task Monitor is not set.");
        }
        try {
            for (int i = 0; i <= this.maxValue && !this.interrupted; ++i) {
                int percentComplete = (int)((double)i / (double)this.maxValue * 100.0);
                long totalTime = (long)this.maxValue * this.countDelay;
                long timeElapsed = (long)i * this.countDelay;
                long timeRemaining = totalTime - timeElapsed;
                if (this.taskMonitor != null) {
                    this.taskMonitor.setPercentCompleted(percentComplete);
                    this.taskMonitor.setStatus("Counting:  " + i);
                    this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
                }
                if (i == this.exceptionIndex) {
                    throw new IOException("This is a Fake IO Exception");
                }
                Thread.sleep(this.countDelay);
            }
            this.taskMonitor.setStatus("Task is now complete.\n\nThis is a long message used to demonstrate that status messages can be long, and can span multiple lines.");
        }
        catch (InterruptedException e) {
            this.taskMonitor.setException(e, "Counting interrupted");
        }
        catch (IOException e) {
            this.taskMonitor.setException(e, "Counting aborted by fake exception");
        }
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Counting Task");
    }
}

