/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.seq.io.ParseException;
import org.biojavax.Comment;

public class UniProtCommentParser {
    private static final String PREFIX = "-!-";
    public static final String BIOPHYSICOCHEMICAL_PROPERTIES = "BIOPHYSICOCHEMICAL PROPERTIES";
    public static final String DATABASE = "DATABASE";
    public static final String MASS_SPECTROMETRY = "MASS SPECTROMETRY";
    public static final String ALTERNATIVE_PRODUCTS = "ALTERNATIVE PRODUCTS";
    public static final String INTERACTION = "INTERACTION";
    public static final String PTM = "PTM";
    public static final String SEQUENCE_CAUTION = "SEQUENCE CAUTION";
    private String commentType;
    private String text;
    private String databaseName;
    private String note;
    private String uri;
    private int molecularWeight;
    private Integer molWeightError;
    private int molWeightRangeStart;
    private int molWeightRangeEnd;
    private String molWeightMethod;
    private List interactions = new ArrayList();
    private List seqCautions;
    private List events;
    private List isoforms = new ArrayList();
    private String absorptionMax;
    private String absorptionNote;
    private List KMs;
    private List VMaxes;
    private String kineticsNote;
    private String PHDependence;
    private String redoxPotential;
    private String temperatureDependence;

    public UniProtCommentParser() {
        this.events = new ArrayList();
        this.KMs = new ArrayList();
        this.VMaxes = new ArrayList();
        this.seqCautions = new ArrayList();
    }

    public void parseComment(Comment c) throws ParseException {
        this.parseComment(c.getComment());
    }

    public void parseComment(String c) throws ParseException {
        block56: {
            if (!UniProtCommentParser.isParseable(c)) {
                throw new ParseException("Comment is not a UniProt structured comment. Comment was " + c);
            }
            String comment = new String(c);
            try {
                c = c.replaceAll("\\s+", " ").trim();
                c = c.substring(PREFIX.length() + 1);
                String type = c.substring(0, c.indexOf(58));
                this.setCommentType(type);
                c = c.substring(c.indexOf(58) + 1);
                if (c.endsWith(".")) {
                    c = c.substring(0, c.length() - 1);
                }
                if (this.getCommentType().equalsIgnoreCase(BIOPHYSICOCHEMICAL_PROPERTIES)) {
                    do {
                        String key;
                        String[] parts;
                        if ((parts = c.split(";")).length == 1) {
                            int firstColon = parts[0].indexOf(58);
                            key = parts[0].substring(0, firstColon).trim();
                            String value = parts[0].substring(firstColon + 1).trim();
                            if (key.equalsIgnoreCase("pH dependence")) {
                                this.setPHDependence(value);
                            } else if (key.equalsIgnoreCase("Redox potential")) {
                                this.setRedoxPotential(value);
                            } else if (key.equalsIgnoreCase("Temperature dependence")) {
                                this.setTemperatureDependence(value);
                            }
                            c = c.substring(c.indexOf(";") + 1);
                            continue;
                        }
                        int skippos = -1;
                        key = parts[0].split(":")[0].trim();
                        if (key.equalsIgnoreCase("Absorption")) {
                            String[] subparts = parts[0].split(":")[1].split("=");
                            this.setAbsorptionMax(subparts[1].trim());
                            subparts = parts[1].split("=");
                            this.setAbsorptionNote(subparts[1].trim());
                            skippos = 2;
                        } else if (key.equalsIgnoreCase("Kinetic parameters")) {
                            int partCount = 0;
                            String[] subparts = parts[partCount].split(":")[1].split("=");
                            key = subparts[0].trim();
                            String value = subparts[1].trim();
                            while (!key.equalsIgnoreCase("Note")) {
                                if (key.equalsIgnoreCase("KM")) {
                                    this.getKMs().add(value);
                                } else if (key.equalsIgnoreCase("VMax")) {
                                    this.getVMaxes().add(value);
                                }
                                subparts = parts[++partCount].split("=");
                                key = subparts[0].trim();
                                value = subparts[1].trim();
                            }
                            this.setKineticsNote(value);
                        }
                        int chunkpos = c.indexOf(parts[skippos]);
                        c = c.substring(chunkpos);
                    } while ((c = c.trim()).length() > 0);
                    break block56;
                }
                if (this.getCommentType().equalsIgnoreCase(DATABASE)) {
                    c = c.substring(0, c.length() - 1);
                    String[] parts = c.split(";");
                    for (int i = 0; i < parts.length; ++i) {
                        String[] subparts = parts[i].split("=");
                        String key = subparts[0].trim();
                        String value = subparts[1].trim();
                        if (key.equalsIgnoreCase("NAME")) {
                            this.setDatabaseName(value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("NOTE")) {
                            this.setNote(value);
                            continue;
                        }
                        if (!key.equalsIgnoreCase("WWW") && !key.equalsIgnoreCase("FTP")) continue;
                        this.setUri(value);
                    }
                    break block56;
                }
                if (this.getCommentType().equalsIgnoreCase(MASS_SPECTROMETRY)) {
                    c = c.substring(0, c.length() - 1);
                    String[] parts = c.split(";");
                    for (int i = 0; i < parts.length; ++i) {
                        String[] subparts = parts[i].split("=");
                        String key = subparts[0].trim();
                        String value = subparts[1].trim();
                        if (key.equalsIgnoreCase("MW")) {
                            this.setMolecularWeight(Integer.parseInt(value));
                            continue;
                        }
                        if (key.equalsIgnoreCase("MW_ERR")) {
                            this.setMolWeightError(new Integer(value));
                            continue;
                        }
                        if (key.equalsIgnoreCase("METHOD")) {
                            this.setMolWeightMethod(value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("RANGE")) {
                            if (value.indexOf(32) > -1) {
                                value = value.substring(0, value.indexOf(32));
                            }
                            String[] locs = value.split("-");
                            this.setMolWeightRangeStart(Integer.parseInt(locs[0]));
                            this.setMolWeightRangeEnd(Integer.parseInt(locs[1]));
                            continue;
                        }
                        if (!key.equalsIgnoreCase("NOTE")) continue;
                        this.setNote(value);
                    }
                    break block56;
                }
                if (this.getCommentType().equalsIgnoreCase(INTERACTION)) {
                    String[] parts = c.split(";");
                    Interaction interact = null;
                    for (int i = 0; i < parts.length; ++i) {
                        String[] subparts = parts[i].split("=");
                        String key = subparts[0].trim();
                        String value = null;
                        if (key.equalsIgnoreCase("Self")) {
                            interact = new Interaction();
                            interact.setID("Self");
                            interact.setOrganismsDiffer(false);
                            this.getInteractions().add(interact);
                            continue;
                        }
                        if (subparts.length == 1) {
                            subparts = key.split(":");
                            boolean differ = false;
                            if (subparts[1].indexOf("(xeno)") > -1) {
                                differ = true;
                                subparts[1] = subparts[1].substring(0, subparts[1].indexOf("(xeno)"));
                            }
                            interact = new Interaction();
                            interact.setID(subparts[0].trim());
                            interact.setLabel(subparts[1].trim());
                            interact.setOrganismsDiffer(differ);
                            this.getInteractions().add(interact);
                            continue;
                        }
                        value = subparts[1].trim();
                        if (key.equalsIgnoreCase("NbExp")) {
                            interact.setNumberExperiments(Integer.parseInt(value));
                            continue;
                        }
                        if (!key.equalsIgnoreCase("IntAct")) continue;
                        subparts = value.split(",");
                        interact.setFirstIntActID(subparts[0].trim());
                        interact.setSecondIntActID(subparts[1].trim());
                    }
                    break block56;
                }
                if (this.getCommentType().equalsIgnoreCase(ALTERNATIVE_PRODUCTS)) {
                    Event event = null;
                    Isoform isoform = null;
                    String[] parts = c.split(";");
                    for (int i = 0; i < parts.length; ++i) {
                        int j;
                        String[] subparts = parts[i].split("=");
                        String key = subparts[0].trim();
                        String value = subparts[1].trim();
                        if (key.equalsIgnoreCase("Event")) {
                            event = new Event();
                            this.getEvents().add(event);
                            event.setType(value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("Name")) {
                            isoform = new Isoform();
                            this.getIsoforms().add(isoform);
                            isoform.getNames().add(value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("Synonyms")) {
                            subparts = value.split(",");
                            for (j = 0; j < subparts.length; ++j) {
                                isoform.getNames().add(subparts[j].trim());
                            }
                            continue;
                        }
                        if (key.equalsIgnoreCase("IsoId")) {
                            subparts = value.split(",");
                            for (j = 0; j < subparts.length; ++j) {
                                isoform.getIsoIDs().add(subparts[j].trim());
                            }
                            continue;
                        }
                        if (key.equalsIgnoreCase("Sequence")) {
                            if (value.equalsIgnoreCase("Displayed")) {
                                isoform.setSequenceType("Displayed");
                                continue;
                            }
                            if (value.equalsIgnoreCase("Not described")) {
                                isoform.setSequenceType("Not described");
                                continue;
                            }
                            if (value.equalsIgnoreCase("External")) {
                                isoform.setSequenceType("External");
                                continue;
                            }
                            isoform.setSequenceType("Described");
                            isoform.setSequenceRef(value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("Note")) {
                            isoform.setNote(value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("Named isoforms")) {
                            event.setNamedIsoforms(Integer.parseInt(value));
                            continue;
                        }
                        if (!key.equalsIgnoreCase("Comment")) continue;
                        event.setComment(value);
                    }
                    break block56;
                }
                if (this.getCommentType().equalsIgnoreCase(SEQUENCE_CAUTION)) {
                    SeqCaution seqc = null;
                    c = c.substring(0, c.length() - 1);
                    String[] parts = c.split(";");
                    for (int i = 0; i < parts.length; ++i) {
                        String[] subparts = parts[i].split("=");
                        String key = subparts[0].trim();
                        String value = subparts[1].trim();
                        if (key.equalsIgnoreCase("SEQUENCE")) {
                            seqc = new SeqCaution();
                            this.getSeqCautions().add(seqc);
                            seqc.setSequence(value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("TYPE")) {
                            seqc.setType(value);
                            continue;
                        }
                        if (key.equalsIgnoreCase("POSITIONS")) {
                            seqc.setPositions(value);
                            continue;
                        }
                        if (!key.equalsIgnoreCase("NOTE")) continue;
                        seqc.setNote(value);
                    }
                } else {
                    this.setText(c);
                }
            }
            catch (RuntimeException ex) {
                throw new ParseException(ex, "Cannot parse the comment: " + comment);
            }
        }
    }

    public static boolean isParseable(Comment c) {
        return UniProtCommentParser.isParseable(c.getComment());
    }

    public static boolean isParseable(String c) {
        return c.trim().startsWith(PREFIX);
    }

    public String generate() throws ParseException {
        StringBuffer sb = new StringBuffer();
        sb.append(PREFIX);
        sb.append(" ");
        sb.append(this.getCommentType());
        sb.append(": ");
        if (this.getCommentType().equalsIgnoreCase(BIOPHYSICOCHEMICAL_PROPERTIES)) {
            if (this.getAbsorptionNote() != null) {
                sb.append("\nAbsorption:\n  Abs(max)=");
                sb.append(this.getAbsorptionMax());
                sb.append(";\n  Note=");
                sb.append(this.getAbsorptionNote());
                sb.append(";");
            }
            if (this.getKineticsNote() != null) {
                sb.append("\nKinetic parameters:\n");
                Iterator j = this.getKMs().iterator();
                while (j.hasNext()) {
                    sb.append("  KM=");
                    sb.append((String)j.next());
                    sb.append(";\n");
                }
                j = this.getVMaxes().iterator();
                while (j.hasNext()) {
                    sb.append("  VMax=");
                    sb.append((String)j.next());
                    sb.append(";\n");
                }
                sb.append("  Note=");
                sb.append(this.getKineticsNote());
                sb.append(";");
            }
            if (this.getPHDependence() != null) {
                sb.append("\npH dependence:\n  ");
                sb.append(this.getPHDependence());
                sb.append(";");
            }
            if (this.getRedoxPotential() != null) {
                sb.append("\nRedox potential:\n  ");
                sb.append(this.getRedoxPotential());
                sb.append(";");
            }
            if (this.getTemperatureDependence() != null) {
                sb.append("\nTemperature dependence:\n  ");
                sb.append(this.getTemperatureDependence());
                sb.append(";");
            }
        } else if (this.getCommentType().equalsIgnoreCase(DATABASE)) {
            if (this.getDatabaseName() == null) {
                throw new ParseException("Database name is missing");
            }
            sb.append("NAME=");
            sb.append(this.getDatabaseName());
            if (this.getNote() != null) {
                sb.append("; NOTE=");
                sb.append(this.getNote());
            }
            if (this.getUri() != null) {
                sb.append("; ");
                if (this.getUri().startsWith("ftp")) {
                    sb.append(" FTP=");
                } else {
                    sb.append(" WWW=");
                }
                sb.append(this.getUri());
            }
            sb.append(".");
        } else if (this.getCommentType().equalsIgnoreCase(MASS_SPECTROMETRY)) {
            sb.append("MW=");
            sb.append("" + this.getMolecularWeight());
            if (this.getMolWeightError() != null) {
                sb.append("; MW_ERR=");
                sb.append("" + this.getMolWeightError());
            }
            sb.append("; METHOD=");
            sb.append(this.getMolWeightMethod());
            sb.append("; RANGE=");
            sb.append("" + this.getMolWeightRangeStart());
            sb.append("-");
            sb.append("" + this.getMolWeightRangeEnd());
            sb.append("; NOTE=");
            sb.append(this.getNote());
            sb.append(".");
        } else if (this.getCommentType().equalsIgnoreCase(INTERACTION)) {
            Iterator i = this.getInteractions().iterator();
            while (i.hasNext()) {
                Interaction interact = (Interaction)i.next();
                sb.append("\n");
                if (interact.getID().equals("Self")) {
                    sb.append("Self; ");
                } else {
                    sb.append(interact.getID());
                    sb.append(":");
                    sb.append(interact.getLabel());
                    if (interact.isOrganismsDiffer()) {
                        sb.append(" (xeno)");
                    }
                    sb.append("; ");
                }
                sb.append("NbExp=");
                sb.append("" + interact.getNumberExperiments());
                sb.append("; ");
                sb.append("IntAct=");
                sb.append(interact.getFirstIntActID());
                sb.append(", ");
                sb.append(interact.getSecondIntActID());
                sb.append(";");
            }
        } else if (this.getCommentType().equalsIgnoreCase(ALTERNATIVE_PRODUCTS)) {
            Iterator i = this.getEvents().iterator();
            while (i.hasNext()) {
                Event event = (Event)i.next();
                sb.append("\n");
                sb.append("Event=");
                sb.append(event.getType());
                if (event.getType().equals("Alternative splicing")) {
                    sb.append("; Named isoforms=");
                    sb.append("" + event.getNamedIsoforms());
                }
                sb.append(";\n  Comment=");
                sb.append(event.getComment());
                sb.append(";");
                if (!event.getType().equals("Alternative splicing")) continue;
                Iterator j = this.getIsoforms().iterator();
                while (j.hasNext()) {
                    int k;
                    Isoform isoform = (Isoform)j.next();
                    sb.append("\nName=");
                    sb.append(isoform.getNames().get(0));
                    sb.append("; Synonyms=");
                    for (k = 1; k < isoform.getNames().size(); ++k) {
                        sb.append(isoform.getNames().get(k));
                        if (k >= isoform.getNames().size() - 1) continue;
                        sb.append(", ");
                    }
                    sb.append(";\n  IsoId=");
                    sb.append(isoform.getIsoIDs().get(0));
                    for (k = 1; k < isoform.getIsoIDs().size(); ++k) {
                        sb.append(isoform.getIsoIDs().get(k));
                        if (k >= isoform.getIsoIDs().size() - 1) continue;
                        sb.append(", ");
                    }
                    sb.append("; Sequence=");
                    if (isoform.getSequenceRef() != null) {
                        sb.append(isoform.getSequenceRef());
                    } else {
                        sb.append(isoform.getSequenceType());
                    }
                    sb.append(";\n  Note=");
                    sb.append(isoform.getNote());
                    sb.append(";");
                }
            }
        } else if (this.getCommentType().equalsIgnoreCase(SEQUENCE_CAUTION)) {
            Iterator i = this.getSeqCautions().iterator();
            while (i.hasNext()) {
                SeqCaution seqc = (SeqCaution)i.next();
                sb.append("\n");
                sb.append("Sequence=");
                sb.append(seqc.getSequence());
                sb.append("; Type=");
                sb.append(seqc.getType());
                if (seqc.getPositions() != null) {
                    sb.append("; Positions=");
                    sb.append(seqc.getPositions());
                }
                if (this.getNote() != null) {
                    sb.append("; Note=");
                    sb.append(seqc.getNote());
                }
                sb.append(";");
            }
        } else {
            sb.append(this.getText());
            if (!this.getText().endsWith(".")) {
                sb.append(".");
            }
        }
        return sb.toString();
    }

    public String getCommentType() {
        return this.commentType;
    }

    public void setCommentType(String commentType) {
        this.commentType = commentType;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public int getMolecularWeight() {
        return this.molecularWeight;
    }

    public void setMolecularWeight(int molecularWeight) {
        this.molecularWeight = molecularWeight;
    }

    public Integer getMolWeightError() {
        return this.molWeightError;
    }

    public void setMolWeightError(Integer molWeightError) {
        this.molWeightError = molWeightError;
    }

    public int getMolWeightRangeStart() {
        return this.molWeightRangeStart;
    }

    public void setMolWeightRangeStart(int molWeightRangeStart) {
        this.molWeightRangeStart = molWeightRangeStart;
    }

    public int getMolWeightRangeEnd() {
        return this.molWeightRangeEnd;
    }

    public void setMolWeightRangeEnd(int molWeightRangeEnd) {
        this.molWeightRangeEnd = molWeightRangeEnd;
    }

    public String getMolWeightMethod() {
        return this.molWeightMethod;
    }

    public void setMolWeightMethod(String molWeightMethod) {
        this.molWeightMethod = molWeightMethod;
    }

    public List getInteractions() {
        return this.interactions;
    }

    public void setInteractions(List interactions) {
        this.interactions = interactions;
    }

    public List getSeqCautions() {
        return this.seqCautions;
    }

    public void setSeqCautions(List seqCautions) {
        this.seqCautions = seqCautions;
    }

    public List getEvents() {
        return this.events;
    }

    public void setEvents(List events) {
        this.events = events;
    }

    public List getIsoforms() {
        return this.isoforms;
    }

    public void setIsoforms(List isoforms) {
        this.isoforms = isoforms;
    }

    public String getAbsorptionMax() {
        return this.absorptionMax;
    }

    public void setAbsorptionMax(String absorptionMax) {
        this.absorptionMax = absorptionMax;
    }

    public String getAbsorptionNote() {
        return this.absorptionNote;
    }

    public void setAbsorptionNote(String absorptionNote) {
        this.absorptionNote = absorptionNote;
    }

    public List getKMs() {
        return this.KMs;
    }

    public void setKMs(List KMs) {
        this.KMs = KMs;
    }

    public List getVMaxes() {
        return this.VMaxes;
    }

    public void setVMaxes(List VMaxes) {
        this.VMaxes = VMaxes;
    }

    public String getKineticsNote() {
        return this.kineticsNote;
    }

    public void setKineticsNote(String kineticsNote) {
        this.kineticsNote = kineticsNote;
    }

    public String getPHDependence() {
        return this.PHDependence;
    }

    public void setPHDependence(String PHDependence) {
        this.PHDependence = PHDependence;
    }

    public String getRedoxPotential() {
        return this.redoxPotential;
    }

    public void setRedoxPotential(String redoxPotential) {
        this.redoxPotential = redoxPotential;
    }

    public String getTemperatureDependence() {
        return this.temperatureDependence;
    }

    public void setTemperatureDependence(String temperatureDependence) {
        this.temperatureDependence = temperatureDependence;
    }

    public static class SeqCaution {
        private String sequence;
        private String type;
        private String positions;
        private String note;

        public String getNote() {
            return this.note;
        }

        public void setNote(String note) {
            this.note = note;
        }

        public String getPositions() {
            return this.positions;
        }

        public void setPositions(String positions) {
            this.positions = positions;
        }

        public String getSequence() {
            return this.sequence;
        }

        public void setSequence(String sequence) {
            this.sequence = sequence;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class Isoform {
        private List names = new ArrayList();
        private List isoIDs = new ArrayList();
        private String sequenceType;
        private String sequenceRef;
        private String note;

        public List getNames() {
            return this.names;
        }

        public void setNames(List names) {
            this.names = names;
        }

        public List getIsoIDs() {
            return this.isoIDs;
        }

        public void setIsoIDs(List isoIDs) {
            this.isoIDs = isoIDs;
        }

        public String getSequenceType() {
            return this.sequenceType;
        }

        public void setSequenceType(String sequenceType) {
            this.sequenceType = sequenceType;
        }

        public String getSequenceRef() {
            return this.sequenceRef;
        }

        public void setSequenceRef(String sequenceRef) {
            this.sequenceRef = sequenceRef;
        }

        public String getNote() {
            return this.note;
        }

        public void setNote(String note) {
            this.note = note;
        }
    }

    public static class Event {
        private String type;
        private String comment;
        private int namedIsoforms;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public int getNamedIsoforms() {
            return this.namedIsoforms;
        }

        public void setNamedIsoforms(int namedIsoforms) {
            this.namedIsoforms = namedIsoforms;
        }
    }

    public static class Interaction {
        private String ID;
        private String label;
        private boolean organismsDiffer;
        private String firstIntActID;
        private String secondIntActID;
        private int numberExperiments;

        public String getID() {
            return this.ID;
        }

        public void setID(String ID) {
            this.ID = ID;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public boolean isOrganismsDiffer() {
            return this.organismsDiffer;
        }

        public void setOrganismsDiffer(boolean organismsDiffer) {
            this.organismsDiffer = organismsDiffer;
        }

        public String getFirstIntActID() {
            return this.firstIntActID;
        }

        public void setFirstIntActID(String firstIntActID) {
            this.firstIntActID = firstIntActID;
        }

        public String getSecondIntActID() {
            return this.secondIntActID;
        }

        public void setSecondIntActID(String secondIntActID) {
            this.secondIntActID = secondIntActID;
        }

        public int getNumberExperiments() {
            return this.numberExperiments;
        }

        public void setNumberExperiments(int numberExperiments) {
            this.numberExperiments = numberExperiments;
        }
    }
}

