/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.db;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.bio.BioEntry;
import org.biojavax.bio.db.AbstractBioEntryDB;
import org.biojavax.bio.db.BioEntryDB;

public class HashBioEntryDB
extends AbstractBioEntryDB
implements BioEntryDB {
    private final Map sequenceByID;
    private String name;

    public HashBioEntryDB() {
        this(null);
    }

    public HashBioEntryDB(String name) {
        this.name = name;
        this.sequenceByID = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public BioEntry getBioEntry(String id) throws BioException, IllegalIDException {
        BioEntry seq = (BioEntry)this.sequenceByID.get(id);
        if (seq == null) {
            throw new IllegalIDException("BioEntry with ID " + id + " could not be found");
        }
        return seq;
    }

    public BioEntryDB getBioEntrys(Set ids) throws BioException, IllegalIDException {
        return this.getBioEntrys(ids, null);
    }

    public BioEntryDB getBioEntrys(Set ids, BioEntryDB db) throws BioException, IllegalIDException {
        if (db == null) {
            db = new HashBioEntryDB();
        }
        Iterator i = ids.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            if (!this.sequenceByID.containsKey(id)) {
                throw new IllegalIDException("BioEntry with ID " + id + " could not be found");
            }
            try {
                db.addBioEntry((BioEntry)this.sequenceByID.get(id));
            }
            catch (ChangeVetoException ce) {
                throw new BioException("Unexpectedly couldn't add to a HashBioEntryDB", ce);
            }
        }
        return db;
    }

    public Set ids() {
        return this.sequenceByID.keySet();
    }

    public void addBioEntry(BioEntry seq) throws IllegalIDException, BioException, ChangeVetoException {
        this.addBioEntry(seq.getName(), seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBioEntry(String id, BioEntry seq) throws IllegalIDException, BioException, ChangeVetoException {
        if (!this.hasListeners(BioEntryDB.BIOENTRYS)) {
            this.sequenceByID.put(id, seq);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(BioEntryDB.BIOENTRYS);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, BioEntryDB.BIOENTRYS, new Object[]{id, seq}, null);
                changeSupport.firePreChangeEvent(ce);
                this.sequenceByID.put(id, seq);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBioEntry(String id) throws IllegalIDException, BioException, ChangeVetoException {
        if (!this.sequenceByID.containsKey(id)) {
            throw new IllegalIDException("BioEntry with ID " + id + " could not be found");
        }
        if (!this.hasListeners(BioEntryDB.BIOENTRYS)) {
            this.sequenceByID.remove(id);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(BioEntryDB.BIOENTRYS);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, BioEntryDB.BIOENTRYS, null, id);
                changeSupport.firePreChangeEvent(ce);
                this.sequenceByID.remove(id);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }
}

