/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.filterxml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.AnnotationType;
import org.biojava.bio.BioError;
import org.biojava.bio.CardinalityConstraint;
import org.biojava.bio.CollectionConstraint;
import org.biojava.bio.PropertyConstraint;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.xml.XMLWriter;

public class XMLAnnotationTypeWriter {
    public static final String XML_ANNOTATIONTYPE_NS = "http://www.biojava.org/AnnotationType";
    private Map constraintWritersByObject = new HashMap();
    private Map constraintWritersByClass = new HashMap();
    private Map colConstraintWritersByObject = new HashMap();
    private Map colConstraintWritersByClass = new HashMap();
    private boolean strict = false;

    public XMLAnnotationTypeWriter() {
        try {
            this.addXMLPropertyConstraintWriter(PropertyConstraint.ANY, (XMLPropertyConstraintWriter)new BlankConstraintWriter(XML_ANNOTATIONTYPE_NS, "any"));
            this.addXMLPropertyConstraintWriter(PropertyConstraint.NONE, (XMLPropertyConstraintWriter)new BlankConstraintWriter(XML_ANNOTATIONTYPE_NS, "none"));
            this.addXMLPropertyConstraintWriter(PropertyConstraint.ExactValue.class, (XMLPropertyConstraintWriter)new ExactValueConstraintWriter());
            this.addXMLPropertyConstraintWriter(PropertyConstraint.ByClass.class, (XMLPropertyConstraintWriter)new ByClassConstraintWriter());
            this.addXMLPropertyConstraintWriter(PropertyConstraint.And.class, (XMLPropertyConstraintWriter)new AndConstraintWriter());
            this.addXMLPropertyConstraintWriter(PropertyConstraint.Or.class, (XMLPropertyConstraintWriter)new OrConstraintWriter());
            this.addXMLPropertyConstraintWriter(PropertyConstraint.Enumeration.class, (XMLPropertyConstraintWriter)new EnumConstraintWriter());
            this.addXMLPropertyConstraintWriter(PropertyConstraint.ByAnnotationType.class, (XMLPropertyConstraintWriter)new AnnotationTypeConstraintWriter());
            this.addXMLCollectionConstraintWriter(CollectionConstraint.ANY, (XMLCollectionConstraintWriter)new BlankCollectionConstraintWriter(XML_ANNOTATIONTYPE_NS, "any"));
            this.addXMLCollectionConstraintWriter(CollectionConstraint.NONE, (XMLCollectionConstraintWriter)new BlankCollectionConstraintWriter(XML_ANNOTATIONTYPE_NS, "none"));
            this.addXMLCollectionConstraintWriter(CollectionConstraint.EMPTY, (XMLCollectionConstraintWriter)new BlankCollectionConstraintWriter(XML_ANNOTATIONTYPE_NS, "empty"));
            this.addXMLCollectionConstraintWriter(CollectionConstraint.And.class, (XMLCollectionConstraintWriter)new AndCollectionConstraintWriter());
            this.addXMLCollectionConstraintWriter(CollectionConstraint.Or.class, (XMLCollectionConstraintWriter)new OrCollectionConstraintWriter());
            this.addXMLCollectionConstraintWriter(CollectionConstraint.AllValuesIn.class, (XMLCollectionConstraintWriter)new AllValuesInCollectionConstraintWriter());
            this.addXMLCollectionConstraintWriter(CollectionConstraint.Contains.class, (XMLCollectionConstraintWriter)new ContainsCollectionConstraintWriter());
        }
        catch (Exception ex) {
            throw new BioError("Assertion failed: couldn't initialize XMLFilterWriters", ex);
        }
    }

    public void addXMLPropertyConstraintWriter(Class clazz, XMLPropertyConstraintWriter xfw) {
        this.constraintWritersByClass.put(clazz, xfw);
    }

    public void addXMLPropertyConstraintWriter(PropertyConstraint pc, XMLPropertyConstraintWriter xfw) {
        this.constraintWritersByObject.put(pc, xfw);
    }

    public void addXMLCollectionConstraintWriter(Class clazz, XMLCollectionConstraintWriter xfw) {
        this.colConstraintWritersByClass.put(clazz, xfw);
    }

    public void addXMLCollectionConstraintWriter(CollectionConstraint pc, XMLCollectionConstraintWriter xfw) {
        this.colConstraintWritersByObject.put(pc, xfw);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setIsStrict(boolean b) {
        this.strict = b;
    }

    private void writeCardinality(Location card, XMLWriter xw) throws IllegalArgumentException, IOException {
        if (card == CardinalityConstraint.ANY) {
            xw.openTag(XML_ANNOTATIONTYPE_NS, "cardinalityAny");
            xw.closeTag(XML_ANNOTATIONTYPE_NS, "cardinalityAny");
        } else if (card == CardinalityConstraint.ZERO) {
            xw.openTag(XML_ANNOTATIONTYPE_NS, "cardinalityZero");
            xw.closeTag(XML_ANNOTATIONTYPE_NS, "cardinalityZero");
        } else if (card == CardinalityConstraint.ONE) {
            xw.openTag(XML_ANNOTATIONTYPE_NS, "cardinalityOne");
            xw.closeTag(XML_ANNOTATIONTYPE_NS, "cardinalityOne");
        } else if (card == CardinalityConstraint.NONE) {
            xw.openTag(XML_ANNOTATIONTYPE_NS, "cardinalityNone");
            xw.closeTag(XML_ANNOTATIONTYPE_NS, "cardinalityNone");
        } else {
            xw.openTag(XML_ANNOTATIONTYPE_NS, "cardinality");
            Iterator bi = card.blockIterator();
            while (bi.hasNext()) {
                Location bloc = (Location)bi.next();
                xw.openTag("span");
                xw.attribute("start", this.intToString(bloc.getMin()));
                xw.attribute("stop", this.intToString(bloc.getMax()));
                xw.closeTag("span");
            }
            xw.closeTag(XML_ANNOTATIONTYPE_NS, "cardinality");
        }
    }

    private String intToString(int i) {
        if (i == Integer.MAX_VALUE) {
            return "infinity";
        }
        return "" + i;
    }

    void writePropertyConstraint(PropertyConstraint pc, XMLWriter xw) throws IllegalArgumentException, IOException {
        XMLPropertyConstraintWriter xpcw = (XMLPropertyConstraintWriter)this.constraintWritersByObject.get(pc);
        if (xpcw == null) {
            xpcw = (XMLPropertyConstraintWriter)this.constraintWritersByClass.get(pc.getClass());
        }
        if (xpcw == null) {
            if (this.strict) {
                throw new IllegalArgumentException("Couldn't find a writer for constraint of type " + pc.getClass().getName());
            }
            xpcw = (XMLPropertyConstraintWriter)this.constraintWritersByObject.get(PropertyConstraint.ANY);
        }
        xpcw.writePropertyConstraint(pc, xw, this);
    }

    void writeCollectionConstraint(CollectionConstraint pc, XMLWriter xw) throws IllegalArgumentException, IOException {
        XMLCollectionConstraintWriter xpcw = (XMLCollectionConstraintWriter)this.colConstraintWritersByObject.get(pc);
        if (xpcw == null) {
            xpcw = (XMLCollectionConstraintWriter)this.colConstraintWritersByClass.get(pc.getClass());
        }
        if (xpcw == null) {
            if (this.strict) {
                throw new IllegalArgumentException("Couldn't find a writer for constraint of type " + pc.getClass().getName());
            }
            xpcw = (XMLCollectionConstraintWriter)this.constraintWritersByObject.get(CollectionConstraint.ANY);
        }
        xpcw.writeCollectionConstraint(pc, xw, this);
    }

    public void writeAnnotationType(AnnotationType at, XMLWriter xw) throws IllegalArgumentException, IOException {
        xw.openTag(XML_ANNOTATIONTYPE_NS, "annotationType");
        Set propKeys = at.getProperties();
        xw.openTag(XML_ANNOTATIONTYPE_NS, "propertyDefault");
        CollectionConstraint.AllValuesIn defaultcc = (CollectionConstraint.AllValuesIn)at.getDefaultConstraint();
        this.writeCollectionConstraint(defaultcc, xw);
        xw.closeTag(XML_ANNOTATIONTYPE_NS, "propertyDefault");
        Iterator pi = propKeys.iterator();
        while (pi.hasNext()) {
            Object propKey = pi.next();
            CollectionConstraint cc = at.getConstraint(propKey);
            xw.openTag(XML_ANNOTATIONTYPE_NS, "property");
            xw.attribute(XML_ANNOTATIONTYPE_NS, "name", propKey.toString());
            this.writeCollectionConstraint(cc, xw);
            xw.closeTag(XML_ANNOTATIONTYPE_NS, "property");
        }
        xw.closeTag(XML_ANNOTATIONTYPE_NS, "annotationType");
    }

    private static class ContainsCollectionConstraintWriter
    implements XMLCollectionConstraintWriter {
        private ContainsCollectionConstraintWriter() {
        }

        public void writeCollectionConstraint(CollectionConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            CollectionConstraint.Contains cc = (CollectionConstraint.Contains)pc;
            xw.openTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "contains");
            config.writeCardinality(cc.getCardinalityConstraint(), xw);
            config.writePropertyConstraint(cc.getPropertyConstraint(), xw);
            xw.closeTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "contains");
        }
    }

    private static class AllValuesInCollectionConstraintWriter
    implements XMLCollectionConstraintWriter {
        private AllValuesInCollectionConstraintWriter() {
        }

        public void writeCollectionConstraint(CollectionConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            CollectionConstraint.AllValuesIn cc = (CollectionConstraint.AllValuesIn)pc;
            xw.openTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "allValuesIn");
            config.writeCardinality(cc.getCardinalityConstraint(), xw);
            config.writePropertyConstraint(cc.getPropertyConstraint(), xw);
            xw.closeTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "allValuesIn");
        }
    }

    private static class OrCollectionConstraintWriter
    implements XMLCollectionConstraintWriter {
        private OrCollectionConstraintWriter() {
        }

        public void writeCollectionConstraint(CollectionConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            CollectionConstraint.Or pca = (CollectionConstraint.Or)pc;
            xw.openTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "or");
            this.writeSubConstraint(pca, xw, config);
            xw.closeTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "or");
        }

        private void writeSubConstraint(CollectionConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            if (pc instanceof CollectionConstraint.Or) {
                CollectionConstraint.Or ffa = (CollectionConstraint.Or)pc;
                this.writeSubConstraint(ffa.getChild1(), xw, config);
                this.writeSubConstraint(ffa.getChild2(), xw, config);
            } else {
                config.writeCollectionConstraint(pc, xw);
            }
        }
    }

    private static class AndCollectionConstraintWriter
    implements XMLCollectionConstraintWriter {
        private AndCollectionConstraintWriter() {
        }

        public void writeCollectionConstraint(CollectionConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            CollectionConstraint.And pca = (CollectionConstraint.And)pc;
            xw.openTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "and");
            this.writeSubConstraint(pca, xw, config);
            xw.closeTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "and");
        }

        private void writeSubConstraint(CollectionConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            if (pc instanceof CollectionConstraint.And) {
                CollectionConstraint.And ffa = (CollectionConstraint.And)pc;
                this.writeSubConstraint(ffa.getChild1(), xw, config);
                this.writeSubConstraint(ffa.getChild2(), xw, config);
            } else {
                config.writeCollectionConstraint(pc, xw);
            }
        }
    }

    private static class BlankCollectionConstraintWriter
    implements XMLCollectionConstraintWriter {
        private String nsURI;
        private String localName;

        BlankCollectionConstraintWriter(String nsURI, String localName) {
            this.nsURI = nsURI;
            this.localName = localName;
        }

        public void writeCollectionConstraint(CollectionConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            xw.openTag(this.nsURI, this.localName);
            xw.closeTag(this.nsURI, this.localName);
        }
    }

    private static class AnnotationTypeConstraintWriter
    implements XMLPropertyConstraintWriter {
        private AnnotationTypeConstraintWriter() {
        }

        public void writePropertyConstraint(PropertyConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            PropertyConstraint.ByAnnotationType pcbat = (PropertyConstraint.ByAnnotationType)pc;
            config.writeAnnotationType(pcbat.getAnnotationType(), xw);
        }
    }

    private static class EnumConstraintWriter
    implements XMLPropertyConstraintWriter {
        private EnumConstraintWriter() {
        }

        public void writePropertyConstraint(PropertyConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            PropertyConstraint.Enumeration pcenum = (PropertyConstraint.Enumeration)pc;
            xw.openTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "or");
            Iterator vi = pcenum.getValues().iterator();
            while (vi.hasNext()) {
                xw.openTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "value");
                xw.print(vi.next().toString());
                xw.closeTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "value");
            }
            xw.closeTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "or");
        }
    }

    private static class OrConstraintWriter
    implements XMLPropertyConstraintWriter {
        private OrConstraintWriter() {
        }

        public void writePropertyConstraint(PropertyConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            PropertyConstraint.Or pca = (PropertyConstraint.Or)pc;
            xw.openTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "or");
            this.writeSubConstraint(pca, xw, config);
            xw.closeTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "or");
        }

        private void writeSubConstraint(PropertyConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            if (pc instanceof PropertyConstraint.Or) {
                PropertyConstraint.Or ffa = (PropertyConstraint.Or)pc;
                this.writeSubConstraint(ffa.getChild1(), xw, config);
                this.writeSubConstraint(ffa.getChild2(), xw, config);
            } else {
                config.writePropertyConstraint(pc, xw);
            }
        }
    }

    private static class AndConstraintWriter
    implements XMLPropertyConstraintWriter {
        private AndConstraintWriter() {
        }

        public void writePropertyConstraint(PropertyConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            PropertyConstraint.And pca = (PropertyConstraint.And)pc;
            xw.openTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "and");
            this.writeSubConstraint(pca, xw, config);
            xw.closeTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "and");
        }

        private void writeSubConstraint(PropertyConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            if (pc instanceof PropertyConstraint.And) {
                PropertyConstraint.And ffa = (PropertyConstraint.And)pc;
                this.writeSubConstraint(ffa.getChild1(), xw, config);
                this.writeSubConstraint(ffa.getChild2(), xw, config);
            } else {
                config.writePropertyConstraint(pc, xw);
            }
        }
    }

    private static class ByClassConstraintWriter
    implements XMLPropertyConstraintWriter {
        private ByClassConstraintWriter() {
        }

        public void writePropertyConstraint(PropertyConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            PropertyConstraint.ByClass pcev = (PropertyConstraint.ByClass)pc;
            xw.openTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "byClass");
            xw.print(pcev.getPropertyClass().getName());
            xw.closeTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "byClass");
        }
    }

    private static class ExactValueConstraintWriter
    implements XMLPropertyConstraintWriter {
        private ExactValueConstraintWriter() {
        }

        public void writePropertyConstraint(PropertyConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            PropertyConstraint.ExactValue pcev = (PropertyConstraint.ExactValue)pc;
            xw.openTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "value");
            xw.print(pcev.getValue().toString());
            xw.closeTag(XMLAnnotationTypeWriter.XML_ANNOTATIONTYPE_NS, "value");
        }
    }

    private static class BlankConstraintWriter
    implements XMLPropertyConstraintWriter {
        private String nsURI;
        private String localName;

        BlankConstraintWriter(String nsURI, String localName) {
            this.nsURI = nsURI;
            this.localName = localName;
        }

        public void writePropertyConstraint(PropertyConstraint pc, XMLWriter xw, XMLAnnotationTypeWriter config) throws ClassCastException, IllegalArgumentException, IOException {
            xw.openTag(this.nsURI, this.localName);
            xw.closeTag(this.nsURI, this.localName);
        }
    }

    public static interface XMLPropertyConstraintWriter {
        public void writePropertyConstraint(PropertyConstraint var1, XMLWriter var2, XMLAnnotationTypeWriter var3) throws ClassCastException, IOException, IllegalArgumentException;
    }

    public static interface XMLCollectionConstraintWriter {
        public void writeCollectionConstraint(CollectionConstraint var1, XMLWriter var2, XMLAnnotationTypeWriter var3) throws ClassCastException, IOException, IllegalArgumentException;
    }
}

