/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.seq.db.HashSequenceDB;
import org.biojava.bio.seq.db.SequenceDBInstallation;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.utils.ObjectUtil;

public class SimpleSequenceDBInstallation
implements SequenceDBInstallation {
    private Map sequenceDBByIdentifier = new HashMap();

    public synchronized void addSequenceDB(String name, Set otherIdentifiers) {
        if (name == null) {
            throw new IllegalArgumentException("name was null");
        }
        HashSet<String> allIdentifiers = new HashSet<String>();
        allIdentifiers.add(name);
        if (otherIdentifiers != null) {
            allIdentifiers.addAll(otherIdentifiers);
        }
        Set currentIdentifiers = this.sequenceDBByIdentifier.keySet();
        Iterator i = allIdentifiers.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof String)) {
                throw new IllegalArgumentException("otherIdentifiers must be a Set of String objects");
            }
            if (!currentIdentifiers.contains(o)) continue;
            throw new IllegalArgumentException("name and otherIdentifiers must not already be in use");
        }
        HashSequenceDB db = new HashSequenceDB(name);
        Iterator i2 = allIdentifiers.iterator();
        while (i2.hasNext()) {
            String identifier = (String)i2.next();
            this.sequenceDBByIdentifier.put(identifier, db);
        }
    }

    public synchronized void addSequenceDB(SequenceDBLite sequenceDB, Set otherIdentifiers) {
        if (sequenceDB == null) {
            throw new IllegalArgumentException("SequenceDB was null");
        }
        String name = sequenceDB.getName();
        HashSet<String> allIdentifiers = new HashSet<String>();
        allIdentifiers.add(name);
        if (otherIdentifiers != null) {
            allIdentifiers.addAll(otherIdentifiers);
        }
        Set currentIdentifiers = this.sequenceDBByIdentifier.keySet();
        Iterator i = allIdentifiers.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof String)) {
                throw new IllegalArgumentException("otherIdentifiers must be a set of String objects");
            }
            if (!currentIdentifiers.contains(o)) continue;
            throw new IllegalArgumentException("name and otherIdentifiers must not already be in use");
        }
        i = allIdentifiers.iterator();
        while (i.hasNext()) {
            String identifier = (String)i.next();
            this.sequenceDBByIdentifier.put(identifier, sequenceDB);
        }
    }

    public synchronized Set getSequenceDBs() {
        HashSet allDBs = new HashSet();
        allDBs.addAll(this.sequenceDBByIdentifier.values());
        return allDBs;
    }

    public synchronized SequenceDBLite getSequenceDB(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("identifier was null");
        }
        return (SequenceDBLite)this.sequenceDBByIdentifier.get(identifier);
    }

    public String toString() {
        return "SimpleSequenceDBInstallation: " + this.sequenceDBByIdentifier.values();
    }

    public synchronized boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        SimpleSequenceDBInstallation that = (SimpleSequenceDBInstallation)o;
        return ObjectUtil.equals(this.sequenceDBByIdentifier, that.sequenceDBByIdentifier);
    }

    public synchronized int hashCode() {
        int hc = 0;
        hc = ObjectUtil.hashCode(hc, this.sequenceDBByIdentifier);
        return hc;
    }

    public static void main(String[] args) {
        System.out.println("Create sequence db installation");
        SimpleSequenceDBInstallation dbInst = new SimpleSequenceDBInstallation();
        System.out.println("Sequence db installation serves " + dbInst.getSequenceDBs().size() + " sequence dbs");
        System.out.println("add swissprot (aka sprot, sp) and genbank (aka gb) do sequence db installation");
        HashSet<String> swissprotIDs = new HashSet<String>();
        swissprotIDs.add("sprot");
        swissprotIDs.add("sp");
        dbInst.addSequenceDB("swissprot", swissprotIDs);
        HashSet<String> genbankIDs = new HashSet<String>();
        genbankIDs.add("gb");
        genbankIDs.add("genbank");
        dbInst.addSequenceDB("genbank", genbankIDs);
        System.out.println("Sequence db installation serves " + dbInst.getSequenceDBs().size() + " sequence dbs");
        System.out.println("Sequence db associated with identifier \"sprot\" is: " + dbInst.getSequenceDB("sprot"));
        System.out.println("Sequence db associated with identifier \"swissprot\" is: " + dbInst.getSequenceDB("swissprot"));
        System.out.println("Sequence db associated with identifier \"sp\" is: " + dbInst.getSequenceDB("sp"));
        System.out.println("Sequence db associated with identifier \"willi\" is: " + dbInst.getSequenceDB("willi"));
        System.out.println("Sequence db associated with identifier \"gb\" is: " + dbInst.getSequenceDB("gb"));
        System.out.println("Sequence db associated with identifier \"genbank\" is: " + dbInst.getSequenceDB("genbank"));
        System.out.println("Sequence db associated with identifier \"genebank\" is: " + dbInst.getSequenceDB("genebank"));
    }
}

