/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.search.BlastLikeSearchFilter;
import org.biojava.bio.search.SearchContentAdapter;
import org.biojava.bio.search.SearchContentHandler;
import org.biojava.utils.TriState;
import org.biojava.utils.walker.Visitor;
import org.biojava.utils.walker.Walker;
import org.biojava.utils.walker.WalkerFactory;

public class FilteringContentHandler
extends SearchContentAdapter
implements BlastLikeSearchFilter.Node {
    private Map searchProperty = new HashMap();
    private Map hitProperty = new HashMap();
    private Map subHitProperty = new HashMap();
    private List searchFilters = new ArrayList();
    private List hitFilters = new ArrayList();
    private List subHitFilters = new ArrayList();
    private boolean emittedStartSearch;
    private boolean emittedStartHit;
    private boolean skipHits = false;
    private boolean skipSubHits = false;
    private boolean firstSubHit = true;
    private boolean firstHit = true;
    private static final WalkerFactory walkerFactory = WalkerFactory.getInstance(BlastLikeSearchFilter.class);
    private BlastLikeSearchFilter filter;
    private SearchContentHandler delegate;

    public Object getSearchProperty(Object key) {
        return this.searchProperty.get(key);
    }

    public Object getHitProperty(Object key) {
        return this.hitProperty.get(key);
    }

    public Object getSubHitProperty(Object key) {
        return this.subHitProperty.get(key);
    }

    public FilteringContentHandler(BlastLikeSearchFilter filter, SearchContentHandler delegate) throws BioException {
        this.construct(filter);
        this.setSearchContentHandler(delegate);
    }

    public FilteringContentHandler(BlastLikeSearchFilter filter) throws BioException {
        this.construct(filter);
    }

    private void construct(BlastLikeSearchFilter filter) throws BioException {
        this.filter = filter;
        FilterVisitor visitor = new FilterVisitor();
        Walker walker = walkerFactory.getWalker(visitor);
        walker.walk(filter, visitor);
    }

    public void setSearchContentHandler(SearchContentHandler delegate) {
        this.delegate = delegate;
    }

    public void startHeader() {
        this.delegate.startHeader();
    }

    public void setDatabaseID(String id) {
        this.delegate.setDatabaseID(id);
    }

    public void endHeader() {
        this.delegate.endHeader();
    }

    public void startSearch() {
        this.emittedStartSearch = false;
        this.firstHit = true;
    }

    public void setQueryID(String queryID) {
        this.addSearchProperty("___QUERY_ID___", queryID);
    }

    public void addSearchProperty(Object key, Object value) {
        this.searchProperty.put(key, value);
    }

    public void startHit() {
        this.emittedStartHit = false;
        this.firstSubHit = true;
        if (this.firstHit) {
            Iterator searchFilterI = this.searchFilters.iterator();
            while (searchFilterI.hasNext()) {
                BlastLikeSearchFilter sf = (BlastLikeSearchFilter)searchFilterI.next();
                sf.evaluate(this);
            }
            TriState filterStatus = this.filter.accept();
            if (filterStatus == TriState.FALSE) {
                this.skipHits = true;
                this.skipSubHits = true;
            }
            this.firstHit = false;
        }
    }

    public void addHitProperty(Object key, Object value) {
        if (this.skipHits) {
            return;
        }
        this.hitProperty.put(key, value);
    }

    public void startSubHit() {
        BlastLikeSearchFilter sf;
        if (this.skipSubHits) {
            return;
        }
        Iterator subHitFilterI = this.hitFilters.iterator();
        while (subHitFilterI.hasNext()) {
            sf = (BlastLikeSearchFilter)subHitFilterI.next();
            sf.reset();
        }
        if (this.firstSubHit) {
            Iterator hitFilterI = this.hitFilters.iterator();
            while (hitFilterI.hasNext()) {
                sf = (BlastLikeSearchFilter)hitFilterI.next();
                sf.evaluate(this);
            }
            TriState filterStatus = this.filter.accept();
            if (filterStatus == TriState.FALSE) {
                this.skipSubHits = true;
            }
            this.firstSubHit = false;
        }
    }

    public void addSubHitProperty(Object key, Object value) {
        if (this.skipSubHits) {
            return;
        }
        this.subHitProperty.put(key, value);
    }

    public void endSubHit() {
        if (!this.skipSubHits) {
            Iterator subHitFilterI = this.subHitFilters.iterator();
            while (subHitFilterI.hasNext()) {
                BlastLikeSearchFilter sf = (BlastLikeSearchFilter)subHitFilterI.next();
                sf.evaluate(this);
            }
            if (this.filter.accept() == TriState.TRUE) {
                Map.Entry entry;
                if (!this.emittedStartSearch) {
                    this.delegate.startSearch();
                    String queryId = (String)this.searchProperty.get("___QUERY_ID___");
                    if (queryId != null) {
                        this.delegate.setQueryID(queryId);
                    }
                    Iterator searchPropertyI = this.searchProperty.entrySet().iterator();
                    while (searchPropertyI.hasNext()) {
                        Map.Entry entry2 = searchPropertyI.next();
                        if ("___QUERY_ID___".equals(entry2.getKey())) continue;
                        this.delegate.addSearchProperty(entry2.getKey(), entry2.getValue());
                    }
                    this.emittedStartSearch = true;
                }
                if (!this.emittedStartHit) {
                    this.delegate.startHit();
                    Iterator hitPropertyI = this.hitProperty.entrySet().iterator();
                    while (hitPropertyI.hasNext()) {
                        entry = hitPropertyI.next();
                        this.delegate.addSearchProperty(entry.getKey(), entry.getValue());
                    }
                    this.emittedStartHit = true;
                }
                this.delegate.startSubHit();
                Iterator subHitPropertyI = this.subHitProperty.entrySet().iterator();
                while (subHitPropertyI.hasNext()) {
                    entry = subHitPropertyI.next();
                    this.delegate.addSearchProperty(entry.getKey(), entry.getValue());
                }
                this.delegate.endSubHit();
            }
        }
    }

    public void endHit() {
        if (this.emittedStartHit) {
            this.delegate.endHit();
            this.emittedStartHit = false;
        }
    }

    public void endSearch() {
        if (this.emittedStartSearch) {
            this.delegate.endSearch();
            this.emittedStartSearch = false;
        }
    }

    public class FilterVisitor
    implements Visitor {
        public void bySearchProperty(BlastLikeSearchFilter.BySearchProperty sf) {
            FilteringContentHandler.this.searchFilters.add(sf);
        }

        public void byHitProperty(BlastLikeSearchFilter.ByHitProperty sf) {
            FilteringContentHandler.this.hitFilters.add(sf);
        }

        public void bySubHitProperty(BlastLikeSearchFilter.BySubHitProperty sf) {
            FilteringContentHandler.this.subHitFilters.add(sf);
        }
    }
}

