/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class BlastLikeAlignmentSAXParser
extends AbstractNativeAppSAXParser {
    private AttributesImpl oAtts = new AttributesImpl();
    private QName oAttQName = new QName(this);
    private char[] aoChars;
    private ArrayList oAlignment;
    private String oLine;
    private String oSeq;
    private StringBuffer oQuery = new StringBuffer();
    private StringBuffer oHit = new StringBuffer();
    private StringBuffer oMatchConsensus = new StringBuffer();
    private StringBuffer oStartId = new StringBuffer();
    private StringBuffer oStopId = new StringBuffer();
    private StringBuffer oHitStartId = new StringBuffer();
    private StringBuffer oHitStopId = new StringBuffer();
    private StringBuffer oQueryStartId = new StringBuffer();
    private StringBuffer oQueryStopId = new StringBuffer();
    private StringTokenizer oSt;
    private String oParsedSeq;
    private int iOffset;
    private int iEnd;
    private boolean tJustDoneConsensus;
    private static final int STARTUP = 0;
    private static final int ON_FIRST_SEGMENT = 1;
    private static final int DONE_FIRST_SEGMENT = 2;

    public BlastLikeAlignmentSAXParser(String poNamespacePrefix) {
        this.changeState(0);
        this.setNamespacePrefix(poNamespacePrefix);
        this.addPrefixMapping("biojava", "http://www.biojava.org");
    }

    public void parse(ArrayList poAlignment) throws SAXException {
        this.oAlignment = poAlignment;
        this.oAtts.clear();
        this.startElement(new QName(this, this.prefix("BlastLikeAlignment")), this.oAtts);
        this.changeState(1);
        this.oQuery.setLength(0);
        this.oQueryStartId.setLength(0);
        this.oQueryStopId.setLength(0);
        this.oHit.setLength(0);
        this.oHitStartId.setLength(0);
        this.oHitStopId.setLength(0);
        this.oMatchConsensus.setLength(0);
        this.tJustDoneConsensus = false;
        int iAlSize = this.oAlignment.size();
        for (int i = 0; i < iAlSize; ++i) {
            this.oLine = (String)this.oAlignment.get(i);
            this.parseLine(this.oLine);
        }
        this.oAtts.clear();
        this.oAttQName.setQName("startPosition");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oQueryStartId.substring(0));
        this.oAttQName.setQName("stopPosition");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oQueryStopId.substring(0));
        this.startElement(new QName(this, this.prefix("QuerySequence")), this.oAtts);
        this.aoChars = this.oQuery.substring(0).toCharArray();
        this.characters(this.aoChars, 0, this.aoChars.length);
        this.endElement(new QName(this, this.prefix("QuerySequence")));
        this.oAtts.clear();
        this.oAttQName.setQName("xml:space");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "NMTOKEN", "preserve");
        this.startElement(new QName(this, this.prefix("MatchConsensus")), this.oAtts);
        this.aoChars = this.oMatchConsensus.substring(0).toCharArray();
        this.characters(this.aoChars, 0, this.aoChars.length);
        this.endElement(new QName(this, this.prefix("MatchConsensus")));
        this.oAtts.clear();
        this.oAttQName.setQName("startPosition");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oHitStartId.substring(0));
        this.oAttQName.setQName("stopPosition");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oHitStopId.substring(0));
        this.startElement(new QName(this, this.prefix("HitSequence")), this.oAtts);
        this.aoChars = this.oHit.substring(0).toCharArray();
        this.characters(this.aoChars, 0, this.aoChars.length);
        this.endElement(new QName(this, this.prefix("HitSequence")));
        this.endElement(new QName(this, this.prefix(this.prefix("BlastLikeAlignment"))));
    }

    private void parseLine(String poLine) throws SAXException {
        if ((poLine = poLine.toUpperCase()).startsWith("QUERY:") || poLine.startsWith("SBJCT:")) {
            this.oSt = new StringTokenizer(poLine, ":");
            if (this.oSt.countTokens() != 2) {
                throw new SAXException("Failed to parse a line in a BlastLikeAlignment due it having an unexpected format. The line is shown below.\n" + poLine);
            }
            this.oSt.nextToken();
            this.oSeq = this.oSt.nextToken().trim();
            this.oSt = new StringTokenizer(this.oSeq, " ABCDEFGHIJKLMNOPQRSTUVWXYZ-*");
            if (this.oSt.countTokens() != 2) {
                throw new SAXException("Failed to parse a line of an alignment due to it having an unexpected character.");
            }
            this.oStartId.setLength(0);
            this.oStartId.append(this.oSt.nextToken().trim());
            this.oStopId.setLength(0);
            this.oStopId.append(this.oSt.nextToken().trim());
            this.oSt = new StringTokenizer(this.oSeq, "0123456789");
            if (this.oSt.countTokens() != 1) {
                throw new SAXException("Failed to parse a line of an alignment due to it having an unexpected character.");
            }
            this.oParsedSeq = this.oSt.nextToken().trim();
            this.iOffset = poLine.indexOf(this.oParsedSeq);
            this.iEnd = this.iOffset + this.oParsedSeq.length();
        } else if (this.iEnd <= poLine.length()) {
            this.oParsedSeq = poLine.substring(this.iOffset, this.iEnd);
        } else {
            int iLen = this.iEnd - poLine.length();
            char[] oPadding = new char[iLen];
            Arrays.fill(oPadding, 0, iLen, ' ');
            this.oParsedSeq = poLine.substring(this.iOffset).concat(new String(oPadding));
        }
        if (this.iState == 1) {
            if (poLine.startsWith("QUERY:")) {
                this.oQueryStartId.append(this.oStartId);
                this.oQueryStopId.append(this.oStopId);
                this.oQuery.append(this.oParsedSeq);
                this.tJustDoneConsensus = false;
                return;
            }
            if (poLine.startsWith("SBJCT:")) {
                this.oHitStartId.append(this.oStartId);
                this.oHitStopId.append(this.oStopId);
                this.oHit.append(this.oParsedSeq);
                if (!this.tJustDoneConsensus) {
                    char[] oPadding = new char[this.iEnd - this.iOffset];
                    Arrays.fill(oPadding, 0, this.iEnd - this.iOffset, ' ');
                    this.oMatchConsensus.append(new String(oPadding));
                }
                this.tJustDoneConsensus = false;
                this.changeState(2);
                return;
            }
            this.oMatchConsensus.append(this.oParsedSeq);
            this.tJustDoneConsensus = true;
        }
        if (this.iState == 2) {
            if (poLine.startsWith("QUERY:")) {
                this.oQueryStopId.setLength(0);
                this.oQueryStopId.append(this.oStopId);
                this.oQuery.append(this.oParsedSeq);
                this.tJustDoneConsensus = false;
                return;
            }
            if (poLine.startsWith("SBJCT:")) {
                this.oHitStopId.setLength(0);
                this.oHitStopId.append(this.oStopId);
                this.oHit.append(this.oParsedSeq);
                if (!this.tJustDoneConsensus) {
                    char[] oPadding = new char[this.iEnd - this.iOffset];
                    Arrays.fill(oPadding, 0, this.iEnd - this.iOffset, ' ');
                    this.oMatchConsensus.append(new String(oPadding));
                }
                this.tJustDoneConsensus = false;
                return;
            }
            this.oMatchConsensus.append(this.oParsedSeq);
            this.tJustDoneConsensus = true;
            return;
        }
    }
}

