package org.pathwaycommons.trans.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;

import org.jdom.Element;

import org.genemania.dw.util.GenUtil;
import org.genemania.dw.util.DefParams;

/**
 * Generates basic stats (supports elements and attributes only) and listing of
 * elements that are actually used in an xml file. The stats generator
 * intentionally iterates more than it should to double check sanity of xml.
 *
 * @author rashadbadrawi
 */

public class XMLStats {

    private static final String DEF_STATS_FILE_NAME = "XMLStats.txt";
    private static PrintWriter log = GenUtil.getDefaultLog();

    private String inputPathName;

    public XMLStats () {}

    public void setInputPathName (String inputPathName) {

        GenUtil.validateString(inputPathName);
        this.inputPathName = inputPathName;
    }

    public String getInputPathName () { return inputPathName; }

    public void generateStats () throws Exception {

        File sourceFileOrDir = new File (getInputPathName());
        if (sourceFileOrDir.isFile ()) {
            String fileName = sourceFileOrDir.getAbsolutePath();
            System.out.print("Stats for: " + fileName);
            Element rootElement = XMLUtil.readSchemaBasedXML(fileName);
            generateStats (rootElement, fileName);
            rootElement = null;                         //attempt cleaning up
            System.gc();
        } else {            //} else if (sourceFileOrDir.isDirectory () {
            File filesArr [] = sourceFileOrDir.listFiles();
            int cnt = 1;
            for (int i = 0; i < filesArr.length; i++) {
                //if (!filesArr [i].getAbsolutePath().endsWith(XMLUtil.XML_FILE_SUFFIX)) {
                if (!filesArr [i].getAbsolutePath().contains (XMLUtil.XML_FILE_SUFFIX)) {
                    continue;
                }
                System.out.println("Stats for: " + cnt++ + " " + filesArr [i]);
                Element rootElement = XMLUtil.readSchemaBasedXML(
                                      filesArr [i].getAbsolutePath());
                generateStats (rootElement, filesArr [i].getAbsolutePath());
                rootElement = null;                     //attempt cleaning up
                System.gc();
           }
        }
    }

    public void generateStats(Element rootElement, String fileName) {

        new XMLElementInfo (rootElement, fileName);
        ArrayList<Element> childrenList = new ArrayList<Element> (rootElement.getChildren());
        for (int i = 0; i < childrenList.size(); i++) {
            generateStats(childrenList.get(i), fileName);
        }
    }

    public void dumpStats() throws IOException {

        File outputFile = new File (DefParams.getDefaultProp(DefParams.TOOLS_PATH_PROP),
                                    XMLStats.DEF_STATS_FILE_NAME);
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
        Iterator iterator = XMLElementInfo.getAll ().keySet().iterator();
        System.out.println("Total num of unique elements: " + XMLElementInfo.getAll ().size());
        System.out.println("Dumping all unique elements...");
        bw.write (XMLElementInfo.getHeaders());
        bw.newLine ();
        while (iterator.hasNext()) {
            XMLElementInfo xei = XMLElementInfo.getAll ().get ((String)iterator.next());
            bw.write(xei.toString());
            bw.newLine();
        }
        bw.flush ();
        bw.close ();
        System.out.println("Done...");
    }

    public static void main(String args[]) {

        log = GenUtil.getDefaultLog();
        log.println(GenUtil.getTimeStamp());
        GenUtil.registerStart();
        String usageMsg = "Usage: XMLStats inputpath";
        String warnMsg = "WARNING: Missing command line args, using defaults";
        if (args == null || args.length < 1) {
            log.println(warnMsg);
            log.println(usageMsg);
            System.out.println(warnMsg);
            System.out.println(usageMsg);
            args = DefParams.getCommandLineArgs(XMLStats.class.getName());
        }
        try {
            XMLStats xmlStats = new XMLStats ();
            xmlStats.setInputPathName(args [0]);
            xmlStats.generateStats();
            xmlStats.dumpStats();
        } catch (Throwable e) {
            e.printStackTrace();
            e.printStackTrace(log);
        } finally {
            log.println(GenUtil.getExecTimeStr());
            log.flush();
            log.close();
        }
    }
}
