/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFilterSet<E>
extends AbstractSet<E> {
    Log log = LogFactory.getLog(AbstractFilterSet.class);
    Set baseSet;

    protected AbstractFilterSet(Set baseSet) {
        this.baseSet = baseSet;
    }

    @Override
    public int size() {
        int i = 0;
        for (E e : this) {
            ++i;
        }
        return i;
    }

    @Override
    public boolean contains(Object o) {
        return this.filter(o) && this.baseSet.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new FilterIterator(this.baseSet.iterator());
    }

    protected abstract boolean filter(Object var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterIterator<E>
    implements Iterator<E> {
        E next = null;
        Iterator base;

        public FilterIterator(Iterator base) {
            this.base = base;
            this.fetchNext();
        }

        private void fetchNext() {
            this.next = null;
            while (this.base.hasNext()) {
                Object check = this.base.next();
                if (!AbstractFilterSet.this.filter(check)) continue;
                try {
                    this.next = check;
                    break;
                }
                catch (ClassCastException ce) {
                    AbstractFilterSet.this.log.error((Object)"wrong use of filter set. Skipping.", (Throwable)ce);
                    return;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                E value = this.next;
                this.fetchNext();
                return value;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

