/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level2;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionRule;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.InteractionParticipant;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.interaction;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticipatesRule
implements InteractionRule {
    @Override
    public void inferInteractions(Set<SimpleInteraction> interactionSet, physicalEntity pe, Model model, Map options) {
        boolean skipInteractions;
        boolean skipConversions = options.containsKey((Object)BinaryInteractionType.PARTICIPATES_CONVERSION) && options.get((Object)BinaryInteractionType.PARTICIPATES_CONVERSION).equals(false);
        boolean bl = skipInteractions = options.containsKey((Object)BinaryInteractionType.PARTICIPATES_INTERACTION) && options.get((Object)BinaryInteractionType.PARTICIPATES_INTERACTION).equals(false);
        if (skipConversions && skipInteractions) {
            return;
        }
        Set<interaction> interactions = pe.getAllInteractions();
        for (interaction interaction2 : interactions) {
            BinaryInteractionType type;
            if (interaction2 instanceof control) {
                return;
            }
            if (interaction2 instanceof conversion) {
                if (skipConversions) continue;
                type = BinaryInteractionType.PARTICIPATES_CONVERSION;
            } else {
                if (skipInteractions) continue;
                type = BinaryInteractionType.PARTICIPATES_INTERACTION;
            }
            Set<InteractionParticipant> ips = interaction2.getPARTICIPANTS();
            for (InteractionParticipant ip : ips) {
                this.processParticipant(interactionSet, pe, ip, type);
            }
        }
    }

    private void processParticipant(Set<SimpleInteraction> interactionSet, physicalEntity pe, InteractionParticipant ip, BinaryInteractionType type) {
        physicalEntity pe2 = null;
        if (ip instanceof physicalEntity) {
            pe2 = (physicalEntity)ip;
        } else if (ip instanceof physicalEntityParticipant) {
            pe2 = ((physicalEntityParticipant)ip).getPHYSICAL_ENTITY();
        }
        if (pe2 != null) {
            this.createInteraction(pe, pe2, interactionSet, type);
        }
    }

    private void createInteraction(physicalEntity pe, physicalEntity pe2, Set<SimpleInteraction> set, BinaryInteractionType type) {
        if (!pe2.equals(pe)) {
            set.add(new SimpleInteraction(pe, pe2, type));
        }
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return Arrays.asList(BinaryInteractionType.PARTICIPATES_CONVERSION, BinaryInteractionType.PARTICIPATES_INTERACTION);
    }
}

