/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.impl.level3.L3ElementImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SequenceLocation;
import org.biopax.paxtools.util.BidirectionalLinkViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntityFeatureImpl
extends L3ElementImpl
implements EntityFeature {
    private Set<Evidence> evidence = new HashSet<Evidence>();
    private EntityReference ownerEntityReference;
    private Set<PhysicalEntity> featuredEntities = new HashSet<PhysicalEntity>();
    private Set<PhysicalEntity> notFeaturedEntities = new HashSet<PhysicalEntity>();
    private Set<SequenceLocation> featureLocation = new HashSet<SequenceLocation>();

    @Override
    public Class<? extends BioPAXElement> getModelInterface() {
        return EntityFeature.class;
    }

    @Override
    public EntityReference isEntityFeatureOf() {
        return this.ownerEntityReference;
    }

    @Override
    public void setEntityFeatureOf(EntityReference newEntityReference) {
        if (this.ownerEntityReference == null) {
            this.ownerEntityReference = newEntityReference;
        } else {
            if (this.ownerEntityReference.getEntityFeature().contains(this)) {
                throw new BidirectionalLinkViolationException(this, this.ownerEntityReference);
            }
            this.ownerEntityReference = newEntityReference;
        }
    }

    @Override
    public Set<PhysicalEntity> isFeatureOf() {
        return this.featuredEntities;
    }

    @Override
    public Set<PhysicalEntity> isNoFeatureOf() {
        return this.notFeaturedEntities;
    }

    @Override
    public Set<Evidence> getEvidence() {
        return this.evidence;
    }

    @Override
    public void addEvidence(Evidence evidence2) {
        this.evidence.add(evidence2);
    }

    @Override
    public void removeEvidence(Evidence evidence2) {
        this.evidence.remove(evidence2);
    }

    @Override
    public void setEvidence(Set<Evidence> evidence2) {
        this.evidence = evidence2;
    }

    @Override
    public Set<SequenceLocation> getFeatureLocation() {
        return this.featureLocation;
    }

    @Override
    public void addFeatureLocation(SequenceLocation featureLocation) {
        this.featureLocation.add(featureLocation);
    }

    @Override
    public void removeFeatureLocation(SequenceLocation featureLocation) {
        this.featureLocation.remove(featureLocation);
    }

    @Override
    public void setFeatureLocation(Set<SequenceLocation> featureLocation) {
        this.featureLocation = featureLocation;
    }
}

