/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;

public class Traverser {
    EditorMap editorMap;
    Visitor visitor;

    public Traverser(EditorMap editorMap, Visitor visitor) {
        this.editorMap = editorMap;
        this.visitor = visitor;
    }

    public void traverse(BioPAXElement element, Model model) {
        Set<PropertyEditor> editors = this.editorMap.getEditorsOf(element);
        for (PropertyEditor editor : editors) {
            if (!(editor instanceof ObjectPropertyEditor)) continue;
            if (editor.isMultipleCardinality()) {
                HashSet valueSet = new HashSet((Collection)editor.getValueFromBean(element));
                for (BioPAXElement value : valueSet) {
                    this.visitor.visit(value, model, editor);
                }
                continue;
            }
            BioPAXElement value = (BioPAXElement)editor.getValueFromBean(element);
            this.visitor.visit(value, model, editor);
        }
    }
}

