/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.util.AbstractFilterSet;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditorMapAdapter
implements EditorMap {
    protected HashMap<String, Set<PropertyEditor>> propertyToEditorMap = new HashMap();
    protected HashMap<Class<? extends BioPAXElement>, Set<PropertyEditor>> classToEditorMap = new HashMap();
    protected BioPAXLevel level;
    private static Log log = LogFactory.getLog(EditorMapAdapter.class);

    public EditorMapAdapter(BioPAXLevel level) {
        this.level = level != null ? level : BioPAXLevel.L2;
    }

    public EditorMapAdapter() {
        this(null);
    }

    @Override
    public Set<PropertyEditor> getEditorsOf(BioPAXElement bpe) {
        return this.classToEditorMap.get(bpe.getModelInterface());
    }

    @Override
    public PropertyEditor getEditorForProperty(String property, Class javaClass) {
        PropertyEditor result = null;
        Set<PropertyEditor> editors = this.getEditorsForProperty(property);
        if (editors != null) {
            for (PropertyEditor editor : editors) {
                if (!editor.getDomain().isAssignableFrom(javaClass)) continue;
                result = editor;
                break;
            }
        }
        if (result == null) {
            log.error((Object)("Could not locate controller for " + property + " | " + javaClass));
        }
        return result;
    }

    @Override
    public Set<PropertyEditor> getEditorsForProperty(String property) {
        return this.propertyToEditorMap.get(property);
    }

    @Override
    public Set<Class> getKnownSubClassesOf(Class javaClass) {
        return new SubClassFilterSet(this.classToEditorMap.keySet(), javaClass);
    }

    @Override
    public BioPAXLevel getLevel() {
        return this.level;
    }

    protected boolean isInBioPAXNameSpace(String nameSpace) {
        return nameSpace != null && nameSpace.startsWith("http://www.biopax.org/release/");
    }

    protected Class<? extends BioPAXElement> getModelInterface(String localName) {
        try {
            Class<?> modelInterface = Class.forName(this.level.getPackageName() + "." + localName);
            if (BioPAXElement.class.isAssignableFrom(modelInterface)) {
                return modelInterface;
            }
            throw new IllegalBioPAXArgumentException("Could not locate interface for:" + localName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalBioPAXArgumentException("Could not locate interface for:" + localName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubClassFilterSet
    extends AbstractFilterSet<Class> {
        private Class filterClass;

        public SubClassFilterSet(Set<? extends Class> baseSet, Class filterClass) {
            super(baseSet);
            this.filterClass = null;
            this.filterClass = filterClass;
        }

        @Override
        protected boolean filter(Object value) {
            return this.filterClass.isAssignableFrom((Class)value);
        }
    }
}

