/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.simpleIO;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EditorMapAdapter;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;

public class SimpleEditorMap
extends EditorMapAdapter {
    private static Log log = LogFactory.getLog(EditorMapAdapter.class);

    public SimpleEditorMap() {
        this(null);
    }

    public SimpleEditorMap(BioPAXLevel level) {
        super(level);
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("Level" + level.getValue() + "Editor.properties")));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                HashSet<PropertyEditor> editors;
                StringTokenizer st = new StringTokenizer(line);
                String bean = st.nextToken();
                String domain = st.nextToken();
                String propertyName = st.nextToken();
                Class<? extends BioPAXElement> beanInterface = this.getModelInterface(bean);
                Class<? extends BioPAXElement> domainClass = this.getModelInterface(domain);
                PropertyEditor editor = null;
                HashSet<PropertyEditor> propertyEditors = (HashSet<PropertyEditor>)this.propertyToEditorMap.get(propertyName);
                if (propertyEditors == null) {
                    propertyEditors = new HashSet<PropertyEditor>();
                    this.propertyToEditorMap.put(propertyName, propertyEditors);
                } else {
                    for (PropertyEditor candidate : propertyEditors) {
                        if (!candidate.getDomain().equals(domainClass)) continue;
                        editor = candidate;
                        break;
                    }
                }
                if (editor == null) {
                    editor = PropertyEditor.createPropertyEditor(domainClass, propertyName);
                    propertyEditors.add(editor);
                }
                if ((editors = (HashSet<PropertyEditor>)this.classToEditorMap.get(beanInterface)) == null) {
                    editors = new HashSet<PropertyEditor>();
                    this.classToEditorMap.put(beanInterface, editors);
                }
                editors.add(editor);
            }
        }
        catch (IOException e) {
            log.error((Object)"Could not initialize Commander Map", (Throwable)e);
        }
    }
}

