/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level2;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionRule;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.ControlType;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.process;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlsTogetherRule
implements InteractionRule {
    private boolean mineDepSim;
    private boolean mineDepAnti;
    private boolean mineIndepSim;
    private boolean mineIndepAnti;
    private static final boolean DEPENDENT = true;
    private static final boolean INDEPENDENT = false;
    private static final int SIMILAR = 1;
    private static final int ANTI = -1;

    @Override
    public void inferInteractions(Set<SimpleInteraction> interactionSet, physicalEntity A, Model model, Map options) {
        this.mineDepSim = !options.containsKey((Object)BinaryInteractionType.CO_CONTROL_DEPENDENT_SIMILAR) || options.get((Object)BinaryInteractionType.CO_CONTROL_DEPENDENT_SIMILAR).equals(true);
        this.mineDepAnti = !options.containsKey((Object)BinaryInteractionType.CO_CONTROL_DEPENDENT_ANTI) || options.get((Object)BinaryInteractionType.CO_CONTROL_DEPENDENT_ANTI).equals(true);
        this.mineIndepSim = !options.containsKey((Object)BinaryInteractionType.CO_CONTROL_INDEPENDENT_SIMILAR) || options.get((Object)BinaryInteractionType.CO_CONTROL_INDEPENDENT_SIMILAR).equals(true);
        boolean bl = this.mineIndepAnti = !options.containsKey((Object)BinaryInteractionType.CO_CONTROL_INDEPENDENT_ANTI) || options.get((Object)BinaryInteractionType.CO_CONTROL_INDEPENDENT_ANTI).equals(true);
        if (!(this.mineDepSim || this.mineDepAnti || this.mineIndepSim || this.mineIndepAnti)) {
            return;
        }
        for (control ctrl : A.getAllInteractions(control.class)) {
            if (this.mineDepSim) {
                this.iterateControllers(ctrl, A, true, 1, interactionSet);
            }
            if (this.mineDepSim || this.mineDepAnti) {
                this.proceedUpwards(ctrl, A, true, 1, interactionSet);
            }
            int sign = this.getSign(ctrl.getCONTROL_TYPE());
            this.proceedDownwards(ctrl, A, sign, interactionSet);
        }
    }

    private void proceedDownwards(control ctrl, physicalEntity A, int similarity, Set<SimpleInteraction> interactionSet) {
        for (process prcss : ctrl.getCONTROLLED()) {
            if (prcss instanceof control) {
                this.searchDownwards((control)prcss, A, similarity, interactionSet);
            }
            if (!this.mineIndepSim && !this.mineIndepAnti) continue;
            for (control cnt : prcss.isCONTROLLEDOf()) {
                if (cnt == ctrl) continue;
                this.searchUpwards(cnt, A, false, similarity, interactionSet);
            }
        }
    }

    private void searchDownwards(control ctrl, physicalEntity A, int similarity, Set<SimpleInteraction> interactionSet) {
        this.iterateControllers(ctrl, A, true, similarity, interactionSet);
        this.proceedDownwards(ctrl, A, similarity *= this.getSign(ctrl.getCONTROL_TYPE()), interactionSet);
    }

    private void searchUpwards(control ctrl, physicalEntity A, boolean dependent, int similarity, Set<SimpleInteraction> interactionSet) {
        this.iterateControllers(ctrl, A, dependent, similarity *= this.getSign(ctrl.getCONTROL_TYPE()), interactionSet);
        this.proceedUpwards(ctrl, A, dependent, similarity, interactionSet);
    }

    private void iterateControllers(control ctrl, physicalEntity A, boolean dependent, int similarity, Set<SimpleInteraction> interactionSet) {
        if (similarity == 1 && dependent && this.mineDepSim || similarity == -1 && dependent && this.mineDepAnti || similarity == 1 && !dependent && this.mineIndepSim || similarity == -1 && !dependent && this.mineIndepAnti) {
            BinaryInteractionType type = similarity == 1 ? (dependent ? BinaryInteractionType.CO_CONTROL_DEPENDENT_SIMILAR : BinaryInteractionType.CO_CONTROL_INDEPENDENT_SIMILAR) : (dependent ? BinaryInteractionType.CO_CONTROL_DEPENDENT_ANTI : BinaryInteractionType.CO_CONTROL_INDEPENDENT_ANTI);
            for (physicalEntityParticipant pep : ctrl.getCONTROLLER()) {
                physicalEntity B = pep.getPHYSICAL_ENTITY();
                if (B == A) continue;
                interactionSet.add(new SimpleInteraction(A, B, type));
            }
        }
    }

    private void proceedUpwards(control ctrl, physicalEntity A, boolean dependent, int similarity, Set<SimpleInteraction> interactionSet) {
        for (control cnt : ctrl.isCONTROLLEDOf()) {
            this.searchUpwards(cnt, A, dependent, similarity, interactionSet);
        }
    }

    private int getSign(ControlType ctrlType) {
        if (ctrlType == null) {
            return 1;
        }
        if (ctrlType == ControlType.ACTIVATION || ctrlType == ControlType.ACTIVATION_ALLOSTERIC || ctrlType == ControlType.ACTIVATION_NONALLOSTERIC || ctrlType == ControlType.ACTIVATION_UNKMECH) {
            return 1;
        }
        if (ctrlType == ControlType.INHIBITION || ctrlType == ControlType.INHIBITION_ALLOSTERIC || ctrlType == ControlType.INHIBITION_COMPETITIVE || ctrlType == ControlType.INHIBITION_IRREVERSIBLE || ctrlType == ControlType.INHIBITION_NONCOMPETITIVE || ctrlType == ControlType.INHIBITION_OTHER || ctrlType == ControlType.INHIBITION_UNCOMPETITIVE || ctrlType == ControlType.INHIBITION_UNKMECH) {
            return -1;
        }
        throw new RuntimeException("Unknown control type: " + (Object)((Object)ctrlType));
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return Arrays.asList(BinaryInteractionType.CO_CONTROL_INDEPENDENT_SIMILAR, BinaryInteractionType.CO_CONTROL_INDEPENDENT_ANTI, BinaryInteractionType.CO_CONTROL_DEPENDENT_SIMILAR, BinaryInteractionType.CO_CONTROL_DEPENDENT_ANTI);
    }
}

