/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.InteractionRule;
import org.biopax.paxtools.io.sif.SimpleInteraction;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.complex;
import org.biopax.paxtools.model.level2.control;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.process;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlRule
implements InteractionRule {
    @Override
    public void inferInteractions(Set<SimpleInteraction> interactionSet, physicalEntity A, Model model, Map options) {
        boolean mineStatetateChange = !options.containsKey((Object)BinaryInteractionType.CONTROLS_STATE_CHANGE) || options.get((Object)BinaryInteractionType.CONTROLS_STATE_CHANGE).equals(Boolean.TRUE);
        boolean mineMetabolicChange = !options.containsKey((Object)BinaryInteractionType.CONTROLS_METABOLIC_CHANGE) || options.get((Object)BinaryInteractionType.CONTROLS_METABOLIC_CHANGE).equals(Boolean.TRUE);
        for (control inter : A.getAllInteractions(control.class)) {
            for (conversion conv : this.getAffectedConversions(inter, null)) {
                Set<physicalEntity> presenceSet = this.collectEntities(conv.getLEFT(), null);
                this.collectEntities(conv.getRIGHT(), presenceSet);
                List<physicalEntity> left = this.collectSimpleEntities(conv.getLEFT());
                List<physicalEntity> right = this.collectSimpleEntities(conv.getRIGHT());
                ArrayList<physicalEntity> bothsided = new ArrayList<physicalEntity>();
                for (physicalEntity B : left) {
                    if (!right.contains(B)) continue;
                    bothsided.add(B);
                }
                for (physicalEntity B : presenceSet) {
                    if (!this.entityHasAChange(B, conv)) continue;
                    if (B instanceof complex || bothsided.contains(B)) {
                        if (!mineStatetateChange) continue;
                        interactionSet.add(new SimpleInteraction(A, B, BinaryInteractionType.CONTROLS_STATE_CHANGE));
                        continue;
                    }
                    if (!mineMetabolicChange) continue;
                    interactionSet.add(new SimpleInteraction(A, B, BinaryInteractionType.CONTROLS_METABOLIC_CHANGE));
                }
            }
        }
    }

    private List<conversion> getAffectedConversions(control cont, List<conversion> convList) {
        if (convList == null) {
            convList = new ArrayList<conversion>();
        }
        for (process prcss : cont.getCONTROLLED()) {
            if (prcss instanceof conversion) {
                convList.add((conversion)prcss);
                continue;
            }
            if (!(prcss instanceof control)) continue;
            this.getAffectedConversions((control)prcss, convList);
        }
        return convList;
    }

    private Set<physicalEntity> collectEntities(Set<physicalEntityParticipant> partics, Set<physicalEntity> peSet) {
        if (peSet == null) {
            peSet = new HashSet<physicalEntity>();
        }
        for (physicalEntityParticipant partic : partics) {
            peSet.add(partic.getPHYSICAL_ENTITY());
        }
        return peSet;
    }

    private List<physicalEntity> collectSimpleEntities(Set<physicalEntityParticipant> partics) {
        ArrayList<physicalEntity> peList = new ArrayList<physicalEntity>();
        for (physicalEntityParticipant partic : partics) {
            physicalEntity pe = partic.getPHYSICAL_ENTITY();
            if (pe instanceof complex) {
                this.collectSimpleMembersOfComplex(peList, (complex)pe);
                continue;
            }
            peList.add(pe);
        }
        return peList;
    }

    private void collectSimpleMembersOfComplex(List<physicalEntity> list, complex comp) {
        for (physicalEntityParticipant pep : comp.getCOMPONENTS()) {
            physicalEntity pe = pep.getPHYSICAL_ENTITY();
            if (pe instanceof complex) {
                this.collectSimpleMembersOfComplex(list, (complex)pe);
                continue;
            }
            list.add(pe);
        }
    }

    private boolean entityHasAChange(physicalEntity entity2, conversion conv) {
        HashSet<StateWrapper> leftonly = new HashSet<StateWrapper>();
        HashSet<StateWrapper> rightonly = new HashSet<StateWrapper>();
        HashSet<StateWrapper> both = new HashSet<StateWrapper>();
        for (physicalEntityParticipant pep : conv.getLEFT()) {
            if (pep.getPHYSICAL_ENTITY() != entity2) continue;
            leftonly.add(new StateWrapper(pep));
        }
        for (physicalEntityParticipant pep : conv.getRIGHT()) {
            if (pep.getPHYSICAL_ENTITY() != entity2) continue;
            StateWrapper sw = new StateWrapper(pep);
            if (leftonly.contains(sw)) {
                leftonly.remove(sw);
                both.add(sw);
                continue;
            }
            if (both.contains(sw)) continue;
            rightonly.add(sw);
        }
        return !leftonly.isEmpty() || !rightonly.isEmpty();
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return Arrays.asList(BinaryInteractionType.CONTROLS_STATE_CHANGE, BinaryInteractionType.CONTROLS_METABOLIC_CHANGE);
    }

    private class StateWrapper {
        physicalEntityParticipant pep;

        private StateWrapper(physicalEntityParticipant pep) {
            this.pep = pep;
        }

        public int hashCode() {
            return this.pep.stateCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof StateWrapper) {
                StateWrapper sw = (StateWrapper)obj;
                return this.pep.isInEquivalentState(sw.pep);
            }
            return false;
        }
    }
}

