/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif;

import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.model.BioPAXElement;

public class SimpleInteraction {
    BioPAXElement source;
    BioPAXElement target;
    BinaryInteractionType type;

    public SimpleInteraction(BioPAXElement source, BioPAXElement target, BinaryInteractionType type) {
        this.source = source;
        this.target = target;
        this.type = type;
    }

    public BioPAXElement getSource() {
        return this.source;
    }

    public void setSource(BioPAXElement source) {
        this.source = source;
    }

    public BioPAXElement getTarget() {
        return this.target;
    }

    public void setTarget(BioPAXElement target) {
        this.target = target;
    }

    public BinaryInteractionType getType() {
        return this.type;
    }

    public void setType(BinaryInteractionType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleInteraction that = (SimpleInteraction)o;
        return this.checkNullOrEquals((Object)this.type, (Object)that.type) && this.checkParticipants(that);
    }

    private boolean checkParticipants(SimpleInteraction that) {
        boolean equal = false;
        boolean bl = equal = this.checkNullOrEquals(this.source, that.source) && this.checkNullOrEquals(this.target, that.target);
        if (!equal || this.type == null || this.type.isDirected()) {
            equal = this.checkNullOrEquals(this.source, that.target) && this.checkNullOrEquals(this.target, that.source);
        }
        return equal;
    }

    private boolean checkNullOrEquals(Object thisObject, Object thatObject) {
        return thisObject == null ? thatObject == null : thisObject.equals(thatObject);
    }

    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = (this.type.isDirected() ? 31 : 1) * result + (this.target != null ? this.target.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.source.getRDFId() + "\t" + this.type.getTag() + "\t" + this.target.getRDFId();
    }
}

