/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.jena;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.ReusedPEPHelper;
import org.biopax.paxtools.impl.level2.Level2FactoryImpl;
import org.biopax.paxtools.io.jena.JenaEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.Level2Factory;
import org.biopax.paxtools.model.level2.deltaGprimeO;
import org.biopax.paxtools.model.level2.kPrime;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public class JenaIOHandler {
    public static final String PM = "org.biopax.paxtools.model.level2";
    public static final String PM_DOT = "org.biopax.paxtools.model.level2.";
    private static Log log = LogFactory.getLog(JenaIOHandler.class);
    private BioPAXLevel level = BioPAXLevel.L2;
    private HashMap<Object, Individual> objectToIndividualMap;
    private BioPAXFactory factory;
    private EditorMap editorMap;
    private boolean fixReusedPEPs = true;
    private ReusedPEPHelper reusedPEPHelper;
    private boolean convertingFromLevel1ToLevel2 = true;
    private boolean strict = true;

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isFixReusedPEPs() {
        return this.fixReusedPEPs;
    }

    public void setFixReusedPEPs(boolean fixReusedPEPs) {
        this.fixReusedPEPs = fixReusedPEPs;
    }

    public JenaIOHandler() {
        this(null, null);
    }

    public JenaIOHandler(BioPAXFactory factory, BioPAXLevel level) {
        this.level = level == null ? BioPAXLevel.L2 : level;
        this.factory = factory != null ? factory : new Level2FactoryImpl();
        this.editorMap = new JenaEditorMap(this.level);
    }

    public Model convertFromOWL(InputStream in) {
        OntModel ontModel = this.readJenaModel(in);
        return this.convertFromOwl(ontModel);
    }

    public Model convertFromMultipleOwlFiles(String ... files) throws FileNotFoundException {
        Model model = this.factory.createModel();
        for (String file : files) {
            FileInputStream in = new FileInputStream(new File(file));
            this.createAndBind(this.readJenaModel(in), model);
            log.trace((Object)("read file: " + file));
        }
        return model;
    }

    private Model convertFromOwl(OntModel ontModel) {
        Model model = this.factory.createModel();
        this.createAndBind(ontModel, model);
        return model;
    }

    private void createAndBind(OntModel ontModel, Model model) {
        model.getNameSpacePrefixMap().putAll(ontModel.getNsPrefixMap());
        this.createObjects(ontModel, model);
        if (this.fixReusedPEPs) {
            this.reusedPEPHelper = new ReusedPEPHelper(model, (Level2Factory)this.factory);
        }
        try {
            this.bindPropertiesToObjects(ontModel, model);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Conversion failed", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)"Conversion failed", (Throwable)e);
        }
        if (this.fixReusedPEPs) {
            this.reusedPEPHelper.copyPEPFields();
        }
    }

    public void convertToOWL(Model model, OutputStream outputStream) throws FileNotFoundException, IllegalAccessException, InvocationTargetException {
        this.objectToIndividualMap = new HashMap();
        OntModel ontModel = this.initializeEmptyOntModel(model);
        this.createIndividuals(ontModel, model);
        this.bindObjectsToProperties(ontModel, model);
        RDFWriter writer = ontModel.getWriter("RDF/XML-ABBREV");
        writer.setProperty("relativeURIs", (Object)"same-document, relative, parent, absolute");
        String base = model.getNameSpacePrefixMap().get("");
        log.debug((Object)("base = " + base));
        writer.setProperty("xmlbase", (Object)base);
        writer.setProperty("showXmlDeclaration", (Object)"true");
        writer.write((com.hp.hpl.jena.rdf.model.Model)ontModel, outputStream, base);
    }

    private OntModel readJenaModel(InputStream in) {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        ontModel.setStrictMode(true);
        ontModel.getReader().setProperty("error-mode", (Object)"strict");
        ontModel.read(in, "");
        ontModel.loadImports();
        return ontModel;
    }

    private void createObjects(OntModel ontModel, Model model) {
        ExtendedIterator extendedIterator = ontModel.listIndividuals();
        while (extendedIterator.hasNext()) {
            Individual individual = (Individual)extendedIterator.next();
            OntClass ontClass = (OntClass)individual.getRDFType().as(OntClass.class);
            BioPAXElement bp = this.factory.reflectivelyCreate(ontClass.getLocalName());
            bp.setRDFId(individual.getURI());
            log.trace((Object)(ontClass + ":" + bp));
            bp.setRDFId(individual.getURI());
            model.add(bp);
        }
    }

    private void bindPropertiesToObjects(OntModel ontModel, Model model) throws IllegalAccessException, InvocationTargetException {
        ExtendedIterator extendedIterator = ontModel.listIndividuals();
        while (extendedIterator.hasNext()) {
            Individual individual = (Individual)extendedIterator.next();
            BioPAXElement bpe = model.getIdMap().get(individual.getURI());
            StmtIterator stmtIterator = individual.listProperties();
            while (stmtIterator.hasNext()) {
                Statement statement = (Statement)stmtIterator.next();
                Property predicate = statement.getPredicate();
                if (!this.level.isInBioPAXNameSpace(predicate.getNameSpace())) continue;
                try {
                    this.bindProperty(predicate, bpe, individual, model);
                }
                catch (IllegalBioPAXArgumentException e) {
                    if (this.strict) {
                        throw e;
                    }
                    log.warn((Object)("Ignoring property:" + predicate));
                    log.warn((Object)e);
                }
            }
        }
    }

    private void bindProperty(Property predicate, BioPAXElement bpe, Individual individual, Model model) throws IllegalAccessException, InvocationTargetException {
        OntProperty ontProperty = (OntProperty)predicate.as(OntProperty.class);
        PropertyEditor editor = this.editorMap.getEditorForProperty(ontProperty.getLocalName(), bpe.getClass());
        if (editor.isMultipleCardinality()) {
            NodeIterator nodeIterator = individual.listPropertyValues((Property)ontProperty);
            while (nodeIterator.hasNext()) {
                RDFNode propertyValue = (RDFNode)nodeIterator.next();
                this.bindValue(propertyValue, editor, bpe, model);
            }
        } else {
            RDFNode propertyValue = individual.getPropertyValue((Property)ontProperty);
            this.bindValue(propertyValue, editor, bpe, model);
        }
    }

    private void bindValue(RDFNode propertyValue, PropertyEditor editor, BioPAXElement bpe, Model model) throws IllegalAccessException, InvocationTargetException {
        Object value = null;
        if (propertyValue.isResource()) {
            value = model.getIdMap().get(((Resource)propertyValue).getURI());
            if (this.fixReusedPEPs && value instanceof physicalEntityParticipant) {
                value = this.reusedPEPHelper.fixReusedPEP((physicalEntityParticipant)value, bpe);
            }
        } else if (propertyValue.isLiteral()) {
            value = ((Literal)propertyValue).getString();
            if (this.convertingFromLevel1ToLevel2) {
                if (editor.getProperty().equals("DELTA-G")) {
                    deltaGprimeO aDeltaGprime0 = model.addNew(deltaGprimeO.class, bpe.getRDFId() + "-DELTA-G");
                    aDeltaGprime0.setDELTA_G_PRIME_O(Float.valueOf((String)value).floatValue());
                    value = aDeltaGprime0;
                }
                if (editor.getProperty().equals("KEQ")) {
                    kPrime aKPrime = model.addNew(kPrime.class, bpe.getRDFId() + "-KEQ");
                    aKPrime.setK_PRIME(Float.valueOf((String)value).floatValue());
                    value = aKPrime;
                }
            }
        }
        editor.setPropertyToBean(bpe, value);
    }

    private OntModel initializeEmptyOntModel(Model model) {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        String xmlBase = model.getNameSpacePrefixMap().get("");
        if (xmlBase == null || xmlBase.equals("")) {
            xmlBase = "http://biopax.org/paxtools";
        }
        Ontology base = ontModel.createOntology(xmlBase);
        String uri = model.getLevel().getNameSpace();
        uri = uri.substring(0, uri.length() - 1);
        log.debug((Object)("uri = " + uri));
        ontModel.setNsPrefixes(model.getNameSpacePrefixMap());
        base.addImport(ontModel.createResource(uri));
        ontModel.loadImports();
        return ontModel;
    }

    private void createIndividuals(OntModel ontModel, Model model) {
        for (BioPAXElement bp : model.getObjects()) {
            String name = bp.getModelInterface().getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            OntClass ontClass = ontModel.getOntClass(this.level.getNameSpace() + name);
            log.trace((Object)("ontClass = " + ontClass));
            Individual individual = ontModel.createIndividual(bp.getRDFId(), (Resource)ontClass);
            log.trace((Object)("individual = " + individual));
            this.objectToIndividualMap.put(bp, individual);
        }
    }

    private void bindObjectsToProperties(OntModel ontModel, Model model) {
        for (BioPAXElement bean : model.getObjects()) {
            Set<PropertyEditor> beanEditors = this.editorMap.getEditorsOf(bean);
            for (PropertyEditor propertyEditor : beanEditors) {
                this.insertStatement(propertyEditor, bean, ontModel);
            }
        }
    }

    public void insertStatement(PropertyEditor editor, Object bean, OntModel ontModel) {
        Object value = editor.getValueFromBean(bean);
        if (value != null && !editor.isUnknown(value)) {
            if (editor.isMultipleCardinality()) {
                for (Object valueElement : (Set)value) {
                    this.buildStatementFor(bean, editor, valueElement, ontModel);
                }
            } else {
                this.buildStatementFor(bean, editor, value, ontModel);
            }
        }
    }

    private void buildStatementFor(Object bean, PropertyEditor editor, Object value, OntModel ontModel) {
        assert (bean != null && editor != null);
        Property property = ontModel.getProperty(this.level.getNameSpace() + editor.getProperty());
        Individual ind = this.objectToIndividualMap.get(bean);
        Class range = editor.getRange();
        XSDDatatype dataType = ((JenaEditorMap)this.editorMap).getDataTypeFor(editor);
        if (dataType != null) {
            ind.addProperty(property, (RDFNode)ontModel.createTypedLiteral(value.toString(), (RDFDatatype)dataType));
        } else {
            Individual valueInd = this.objectToIndividualMap.get(value);
            if (ind == null) {
                log.error((Object)range);
                log.error((Object)((BioPAXElement)value).getRDFId());
                throw new IllegalBioPAXArgumentException();
            }
            ind.addProperty(property, (RDFNode)valueInd);
        }
    }
}

