/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelImpl
implements Model {
    private Map<String, BioPAXElement> idMap = new HashMap<String, BioPAXElement>();
    private Set<BioPAXElement> objectSet = new HashSet<BioPAXElement>();
    private Map<String, String> nameSpacePrefixMap = new HashMap<String, String>();
    private BioPAXLevel level;
    private transient BioPAXFactory factory;
    private Map<String, BioPAXElement> exposedIdMap;
    private Set<BioPAXElement> exposedObjectSet;

    ModelImpl(BioPAXLevel level) {
        this(level.getDefaultFactory());
    }

    ModelImpl(BioPAXFactory factory) {
        this.factory = factory;
        this.level = factory.getLevel();
        this.exposedIdMap = Collections.unmodifiableMap(this.idMap);
        this.exposedObjectSet = Collections.unmodifiableSet(this.objectSet);
    }

    @Override
    public Map<String, BioPAXElement> getIdMap() {
        return this.exposedIdMap;
    }

    @Override
    public Map<String, String> getNameSpacePrefixMap() {
        return this.nameSpacePrefixMap;
    }

    @Override
    public void setFactory(BioPAXFactory factory) {
        this.factory = factory;
    }

    @Override
    public Set<BioPAXElement> getObjects() {
        return this.exposedObjectSet;
    }

    @Override
    public <T extends BioPAXElement> Set<T> getObjects(Class<T> filterBy) {
        return new ClassFilterSet<T>(this.objectSet, filterBy);
    }

    @Override
    public void remove(BioPAXElement aBioPAXElement) {
        this.idMap.remove(aBioPAXElement.getRDFId());
        this.objectSet.remove(aBioPAXElement);
    }

    @Override
    public <T extends BioPAXElement> T addNew(Class<T> c, String id) {
        T paxElement = this.factory.reflectivelyCreate(c);
        this.setIdAndAdd((BioPAXElement)paxElement, id);
        return paxElement;
    }

    @Override
    public boolean contains(BioPAXElement aBioPAXElement) {
        return this.idMap.get(aBioPAXElement.getRDFId()) == aBioPAXElement;
    }

    private void setIdAndAdd(BioPAXElement bp, String id) {
        bp.setRDFId(id);
        this.add(bp);
    }

    @Override
    public void add(BioPAXElement aBioPAXElement) {
        String rdfId = aBioPAXElement.getRDFId();
        if (!this.level.hasElement(aBioPAXElement)) {
            throw new IllegalBioPAXArgumentException("Given object is of wrong level");
        }
        if (rdfId == null) {
            throw new IllegalBioPAXArgumentException("null ID: every object must have an RDF ID");
        }
        if (this.idMap.containsKey(rdfId)) {
            throw new IllegalBioPAXArgumentException("I already have an object with the same ID: " + rdfId + ". Try removing it first");
        }
        if (this.contains(aBioPAXElement)) {
            throw new IllegalBioPAXArgumentException("duplicate element:" + aBioPAXElement);
        }
        this.objectSet.add(aBioPAXElement);
        this.idMap.put(rdfId, aBioPAXElement);
    }

    @Override
    public BioPAXLevel getLevel() {
        return this.level;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.factory = this.level.getDefaultFactory();
    }
}

