/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectPropertyEditor
extends PropertyEditor {
    private HashMap<Class, Set<Class>> restrictedRanges = new HashMap();

    public ObjectPropertyEditor(String property, Method getMethod, Class<? extends BioPAXElement> domain, Class range, boolean multipleCardinality) {
        super(property, getMethod, domain, range, multipleCardinality);
    }

    public HashMap<Class, Set<Class>> getRestrictedRanges() {
        return this.restrictedRanges;
    }

    public void addRangeRestriction(Class domain, Set<Class> ranges) {
        this.restrictedRanges.put(domain, ranges);
    }

    @Override
    protected void checkRestrictions(Object bean, Object value) {
        super.checkRestrictions(bean, value);
        Set<Class> classes = this.getRestrictedRangesFor(((BioPAXElement)bean).getModelInterface());
        if (classes != null && !this.isInstanceOfAtLeastOne(classes, value)) {
            throw new IllegalBioPAXArgumentException("The range restriction is violated \n" + value + "-->" + bean);
        }
    }

    public Set<Class> getRestrictedRangesFor(Class restrictedDomain) {
        Set<Class> classes = this.restrictedRanges.get(restrictedDomain);
        if (classes == null) {
            classes = new HashSet<Class>();
            classes.add(this.range);
        }
        return classes;
    }

    @Override
    public void setPropertyToBean(Object bean, Object value) {
        super.setPropertyToBean(bean, value);
    }
}

