/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.model.level2.conversion;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConversionScore
implements Comparable {
    private conversion conv1;
    private conversion conv2;
    private Double score;
    private boolean reverseMatch;
    private Map<physicalEntityParticipant, physicalEntityParticipant> pepMap;

    public ConversionScore(conversion conv1, conversion conv2, Double score, Map<physicalEntityParticipant, physicalEntityParticipant> pepMap, boolean reverseMatch) {
        this.conv1 = conv1;
        this.conv2 = conv2;
        this.score = score;
        this.reverseMatch = reverseMatch;
        this.pepMap = pepMap;
    }

    public Double getScore() {
        return this.score;
    }

    public conversion getConversion1() {
        return this.conv1;
    }

    public conversion getConversion2() {
        return this.conv2;
    }

    public boolean isReverseMatch() {
        return this.reverseMatch;
    }

    public physicalEntityParticipant getMatch(physicalEntityParticipant pep1) {
        return this.pepMap.get(pep1);
    }

    public Set<physicalEntityParticipant> getMatchedPEPs() {
        return this.pepMap.keySet();
    }

    public int compareTo(Object obj) {
        ConversionScore that = (ConversionScore)obj;
        if (this.getScore() > that.getScore()) {
            return 1;
        }
        if (this.getScore() < that.getScore()) {
            return -1;
        }
        return 0;
    }
}

