/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.geneontology.util.StringUtil;

public class SwingUtil {
    public static int NONE = 0;
    public static int TOP = 1;
    public static int BOTTOM = 2;
    public static int LEFT = 4;
    public static int RIGHT = 8;

    protected SwingUtil() {
    }

    public static String getComboBoxValue(JComboBox comp) {
        String selectedPath = comp.getSelectedItem().toString();
        if (selectedPath == null || !selectedPath.equals(comp.getEditor().getItem())) {
            selectedPath = comp.getEditor().getItem().toString();
        }
        return selectedPath;
    }

    public static void setPreferredWidth(JComponent component, int width) {
        component.setPreferredSize(new Dimension(width, component.getPreferredSize().height));
    }

    public static void setPreferredHeight(JComponent component, int height) {
        component.setPreferredSize(new Dimension(component.getPreferredSize().width, height));
    }

    protected static String getHexDigit(int val) {
        if (val < 10) {
            return String.valueOf(val);
        }
        if (val == 10) {
            return "A";
        }
        if (val == 11) {
            return "B";
        }
        if (val == 12) {
            return "C";
        }
        if (val == 13) {
            return "D";
        }
        if (val == 14) {
            return "E";
        }
        if (val == 15) {
            return "F";
        }
        return null;
    }

    protected static int getHexVal(char digit) {
        if (Character.isDigit(digit = Character.toUpperCase(digit))) {
            return digit - 48;
        }
        return 10 + (digit - 65);
    }

    public static Color getColor(String htmlCode) {
        int out = 0;
        if ((htmlCode = htmlCode.trim()).startsWith("#")) {
            htmlCode = htmlCode.substring(1, 7);
        }
        int i = 0;
        while (i < htmlCode.length()) {
            out = (int)((double)out + Math.pow(16.0, htmlCode.length() - i - 1) * (double)SwingUtil.getHexVal(htmlCode.charAt(i)));
            ++i;
        }
        return new Color(out);
    }

    public static String getHTMLCode(Color color) {
        StringBuffer out = new StringBuffer();
        out.append(SwingUtil.getHexDigit(color.getRed() / 16));
        out.append(SwingUtil.getHexDigit(color.getRed() % 16));
        out.append(SwingUtil.getHexDigit(color.getGreen() / 16));
        out.append(SwingUtil.getHexDigit(color.getGreen() % 16));
        out.append(SwingUtil.getHexDigit(color.getBlue() / 16));
        out.append(SwingUtil.getHexDigit(color.getBlue() % 16));
        return out.toString();
    }

    public static String getHTMLFontStyle(Font font) {
        StringBuffer out = new StringBuffer();
        out.append("font-size: " + font.getSize() + "px; ");
        out.append("font-family: " + font.getSize() + "; ");
        if (font.isItalic()) {
            out.append("font-style: italic; ");
        }
        if (font.isBold()) {
            out.append("font-weight: bold; ");
        }
        return out.toString();
    }

    public static int withinInsets(Point p, Insets insets, Component c) {
        if (insets == null || p == null || c == null || !c.contains(p)) {
            return NONE;
        }
        int out = 0;
        if (p.x < insets.left) {
            out |= LEFT;
        } else if (p.x > c.getSize().width - insets.right) {
            out |= RIGHT;
        }
        if (p.y < insets.bottom) {
            out |= TOP;
        } else if (p.y > c.getSize().height - insets.top) {
            out |= BOTTOM;
        }
        return out;
    }

    public static boolean isVectorFont(Font font) {
        GlyphVector gv = font.createGlyphVector(new FontRenderContext(null, true, false), "Test");
        Shape fontShape = gv.getOutline();
        Rectangle2D bounds = fontShape.getBounds2D();
        return bounds.getWidth() != 0.0 || bounds.getHeight() != 0.0;
    }

    public static boolean isChildPath(TreePath child, TreePath parent) {
        Object[] childArr = child.getPath();
        Object[] parentArr = parent.getPath();
        if (childArr.length == 0 || childArr.length > parentArr.length) {
            return false;
        }
        int i = 0;
        while (i < childArr.length) {
            if (!childArr[i].equals(parentArr[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void printTreeModel(TreeModel model) {
        SwingUtil.printTreeModel(System.err, model);
    }

    public static void printTreeModel(PrintStream out, TreeModel model) {
        SwingUtil.printTreeModel(out, model.getRoot(), 0, model, new Hashtable());
    }

    private static void printTreeModel(PrintStream out, Object current, int depth, TreeModel model, Hashtable seen) {
        out.print(StringUtil.repeat(" ", depth));
        out.println(current);
        if (seen.containsKey(current)) {
            return;
        }
        seen.put(current, current);
        int count = model.getChildCount(current);
        int i = 0;
        while (i < count) {
            SwingUtil.printTreeModel(out, model.getChild(current, i), depth + 2, model, seen);
            ++i;
        }
    }

    public static void center(Window win) {
        Dimension screenSize = win.getToolkit().getScreenSize();
        Dimension windowSize = win.getSize();
        int x = (screenSize.width - windowSize.width) / 2;
        int y = (screenSize.height - windowSize.height) / 2;
        win.setLocation(x, y);
    }

    public static ComponentUI getUI(JComponent component) {
        try {
            Method method = component.getClass().getMethod("getUI", new Class[0]);
            Object o = method.invoke((Object)component, new Object[0]);
            if (o instanceof ComponentUI) {
                return (ComponentUI)o;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void sizeToPreferred(JDialog dialog) {
        Dimension preferredSize = dialog.getContentPane().getPreferredSize();
        dialog.setSize(preferredSize);
    }

    public static void sizeToPreferred(Component comp) {
        Dimension preferredSize = comp.getPreferredSize();
        comp.setSize(preferredSize);
    }

    public static void blockUntilImagePrepared(Image in) {
        while (!Toolkit.getDefaultToolkit().prepareImage(in, -1, -1, null)) {
            Thread.currentThread();
            Thread.yield();
        }
    }

    public static void collapseTree(JTree tree, TreePath path) {
        HashSet<TreePath> pathSet = new HashSet<TreePath>();
        pathSet.add(path);
        Enumeration<TreePath> e = tree.getExpandedDescendants(path);
        while (e != null && e.hasMoreElements()) {
            TreePath currentPath = e.nextElement();
            while (currentPath != null && path.isDescendant(currentPath) && currentPath.getPathCount() > 0) {
                pathSet.add(currentPath);
                currentPath = currentPath.getParentPath();
            }
        }
        Vector paths = new Vector(pathSet);
        Comparator pathSorter = new Comparator(){

            public int compare(Object a, Object b) {
                TreePath ta = (TreePath)a;
                TreePath tb = (TreePath)b;
                if (ta.getPathCount() > tb.getPathCount()) {
                    return -1;
                }
                if (ta.getPathCount() < tb.getPathCount()) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(paths, pathSorter);
        int i = 0;
        while (i < paths.size()) {
            TreePath p = (TreePath)paths.elementAt(i);
            tree.collapsePath(p);
            ++i;
        }
    }

    public static void collapseTree(JTree tree) {
        SwingUtil.collapseTree(tree, new TreePath(tree.getModel().getRoot()));
    }

    public static void expandTree(JTree tree) {
        SwingUtil.expandTree(tree, new TreePath(tree.getModel().getRoot()));
    }

    public static void expandTree(JTree tree, TreePath path) {
        SwingUtil.expandTree(tree, path, new Hashtable());
    }

    protected static void expandTree(JTree tree, TreePath path, Hashtable lookedAt) {
        Object node = path.getLastPathComponent();
        if (lookedAt.containsKey(node)) {
            return;
        }
        lookedAt.put(node, node);
        Vector paths = new Vector();
        tree.makeVisible(path);
        int childCount = tree.getModel().getChildCount(node);
        int i = 0;
        while (i < childCount) {
            Object child = tree.getModel().getChild(node, i);
            TreePath p = path.pathByAddingChild(child);
            SwingUtil.expandTree(tree, p, lookedAt);
            ++i;
        }
    }

    public static boolean existsInModel(TreeModel model, TreePath path) {
        Object[] objects = path.getPath();
        if (!objects[0].equals(model.getRoot())) {
            return false;
        }
        Object prev = objects[0];
        int i = 1;
        while (i < objects.length) {
            if (model.getIndexOfChild(prev, objects[i]) < 0) {
                return false;
            }
            prev = objects[i];
            ++i;
        }
        return true;
    }

    public static String imageObserverInfoflagToString(int infoflag) {
        String out = "";
        if ((infoflag & 0x80) == 128) {
            out = String.valueOf(out) + "ABORT ";
        }
        if ((infoflag & 0x20) == 32) {
            out = String.valueOf(out) + "ALLBITS ";
        }
        if ((infoflag & 0x40) == 64) {
            out = String.valueOf(out) + "ERROR ";
        }
        if ((infoflag & 0x10) == 16) {
            out = String.valueOf(out) + "FRAMEBITS ";
        }
        if ((infoflag & 2) == 2) {
            out = String.valueOf(out) + "HEIGHT ";
        }
        if ((infoflag & 4) == 4) {
            out = String.valueOf(out) + "PROPERTIES ";
        }
        if ((infoflag & 8) == 8) {
            out = String.valueOf(out) + "SOMEBITS ";
        }
        if ((infoflag & 1) == 1) {
            out = String.valueOf(out) + "WIDTH ";
        }
        return out;
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    public static Component getDescendantWithName(Component c, String name) {
        if (c.getName() != null && c.getName().equals(name)) {
            return c;
        }
        if (c instanceof Container) {
            int i = 0;
            while (i < ((Container)c).getComponentCount()) {
                Component out = SwingUtil.getDescendantWithName(((Container)c).getComponent(i), name);
                if (out != null) {
                    return out;
                }
                ++i;
            }
            return null;
        }
        return null;
    }

    public static Collection getAllDescendants(Container c, Class findClass) {
        return SwingUtil.getAllDescendants(c, findClass, false);
    }

    public static Collection getAllDescendants(Container c, Class findClass, boolean deep) {
        LinkedList results = new LinkedList();
        SwingUtil.fillAllDescendants(c, findClass, deep, results);
        return results;
    }

    protected static void fillAllDescendants(Container c, Class findClass, boolean deep, Collection results) {
        if (findClass.isInstance(c)) {
            results.add(c);
            if (!deep) {
                return;
            }
        }
        int i = 0;
        while (i < c.getComponentCount()) {
            Component comp = c.getComponent(i);
            if (comp instanceof Container) {
                SwingUtil.fillAllDescendants((Container)comp, findClass, deep, results);
            }
            ++i;
        }
    }

    public static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        int c = 0;
        while (c < cols) {
            Spring width = Spring.constant(0);
            int r = 0;
            while (r < rows) {
                width = Spring.max(width, SwingUtil.getConstraintsForCell(r, c, parent, cols).getWidth());
                ++r;
            }
            r = 0;
            while (r < rows) {
                SpringLayout.Constraints constraints = SwingUtil.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
                ++r;
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
            ++c;
        }
        Spring y = Spring.constant(initialY);
        int r = 0;
        while (r < rows) {
            Spring height = Spring.constant(0);
            int c2 = 0;
            while (c2 < cols) {
                height = Spring.max(height, SwingUtil.getConstraintsForCell(r, c2, parent, cols).getHeight());
                ++c2;
            }
            c2 = 0;
            while (c2 < cols) {
                SpringLayout.Constraints constraints = SwingUtil.getConstraintsForCell(r, c2, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
                ++c2;
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
            ++r;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    public static List getListData(JList jlist) {
        ArrayList out = new ArrayList();
        ListModel model = jlist.getModel();
        int i = 0;
        while (i < model.getSize()) {
            out.add(model.getElementAt(i));
            ++i;
        }
        return out;
    }

    public static Cursor buildCursorByTrimming(Image image, String name, Cursor defaultCursor) {
        return SwingUtil.buildCursorByTrimming(image, 0, 0, name, defaultCursor);
    }

    public static Cursor buildCursorByTrimming(Image image, int x, int y, String name, Cursor defaultCursor) {
        return SwingUtil.buildCursorByTrimming(Toolkit.getDefaultToolkit(), image, x, y, name, defaultCursor);
    }

    public static Cursor buildCursorByTrimming(Toolkit toolkit, Image image, int x, int y, String name, Cursor defaultCursor) {
        Dimension d = toolkit.getBestCursorSize(image.getWidth(null), image.getHeight(null));
        if (d == null || d.getWidth() <= 0.0 || d.getHeight() <= 0.0) {
            return defaultCursor;
        }
        BufferedImage out = new BufferedImage((int)d.getWidth(), (int)d.getHeight(), 2);
        out.getGraphics().drawImage(image, 0, 0, null);
        return toolkit.createCustomCursor(out, new Point(x, y), name);
    }
}

