/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.web.struts.controller;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import uk.ac.ebi.ook.config.ConfigurationManager;
import uk.ac.ebi.ook.graph.GraphMaker;
import uk.ac.ebi.ook.web.struts.view.DisplayTermForm;

public class DisplayTermAction
extends Action {
    private Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$web$struts$controller$DisplayTermAction == null ? (class$uk$ac$ebi$ook$web$struts$controller$DisplayTermAction = DisplayTermAction.class$("uk.ac.ebi.ook.web.struts.controller.DisplayTermAction")) : class$uk$ac$ebi$ook$web$struts$controller$DisplayTermAction));
    private static final String PNG_MIME_TYPE = "image/png";
    private static final String SVG_MIME_TYPE = "image/svg+xml";
    private static final String SVG_PARAM = "svg";
    static /* synthetic */ Class class$uk$ac$ebi$ook$web$struts$controller$DisplayTermAction;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DisplayTermForm dtf = (DisplayTermForm)form;
            if (dtf != null) {
                String termId = dtf.getTermId();
                String termName = dtf.getTermName();
                String ontologyName = dtf.getOntologyName();
                GraphMaker gm = new GraphMaker(dtf.getGraphType(), termId, termName, ontologyName);
                byte[] imgData = this.generateImageFile(gm.toDot(), dtf.getOutputFormat());
                if (imgData != null) {
                    if (dtf.getOutputFormat() == null || dtf.getOutputFormat() != null && !dtf.getOutputFormat().equalsIgnoreCase(SVG_PARAM)) {
                        response.setContentType(PNG_MIME_TYPE);
                    } else {
                        response.setContentType(SVG_MIME_TYPE);
                    }
                    response.setContentLength(imgData.length);
                    response.getOutputStream().write(imgData);
                    return null;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("DisplayTermAction caught error: " + e.getMessage()), (Throwable)e);
            return mapping.findForward("error");
        }
        return mapping.findForward("init");
    }

    private byte[] generateImageFile(String dotSource, String outputFormat) {
        byte[] img_stream = null;
        try {
            File dot = File.createTempFile("graph_", ".dot.tmp");
            dot.deleteOnExit();
            FileWriter fout = new FileWriter(dot);
            fout.write(dotSource);
            fout.close();
            File img = File.createTempFile("graph_", ".png");
            img.deleteOnExit();
            String format = " -Tpng ";
            if (outputFormat != null && outputFormat.equalsIgnoreCase(SVG_PARAM)) {
                format = " -Tsvg ";
            }
            String exeStr = ConfigurationManager.getProperty("dot.executable");
            String cmd = exeStr + format + dot.getAbsolutePath() + " -o" + img.getAbsolutePath();
            Process p = Runtime.getRuntime().exec(cmd);
            StreamReader sr = new StreamReader(p.getErrorStream());
            sr.run();
            p.waitFor();
            FileInputStream in = new FileInputStream(img.getAbsolutePath());
            img_stream = new byte[in.available()];
            in.read(img_stream);
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ioe) {
            this.logger.error((Object)"Could not produce image file", (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            this.logger.error((Object)"Process interrupted in dot conversion", (Throwable)ie);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error in processing of dot.", (Throwable)e);
        }
        return img_stream;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class StreamReader
    extends Thread {
        BufferedReader br;
        ByteArrayOutputStream output;

        public String toString() {
            return this.output.toString();
        }

        public StreamReader(InputStream is) {
            this.br = new BufferedReader(new InputStreamReader(is));
            this.output = new ByteArrayOutputStream();
        }

        public void run() {
            try {
                String line;
                while ((line = this.br.readLine()) != null) {
                    this.output.write(line.getBytes());
                }
                this.br.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

