/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.persistence.query;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import uk.ac.ebi.ook.model.interfaces.Ontology;
import uk.ac.ebi.ook.model.ojb.LoaderRunBean;
import uk.ac.ebi.ook.model.ojb.OntologyBean;
import uk.ac.ebi.ook.persistence.exceptions.PersistenceException;
import uk.ac.ebi.ook.persistence.query.AbstractQueryHandler;

public final class OntologyQueryHandler
extends AbstractQueryHandler {
    private static Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$persistence$query$OntologyQueryHandler == null ? (class$uk$ac$ebi$ook$persistence$query$OntologyQueryHandler = OntologyQueryHandler.class$("uk.ac.ebi.ook.persistence.query.OntologyQueryHandler")) : class$uk$ac$ebi$ook$persistence$query$OntologyQueryHandler));
    static /* synthetic */ Class class$uk$ac$ebi$ook$persistence$query$OntologyQueryHandler;
    static /* synthetic */ Class class$uk$ac$ebi$ook$model$ojb$OntologyBean;
    static /* synthetic */ Class class$uk$ac$ebi$ook$model$ojb$TermBean;
    static /* synthetic */ Class class$uk$ac$ebi$ook$model$ojb$LoaderRunBean;

    public OntologyQueryHandler(String dbAlias) {
        super(dbAlias);
    }

    public OntologyQueryHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Ontology getOntology(String name) {
        OntologyBean retval;
        block8: {
            retval = null;
            logger.debug((Object)("Retrieving ontology " + name));
            Criteria criteria = new Criteria();
            criteria.addEqualTo("shortOntologyName", (Object)name);
            criteria.addEqualTo("fullyLoaded", (Object)Boolean.TRUE);
            QueryByCriteria query = new QueryByCriteria(class$uk$ac$ebi$ook$model$ojb$OntologyBean == null ? (class$uk$ac$ebi$ook$model$ojb$OntologyBean = OntologyQueryHandler.class$("uk.ac.ebi.ook.model.ojb.OntologyBean")) : class$uk$ac$ebi$ook$model$ojb$OntologyBean, criteria, false);
            this.initializeBroker();
            retval = (OntologyBean)this.objectQuery((Query)query);
            Object var7_5 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getOntology failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block8;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getAllOntologies failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var7_6 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getOntology failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getOntology failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeOntology(Ontology ontology, boolean batchMode) throws PersistenceException {
        logger.debug((Object)"Storing ontology");
        try {
            try {
                this.initializeBroker();
                this.setBatchMode(batchMode);
                this.persistObject(ontology);
                logger.debug((Object)"Cleared cache after loading ontology");
                this.clearCache();
            }
            catch (PersistenceException pe) {
                logger.error((Object)("storeOntology failed on persist: " + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                this.releaseBroker();
                throw throwable;
            }
            catch (PersistenceException pe) {
                logger.fatal((Object)("storeOntology failed on broker release: " + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
        }
        try {}
        catch (PersistenceException pe) {
            logger.fatal((Object)("storeOntology failed on broker release: " + pe.getMessage()), (Throwable)pe);
            throw pe;
        }
        this.releaseBroker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection getAllTermsFromOntology(String name) {
        ArrayList retval;
        block10: {
            retval = null;
            logger.debug((Object)("Retrieving ontology " + name));
            Criteria criteria = new Criteria();
            criteria.addEqualTo("shortOntologyName", (Object)name);
            criteria.addEqualTo("fullyLoaded", (Object)Boolean.TRUE);
            QueryByCriteria query = new QueryByCriteria(class$uk$ac$ebi$ook$model$ojb$OntologyBean == null ? (class$uk$ac$ebi$ook$model$ojb$OntologyBean = OntologyQueryHandler.class$("uk.ac.ebi.ook.model.ojb.OntologyBean")) : class$uk$ac$ebi$ook$model$ojb$OntologyBean, criteria, false);
            this.initializeBroker();
            OntologyBean ont = (OntologyBean)this.objectQuery((Query)query);
            if (ont != null) {
                retval = new ArrayList();
                Collection tmp = ont.getTerms();
                Iterator i = tmp.iterator();
                while (i.hasNext()) {
                    retval.add(i.next());
                }
            }
            Object var9_9 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getAllTermsFromOntology failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block10;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getAllTermsFromOntology failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var9_10 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getAllTermsFromOntology failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getAllTermsFromOntology failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection getAllTermReportFromOntology(String name) {
        ArrayList retval;
        block9: {
            retval = null;
            logger.debug((Object)("Retrieving all terms for ontology '" + name + "'."));
            Criteria criteria = new Criteria();
            criteria.addEqualTo("parentOntology.fullyLoaded", (Object)Boolean.TRUE);
            criteria.addEqualTo("parentOntology.shortOntologyName", (Object)name);
            ReportQueryByCriteria query = QueryFactory.newReportQuery((Class)(class$uk$ac$ebi$ook$model$ojb$TermBean == null ? (class$uk$ac$ebi$ook$model$ojb$TermBean = OntologyQueryHandler.class$("uk.ac.ebi.ook.model.ojb.TermBean")) : class$uk$ac$ebi$ook$model$ojb$TermBean), (Criteria)criteria, (boolean)true);
            query.setAttributes(new String[]{"identifier", "name", "definition", "obsolete"});
            query.addOrderByAscending("identifier");
            this.initializeBroker();
            retval = new ArrayList();
            Iterator it = this.reportQuery((Query)query);
            while (it.hasNext()) {
                retval.add(it.next());
            }
            Object var7_7 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getAllTermReportFromOntology failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            }
            break block9;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getAllTermReportFromOntology failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var7_8 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getAllTermReportFromOntology failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getAllTermReportFromOntology failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getAllOntologies() {
        logger.debug((Object)"Retrieving ontologies");
        Criteria criteria = new Criteria();
        criteria.addEqualTo("fullyLoaded", (Object)Boolean.TRUE);
        QueryByCriteria query = new QueryByCriteria(class$uk$ac$ebi$ook$model$ojb$OntologyBean == null ? (class$uk$ac$ebi$ook$model$ojb$OntologyBean = OntologyQueryHandler.class$("uk.ac.ebi.ook.model.ojb.OntologyBean")) : class$uk$ac$ebi$ook$model$ojb$OntologyBean, criteria, false);
        Collection retval = null;
        try {
            try {
                this.initializeBroker();
                retval = this.collectionQuery((Query)query);
            }
            catch (PersistenceException pe) {
                logger.error((Object)("getAllOntologies failed on query: " + pe.getMessage()), (Throwable)pe);
                Object var6_5 = null;
                try {
                    this.releaseBroker();
                    return retval;
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getAllOntologies failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    return null;
                }
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {}
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getAllOntologies failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                return null;
            }
            this.releaseBroker();
            throw throwable;
        }
        try {}
        catch (PersistenceException pe2) {
            logger.fatal((Object)("getAllOntologies failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            return null;
        }
        this.releaseBroker();
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateLoadedFlag(OntologyBean ontology, boolean flag) throws PersistenceException {
        if (ontology == null) {
            return false;
        }
        logger.debug((Object)("Updating flag for " + ontology.getShortOntologyName()));
        boolean retval = false;
        try {
            try {
                this.initializeBroker();
                ontology.setFullyLoaded(flag);
                this.updateBeanFieldsOnly(ontology);
                retval = true;
            }
            catch (PersistenceException pe) {
                logger.error((Object)("updateLoadedFlag failed to update the object" + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                this.releaseBroker();
                throw throwable;
            }
            catch (PersistenceException pe) {
                logger.fatal((Object)("updateLoadedFlag failed on broker release: " + pe.getMessage()), (Throwable)pe);
                return false;
            }
        }
        try {}
        catch (PersistenceException pe) {
            logger.fatal((Object)("updateLoadedFlag failed on broker release: " + pe.getMessage()), (Throwable)pe);
            return false;
        }
        this.releaseBroker();
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean switchLoadedFlag(String ontologyName) throws PersistenceException {
        logger.debug((Object)("Updating flags for " + ontologyName));
        boolean retval = false;
        try {
            try {
                this.initializeBroker();
                this.beginTransaction();
                Connection conn = this.getConnection();
                logger.debug((Object)"Got JDBC connection");
                conn.createStatement().execute("update ontology set fully_loaded='2' where fully_loaded='1' and shortName='" + ontologyName + "'");
                conn.createStatement().execute("update ontology set fully_loaded='1' where fully_loaded='0' and shortName='" + ontologyName + "'");
                conn.createStatement().execute("update ontology set fully_loaded='0' where fully_loaded='2' and shortName='" + ontologyName + "'");
                this.commitTransaction();
                logger.debug((Object)("Switched flags for " + ontologyName));
                this.clearCache();
                retval = true;
            }
            catch (PersistenceException pe) {
                logger.error((Object)("switchLoadedFlag failed during flag switch: " + pe.getMessage()), (Throwable)pe);
                this.rollbackTransaction();
                throw pe;
            }
            catch (Exception sqle) {
                logger.error((Object)("switchLoadedFlag failed during flag switch: " + sqle.getMessage()), (Throwable)sqle);
                throw new PersistenceException(sqle.getMessage(), sqle);
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                this.releaseBroker();
                throw throwable;
            }
            catch (PersistenceException pe) {
                logger.fatal((Object)("switchLoadedFlag failed during broker release: " + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
        }
        try {}
        catch (PersistenceException pe) {
            logger.fatal((Object)("switchLoadedFlag failed during broker release: " + pe.getMessage()), (Throwable)pe);
            throw pe;
        }
        this.releaseBroker();
        return retval;
    }

    public Collection getOntologyReport() {
        return this.getOntologyReport(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getOntologyReport(String ontologyName, boolean isFullyLoaded) {
        logger.debug((Object)("Generating report for " + ontologyName));
        Criteria criteria = new Criteria();
        criteria.addEqualTo("fullyLoaded", (Object)new Boolean(isFullyLoaded));
        if (ontologyName != null) {
            criteria.addEqualTo("shortOntologyName", (Object)ontologyName);
        }
        ReportQueryByCriteria report = QueryFactory.newReportQuery((Class)(class$uk$ac$ebi$ook$model$ojb$OntologyBean == null ? (class$uk$ac$ebi$ook$model$ojb$OntologyBean = OntologyQueryHandler.class$("uk.ac.ebi.ook.model.ojb.OntologyBean")) : class$uk$ac$ebi$ook$model$ojb$OntologyBean), (Criteria)criteria);
        report.setAttributes(new String[]{"ontologyId", "shortOntologyName", "fullOntologyName", "loadDate", "queryURL", "sourceURL", "version"});
        ArrayList retval = new ArrayList();
        try {
            try {
                this.initializeBroker();
                Iterator iter = this.reportQuery((Query)report);
                while (iter.hasNext()) {
                    retval.add(iter.next());
                }
                Object var8_8 = null;
            }
            catch (PersistenceException pe) {
                logger.error((Object)("getOntologyReport failed on query: " + pe.getMessage()), (Throwable)pe);
                Object var8_9 = null;
                try {
                    this.releaseBroker();
                    return retval;
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getOntologyReport failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                    return null;
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {}
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getOntologyReport failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
                return null;
            }
            this.releaseBroker();
            throw throwable;
        }
        try {}
        catch (PersistenceException pe2) {
            logger.fatal((Object)("getOntologyReport failed on broker release: " + pe2.getMessage()), (Throwable)pe2);
            return null;
        }
        this.releaseBroker();
        return retval;
    }

    public Collection getOntologyReport(String ontologyName) {
        return this.getOntologyReport(ontologyName, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteOntology(String shortOntologyName) throws PersistenceException {
        logger.debug((Object)("Retrieving ontology:" + shortOntologyName));
        boolean retval = false;
        try {
            try {
                this.initializeBroker();
                Criteria criteria = new Criteria();
                criteria.addEqualTo("shortOntologyName", (Object)shortOntologyName);
                QueryByCriteria query = new QueryByCriteria(class$uk$ac$ebi$ook$model$ojb$OntologyBean == null ? (class$uk$ac$ebi$ook$model$ojb$OntologyBean = OntologyQueryHandler.class$("uk.ac.ebi.ook.model.ojb.OntologyBean")) : class$uk$ac$ebi$ook$model$ojb$OntologyBean, criteria, false);
                OntologyBean ont = (OntologyBean)this.strictObjectQuery((Query)query);
                if (ont != null) {
                    logger.debug((Object)"found ontology");
                    this.deleteObject(ont);
                    logger.debug((Object)"deleted ontology");
                    retval = true;
                }
            }
            catch (PersistenceException pe) {
                logger.error((Object)("deleteOntology failed to delete: " + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                this.releaseBroker();
                throw throwable;
            }
            catch (PersistenceException pe) {
                logger.fatal((Object)("deleteOntology failed on broker release:" + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
        }
        try {}
        catch (PersistenceException pe) {
            logger.fatal((Object)("deleteOntology failed on broker release:" + pe.getMessage()), (Throwable)pe);
            throw pe;
        }
        this.releaseBroker();
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean rawSQLDeleteOntology(long ontologyId, boolean useOracleSyntax) throws PersistenceException {
        logger.debug((Object)("Deleting ontology:" + ontologyId));
        boolean retval = false;
        try {
            try {
                this.initializeBroker();
                this.beginTransaction();
                Connection conn = this.getConnection();
                logger.debug((Object)"Got JDBC connection");
                if (useOracleSyntax) {
                    logger.warn((Object)"rawSQLDeleteOntology: Using Oracle SQL Syntax");
                    PreparedStatement stmt = conn.prepareStatement("delete from (select * from term_path where ontology_id = ?)");
                    stmt.setLong(1, ontologyId);
                    stmt.execute();
                    logger.warn((Object)"PATHS deleted");
                    stmt = conn.prepareStatement("delete from (select * from term_relationship where ontology_id = ?)");
                    stmt.setLong(1, ontologyId);
                    stmt.execute();
                    logger.warn((Object)"RELATIONSHIPS deleted");
                    stmt = conn.prepareStatement("delete from (select * from term_synonym ts, term t where ts.term_id = t.term_id and t.ontology_id = ?)");
                    stmt.setLong(1, ontologyId);
                    stmt.execute();
                    logger.warn((Object)"SYNONYMS deleted");
                    stmt = conn.prepareStatement("delete from (select * from annotation ts, term t where ts.term_id = t.term_id and t.ontology_id = ?)");
                    stmt.setLong(1, ontologyId);
                    stmt.execute();
                    logger.warn((Object)"ANNOTATIONS deleted");
                    stmt = conn.prepareStatement("delete from (select * from dbxref ts, term t where ts.term_id = t.term_id and t.ontology_id = ?)");
                    stmt.setLong(1, ontologyId);
                    stmt.execute();
                    logger.warn((Object)"XREFS deleted");
                    stmt = conn.prepareStatement("delete from (select * from term where ontology_id = ?)");
                    stmt.setLong(1, ontologyId);
                    stmt.execute();
                    logger.warn((Object)"TERMS deleted");
                    stmt = conn.prepareStatement("delete from (select * from ontology where ontology_id = ?)");
                    stmt.setLong(1, ontologyId);
                    stmt.execute();
                    logger.warn((Object)"ONTOLOGY deleted");
                } else {
                    logger.warn((Object)"rawSQLDeleteOntology: Using ANSI SQL Syntax");
                    PreparedStatement stmt = conn.prepareStatement("delete from term_path where ontology_id = ?");
                    stmt.setLong(1, ontologyId);
                    stmt.execute();
                    logger.warn((Object)"PATHS deleted");
                    stmt = conn.prepareStatement("delete from term_relationship where ontology_id = ?");
                    stmt.setLong(1, ontologyId);
                    stmt.execute();
                    logger.warn((Object)"RELATIONSHIPS deleted");
                    stmt = conn.prepareStatement("delete ts.* from term_synonym ts, term t where ts.term_id = t.term_id and t.ontology_id = ?");
                    stmt.setLong(1, ontologyId);
                    stmt.execute();
                    logger.warn((Object)"SYNONYMS deleted");
                    stmt = conn.prepareStatement("delete ts.* from annotation ts, term t where ts.term_id = t.term_id and t.ontology_id = ?");
                    stmt.setLong(1, ontologyId);
                    stmt.execute();
                    logger.warn((Object)"ANNOTATIONS deleted");
                    stmt = conn.prepareStatement("delete ts.* from dbxref ts, term t where ts.term_id = t.term_id and t.ontology_id = ?");
                    stmt.setLong(1, ontologyId);
                    stmt.execute();
                    logger.warn((Object)"XREFS deleted");
                    stmt = conn.prepareStatement("delete from term where ontology_id = ?");
                    stmt.setLong(1, ontologyId);
                    stmt.execute();
                    logger.warn((Object)"TERMS deleted");
                    stmt = conn.prepareStatement("delete from ontology where ontology_id = ?");
                    stmt.setLong(1, ontologyId);
                    stmt.execute();
                    logger.warn((Object)"ONTOLOGY deleted");
                }
                this.commitTransaction();
                logger.debug((Object)("Deleted ontology: " + ontologyId));
                this.clearCache();
                retval = true;
            }
            catch (PersistenceException pe) {
                logger.error((Object)("rawSQLDeleteOntology failed: " + pe.getMessage()), (Throwable)pe);
                this.rollbackTransaction();
                throw pe;
            }
            catch (Exception sqle) {
                logger.error((Object)("rawSQLDeleteOntology failed: " + sqle.getMessage()), (Throwable)sqle);
                throw new PersistenceException(sqle.getMessage(), sqle);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                this.releaseBroker();
                throw throwable;
            }
            catch (PersistenceException pe) {
                logger.fatal((Object)("switchLoadedFlag failed during broker release: " + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
        }
        try {}
        catch (PersistenceException pe) {
            logger.fatal((Object)("switchLoadedFlag failed during broker release: " + pe.getMessage()), (Throwable)pe);
            throw pe;
        }
        this.releaseBroker();
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteOntology(long ontologyId) throws PersistenceException {
        logger.debug((Object)("Retrieving ontology:" + ontologyId));
        boolean retval = false;
        try {
            try {
                this.initializeBroker();
                Criteria criteria = new Criteria();
                criteria.addEqualTo("ontologyId", (Object)new Long(ontologyId));
                QueryByCriteria query = new QueryByCriteria(class$uk$ac$ebi$ook$model$ojb$OntologyBean == null ? (class$uk$ac$ebi$ook$model$ojb$OntologyBean = OntologyQueryHandler.class$("uk.ac.ebi.ook.model.ojb.OntologyBean")) : class$uk$ac$ebi$ook$model$ojb$OntologyBean, criteria, false);
                OntologyBean ont = (OntologyBean)this.objectQuery((Query)query);
                if (ont != null) {
                    logger.debug((Object)"found ontology");
                    this.deleteObject(ont);
                    logger.debug((Object)"deleted ontology");
                    retval = true;
                }
            }
            catch (PersistenceException pe) {
                logger.error((Object)("deleteOntology failed on delete: " + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                this.releaseBroker();
                throw throwable;
            }
            catch (PersistenceException pe) {
                logger.fatal((Object)("deleteOntology failed on broker release: " + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
        }
        try {}
        catch (PersistenceException pe) {
            logger.fatal((Object)("deleteOntology failed on broker release: " + pe.getMessage()), (Throwable)pe);
            throw pe;
        }
        this.releaseBroker();
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteOntology(OntologyBean ontology) throws PersistenceException {
        if (ontology == null) {
            return false;
        }
        logger.debug((Object)("Retrieving ontology:" + ontology.getShortOntologyName()));
        boolean retval = false;
        try {
            try {
                this.initializeBroker();
                this.deleteObject(ontology);
                logger.debug((Object)("Deleted ontology: " + ontology.getShortOntologyName()));
                retval = true;
            }
            catch (PersistenceException pe) {
                logger.error((Object)("deleteOntology failed on delete: " + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                this.releaseBroker();
                throw throwable;
            }
            catch (PersistenceException pe) {
                logger.fatal((Object)("deleteOntology failed on broker release: " + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
        }
        try {}
        catch (PersistenceException pe) {
            logger.fatal((Object)("deleteOntology failed on broker release: " + pe.getMessage()), (Throwable)pe);
            throw pe;
        }
        this.releaseBroker();
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int getOntologyTermCount(String ontologyName) {
        int retval;
        block9: {
            retval = -1;
            this.initializeBroker();
            Criteria criteria = new Criteria();
            criteria.addEqualTo("parentOntology.fullyLoaded", (Object)Boolean.TRUE);
            if (ontologyName != null) {
                criteria.addEqualTo("parentOntology.shortOntologyName", (Object)ontologyName);
            }
            QueryByCriteria query = new QueryByCriteria(class$uk$ac$ebi$ook$model$ojb$TermBean == null ? (class$uk$ac$ebi$ook$model$ojb$TermBean = OntologyQueryHandler.class$("uk.ac.ebi.ook.model.ojb.TermBean")) : class$uk$ac$ebi$ook$model$ojb$TermBean, criteria, true);
            retval = this.countQuery((Query)query);
            Object var6_6 = null;
            try {
                this.releaseBroker();
            }
            catch (PersistenceException pe2) {
                logger.fatal((Object)("getTermsById failed on broker release; " + pe2.getMessage()), (Throwable)pe2);
            }
            break block9;
            {
                catch (PersistenceException pe) {
                    logger.error((Object)("getTermsById failed on query: " + pe.getMessage()), (Throwable)pe);
                    Object var6_7 = null;
                    try {
                        this.releaseBroker();
                    }
                    catch (PersistenceException pe2) {
                        logger.fatal((Object)("getTermsById failed on broker release; " + pe2.getMessage()), (Throwable)pe2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    this.releaseBroker();
                }
                catch (PersistenceException pe2) {
                    logger.fatal((Object)("getTermsById failed on broker release; " + pe2.getMessage()), (Throwable)pe2);
                }
                throw throwable;
            }
        }
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean storeStats(LoaderRunBean stats) throws PersistenceException {
        if (stats == null) {
            return false;
        }
        logger.debug((Object)"Storing stats");
        boolean retval = false;
        try {
            try {
                this.initializeBroker();
                this.persistObject(stats);
                retval = true;
            }
            catch (PersistenceException pe) {
                logger.error((Object)("storeStats failed on persist: " + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                this.releaseBroker();
                throw throwable;
            }
            catch (PersistenceException pe) {
                logger.fatal((Object)("storeStats failed on broker release; " + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
        }
        try {}
        catch (PersistenceException pe) {
            logger.fatal((Object)("storeStats failed on broker release; " + pe.getMessage()), (Throwable)pe);
            throw pe;
        }
        this.releaseBroker();
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getMonthyStats(int month, int year) throws PersistenceException {
        logger.debug((Object)"Retrieving montly stats");
        Collection retval = new ArrayList();
        try {
            try {
                this.initializeBroker();
                Criteria criteria = new Criteria();
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(new java.util.Date());
                calendar.set(5, 1);
                calendar.set(10, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                if (month > -1) {
                    calendar.set(2, month);
                }
                if (year > -1) {
                    calendar.set(1, year);
                }
                int currentMonth = calendar.get(2);
                Date monthDate = new Date(calendar.getTimeInMillis());
                criteria.addGreaterOrEqualThan((Object)"runDate", (Object)monthDate);
                ((Calendar)calendar).roll(2, 1);
                if (currentMonth > calendar.get(2)) {
                    ((Calendar)calendar).roll(1, 1);
                }
                Date followingMonthDate = new Date(calendar.getTimeInMillis());
                criteria.addLessThan((Object)"runDate", (Object)followingMonthDate);
                QueryByCriteria query = new QueryByCriteria(class$uk$ac$ebi$ook$model$ojb$LoaderRunBean == null ? (class$uk$ac$ebi$ook$model$ojb$LoaderRunBean = OntologyQueryHandler.class$("uk.ac.ebi.ook.model.ojb.LoaderRunBean")) : class$uk$ac$ebi$ook$model$ojb$LoaderRunBean, criteria, true);
                retval = this.collectionQuery((Query)query);
            }
            catch (PersistenceException pe) {
                logger.error((Object)("getMonthyStats failed on persist: " + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                this.releaseBroker();
                throw throwable;
            }
            catch (PersistenceException pe) {
                logger.fatal((Object)("getMonthyStats failed on broker release; " + pe.getMessage()), (Throwable)pe);
                throw pe;
            }
        }
        try {}
        catch (PersistenceException pe) {
            logger.fatal((Object)("getMonthyStats failed on broker release; " + pe.getMessage()), (Throwable)pe);
            throw pe;
        }
        this.releaseBroker();
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

