/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.loader.newt;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.log4j.Logger;
import org.apache.regexp.RE;
import uk.ac.ebi.ook.loader.newt.SynHolder;

public class NEWTParser {
    private static Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$loader$newt$NEWTParser == null ? (class$uk$ac$ebi$ook$loader$newt$NEWTParser = NEWTParser.class$("uk.ac.ebi.ook.loader.newt.NEWTParser")) : class$uk$ac$ebi$ook$loader$newt$NEWTParser));
    public static final String NULL_CHAR = "\\N";
    private HashMap nodeStorage = null;
    private MultiMap nameStorage = new MultiHashMap();
    private HashMap annotationStorage = null;
    private RE namesRegex = null;
    private String nodeFile = null;
    private String nameFile = null;
    static /* synthetic */ Class class$uk$ac$ebi$ook$loader$newt$NEWTParser;

    public NEWTParser(String nodeFile, String nameFile) {
        this.nodeStorage = new HashMap();
        this.annotationStorage = new HashMap();
        this.namesRegex = new RE("^([0-9]*)\t(.*)\t.*\t([0-9-]*)");
        this.nodeFile = nodeFile;
        this.nameFile = nameFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse() {
        boolean retval = false;
        try {
            if (this.nodeFile != null) {
                if (this.nameFile != null) {
                    retval = this.parseNodes(this.nodeFile);
                    retval = retval && this.parseNames(this.nameFile);
                    return retval;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            retval = false;
            return retval;
        }
        finally {
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseNodes(String lineageFile) {
        String oneLine;
        boolean retval = false;
        BufferedReader in = null;
        int counter = 0;
        in = new BufferedReader(new FileReader(lineageFile));
        while ((oneLine = in.readLine()) != null) {
            this.processNodeLine(oneLine);
            if (++counter % 25000 != 0) continue;
            logger.warn((Object)("Processed Nodes: " + counter));
        }
        retval = true;
        Object var7_7 = null;
        if (in == null) return retval;
        try {
            in.close();
            return retval;
        }
        catch (Exception e) {}
        return retval;
        {
            catch (IOException ioe) {
                logger.error((Object)ioe.getMessage(), (Throwable)ioe);
                retval = false;
                Object var7_8 = null;
                if (in == null) return retval;
                try {
                    in.close();
                    return retval;
                }
                catch (Exception e) {}
                return retval;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void processNodeLine(String oneLine) {
        String[] values = oneLine.split("\t", 6);
        if (values != null) {
            String tax_id = values[0];
            String parent = values[1];
            String rank = values[4];
            if (parent.equals(NULL_CHAR)) {
                parent = null;
            }
            String tmp = this.nodeStorage.put(tax_id, parent);
            this.annotationStorage.put(tax_id, rank);
            if (tmp != null) {
                logger.warn((Object)("Previous entry already entered for " + tax_id));
            }
        } else {
            logger.warn((Object)("Node line could not be parsed: " + oneLine));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseNames(String namesFile) {
        String oneLine;
        boolean retval = false;
        BufferedReader in = null;
        int counter = 0;
        in = new BufferedReader(new FileReader(namesFile));
        while ((oneLine = in.readLine()) != null) {
            this.processNameLine(oneLine);
            if (++counter % 50000 != 0) continue;
            logger.warn((Object)("Processed Names: " + counter));
        }
        retval = true;
        Object var7_7 = null;
        if (in == null) return retval;
        try {
            in.close();
            return retval;
        }
        catch (Exception e) {}
        return retval;
        {
            catch (IOException ioe) {
                logger.error((Object)ioe.getMessage(), (Throwable)ioe);
                retval = false;
                Object var7_8 = null;
                if (in == null) return retval;
                try {
                    in.close();
                    return retval;
                }
                catch (Exception e) {}
                return retval;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void processNameLine(String oneLine) {
        if (this.namesRegex.match(oneLine)) {
            String tax_id = this.namesRegex.getParen(1);
            String name = this.namesRegex.getParen(2);
            String priority = this.namesRegex.getParen(3);
            this.nameStorage.put((Object)tax_id, (Object)new SynHolder(Integer.parseInt(priority), name));
        } else {
            logger.warn((Object)("Name line could not be parsed: " + oneLine));
        }
    }

    public MultiMap getNames() {
        return this.nameStorage;
    }

    public HashMap getNodes() {
        return this.nodeStorage;
    }

    public HashMap getAnnotations() {
        return this.annotationStorage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

